use std::{fs, path::PathBuf};

#[test]
fn test_merge() {
    // The files in this test were generated by version 0.21.1 of the python client and have a
    // counter, a gauge, and a histogram across 5 PIDs that were all inc/set/observed to 1.0.
    let mut d = PathBuf::from(env!("CARGO_MANIFEST_DIR"));
    d.push("tests/dbfiles");

    let files: Vec<String> = fs::read_dir(d)
        .unwrap()
        .filter_map(|res| res.ok())
        .map(|dir| dir.path())
        .filter(|f| f.extension().map_or(false, |ext| ext == "db"))
        .map(|f| f.display().to_string())
        .collect();

    let result = prometheus_client_python_speedups::merge_internal(&files);
    assert!(result.is_ok());

    let metrics = result.unwrap();
    assert_eq!(3, metrics.len());

    for metric in metrics {
        match metric.name.as_str() {
            "h" => {
                assert_eq!("help", metric.documentation);
                assert_eq!("histogram", metric.typ);
                assert_eq!(
                    5.0,
                    metric
                        .samples
                        .iter()
                        .find(|sample| sample.name == "h_count")
                        .unwrap()
                        .value
                );
                assert_eq!(
                    5.0,
                    metric
                        .samples
                        .iter()
                        .find(|sample| sample.name == "h_sum")
                        .unwrap()
                        .value
                );
                let buckets: Vec<_> = metric
                    .samples
                    .iter()
                    .filter(|sample| sample.labels.contains_key("le"))
                    .collect();
                assert!(!buckets.is_empty());
                assert!(buckets.iter().all(|sample| {
                    let le: f64 = sample.labels.get("le").unwrap().parse().unwrap();
                    // All observations were made at 1.0 so make sure buckets look correct.
                    if le < 1.0 {
                        sample.value == 0.0
                    } else {
                        sample.value == 5.0
                    }
                }));
            }
            "g" => {
                assert_eq!("help", metric.documentation);
                assert_eq!("gauge", metric.typ);
                assert_eq!(1, metric.samples.len());
                assert_eq!(1.0, metric.samples[0].value);
            }
            "c" => {
                assert_eq!("help", metric.documentation);
                assert_eq!("counter", metric.typ);
                assert_eq!(1, metric.samples.len());
                assert_eq!(5.0, metric.samples[0].value);
            }
            _ => {
                panic!("unexpected metric: {}", metric.name)
            }
        }
    }
}
