# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from properly_model_python.models.base_model_ import Model
from properly_model_python.models.image import Image  # noqa: F401,E501
from properly_model_python.models.model_property import ModelProperty  # noqa: F401,E501
from properly_model_python.models.room import Room  # noqa: F401,E501
from properly_model_python import util


class SoldProperty(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, id: str=None, address: str=None, postal_code: str=None, community: str=None, properly_city_code: str=None, zone: str=None, yr_built: int=None, living_space_square_footage_ag: int=None, lot_size: float=None, land_use_code: str=None, assessed_value: float=None, tax_amount: float=None, building_type: str=None, style: str=None, basement_development: str=None, basement_percent_development: float=None, basement: List[str]=None, bedrooms_total: float=None, bedrooms_ag: float=None, bedrooms_with_closet: float=None, master_walk_in: bool=None, master_ensuite: bool=None, bathrooms_full: float=None, bathrooms_half: float=None, bathrooms_main: float=None, bathrooms_basement: float=None, room_number: float=None, kitchen_countertops: List[str]=None, kitchen_island: bool=None, kitchen_appliances: List[str]=None, kitchen_layout: str=None, flooring: List[str]=None, fireplace: List[str]=None, heating_type: List[str]=None, backyard_details: str=None, exterior: List[str]=None, parking: List[str]=None, total_parking: float=None, enclosed_parking: float=None, roof_type: str=None, roof_age_years: int=None, is_renovated: bool=None, renovations_or_upgrades: str=None, property_photos_user_submitted: str=None, latitude: float=None, longitude: float=None, google_place_id: str=None, geo_hash5: str=None, geo_hash12: str=None, images: List[Image]=None, rooms: List[Room]=None, close_price: float=None, original_list_price: float=None, sold_date: str=None, dom: float=None):  # noqa: E501
        """SoldProperty - a model defined in Swagger

        :param id: The id of this SoldProperty.  # noqa: E501
        :type id: str
        :param address: The address of this SoldProperty.  # noqa: E501
        :type address: str
        :param postal_code: The postal_code of this SoldProperty.  # noqa: E501
        :type postal_code: str
        :param community: The community of this SoldProperty.  # noqa: E501
        :type community: str
        :param properly_city_code: The properly_city_code of this SoldProperty.  # noqa: E501
        :type properly_city_code: str
        :param zone: The zone of this SoldProperty.  # noqa: E501
        :type zone: str
        :param yr_built: The yr_built of this SoldProperty.  # noqa: E501
        :type yr_built: int
        :param living_space_square_footage_ag: The living_space_square_footage_ag of this SoldProperty.  # noqa: E501
        :type living_space_square_footage_ag: int
        :param lot_size: The lot_size of this SoldProperty.  # noqa: E501
        :type lot_size: float
        :param land_use_code: The land_use_code of this SoldProperty.  # noqa: E501
        :type land_use_code: str
        :param assessed_value: The assessed_value of this SoldProperty.  # noqa: E501
        :type assessed_value: float
        :param tax_amount: The tax_amount of this SoldProperty.  # noqa: E501
        :type tax_amount: float
        :param building_type: The building_type of this SoldProperty.  # noqa: E501
        :type building_type: str
        :param style: The style of this SoldProperty.  # noqa: E501
        :type style: str
        :param basement_development: The basement_development of this SoldProperty.  # noqa: E501
        :type basement_development: str
        :param basement_percent_development: The basement_percent_development of this SoldProperty.  # noqa: E501
        :type basement_percent_development: float
        :param basement: The basement of this SoldProperty.  # noqa: E501
        :type basement: List[str]
        :param bedrooms_total: The bedrooms_total of this SoldProperty.  # noqa: E501
        :type bedrooms_total: float
        :param bedrooms_ag: The bedrooms_ag of this SoldProperty.  # noqa: E501
        :type bedrooms_ag: float
        :param bedrooms_with_closet: The bedrooms_with_closet of this SoldProperty.  # noqa: E501
        :type bedrooms_with_closet: float
        :param master_walk_in: The master_walk_in of this SoldProperty.  # noqa: E501
        :type master_walk_in: bool
        :param master_ensuite: The master_ensuite of this SoldProperty.  # noqa: E501
        :type master_ensuite: bool
        :param bathrooms_full: The bathrooms_full of this SoldProperty.  # noqa: E501
        :type bathrooms_full: float
        :param bathrooms_half: The bathrooms_half of this SoldProperty.  # noqa: E501
        :type bathrooms_half: float
        :param bathrooms_main: The bathrooms_main of this SoldProperty.  # noqa: E501
        :type bathrooms_main: float
        :param bathrooms_basement: The bathrooms_basement of this SoldProperty.  # noqa: E501
        :type bathrooms_basement: float
        :param room_number: The room_number of this SoldProperty.  # noqa: E501
        :type room_number: float
        :param kitchen_countertops: The kitchen_countertops of this SoldProperty.  # noqa: E501
        :type kitchen_countertops: List[str]
        :param kitchen_island: The kitchen_island of this SoldProperty.  # noqa: E501
        :type kitchen_island: bool
        :param kitchen_appliances: The kitchen_appliances of this SoldProperty.  # noqa: E501
        :type kitchen_appliances: List[str]
        :param kitchen_layout: The kitchen_layout of this SoldProperty.  # noqa: E501
        :type kitchen_layout: str
        :param flooring: The flooring of this SoldProperty.  # noqa: E501
        :type flooring: List[str]
        :param fireplace: The fireplace of this SoldProperty.  # noqa: E501
        :type fireplace: List[str]
        :param heating_type: The heating_type of this SoldProperty.  # noqa: E501
        :type heating_type: List[str]
        :param backyard_details: The backyard_details of this SoldProperty.  # noqa: E501
        :type backyard_details: str
        :param exterior: The exterior of this SoldProperty.  # noqa: E501
        :type exterior: List[str]
        :param parking: The parking of this SoldProperty.  # noqa: E501
        :type parking: List[str]
        :param total_parking: The total_parking of this SoldProperty.  # noqa: E501
        :type total_parking: float
        :param enclosed_parking: The enclosed_parking of this SoldProperty.  # noqa: E501
        :type enclosed_parking: float
        :param roof_type: The roof_type of this SoldProperty.  # noqa: E501
        :type roof_type: str
        :param roof_age_years: The roof_age_years of this SoldProperty.  # noqa: E501
        :type roof_age_years: int
        :param is_renovated: The is_renovated of this SoldProperty.  # noqa: E501
        :type is_renovated: bool
        :param renovations_or_upgrades: The renovations_or_upgrades of this SoldProperty.  # noqa: E501
        :type renovations_or_upgrades: str
        :param property_photos_user_submitted: The property_photos_user_submitted of this SoldProperty.  # noqa: E501
        :type property_photos_user_submitted: str
        :param latitude: The latitude of this SoldProperty.  # noqa: E501
        :type latitude: float
        :param longitude: The longitude of this SoldProperty.  # noqa: E501
        :type longitude: float
        :param google_place_id: The google_place_id of this SoldProperty.  # noqa: E501
        :type google_place_id: str
        :param geo_hash5: The geo_hash5 of this SoldProperty.  # noqa: E501
        :type geo_hash5: str
        :param geo_hash12: The geo_hash12 of this SoldProperty.  # noqa: E501
        :type geo_hash12: str
        :param images: The images of this SoldProperty.  # noqa: E501
        :type images: List[Image]
        :param rooms: The rooms of this SoldProperty.  # noqa: E501
        :type rooms: List[Room]
        :param close_price: The close_price of this SoldProperty.  # noqa: E501
        :type close_price: float
        :param original_list_price: The original_list_price of this SoldProperty.  # noqa: E501
        :type original_list_price: float
        :param sold_date: The sold_date of this SoldProperty.  # noqa: E501
        :type sold_date: str
        :param dom: The dom of this SoldProperty.  # noqa: E501
        :type dom: float
        """
        self.swagger_types = {
            'id': str,
            'address': str,
            'postal_code': str,
            'community': str,
            'properly_city_code': str,
            'zone': str,
            'yr_built': int,
            'living_space_square_footage_ag': int,
            'lot_size': float,
            'land_use_code': str,
            'assessed_value': float,
            'tax_amount': float,
            'building_type': str,
            'style': str,
            'basement_development': str,
            'basement_percent_development': float,
            'basement': List[str],
            'bedrooms_total': float,
            'bedrooms_ag': float,
            'bedrooms_with_closet': float,
            'master_walk_in': bool,
            'master_ensuite': bool,
            'bathrooms_full': float,
            'bathrooms_half': float,
            'bathrooms_main': float,
            'bathrooms_basement': float,
            'room_number': float,
            'kitchen_countertops': List[str],
            'kitchen_island': bool,
            'kitchen_appliances': List[str],
            'kitchen_layout': str,
            'flooring': List[str],
            'fireplace': List[str],
            'heating_type': List[str],
            'backyard_details': str,
            'exterior': List[str],
            'parking': List[str],
            'total_parking': float,
            'enclosed_parking': float,
            'roof_type': str,
            'roof_age_years': int,
            'is_renovated': bool,
            'renovations_or_upgrades': str,
            'property_photos_user_submitted': str,
            'latitude': float,
            'longitude': float,
            'google_place_id': str,
            'geo_hash5': str,
            'geo_hash12': str,
            'images': List[Image],
            'rooms': List[Room],
            'close_price': float,
            'original_list_price': float,
            'sold_date': str,
            'dom': float
        }

        self.attribute_map = {
            'id': 'id',
            'address': 'address',
            'postal_code': 'postalCode',
            'community': 'community',
            'properly_city_code': 'properlyCityCode',
            'zone': 'zone',
            'yr_built': 'yrBuilt',
            'living_space_square_footage_ag': 'livingSpaceSquareFootageAG',
            'lot_size': 'lotSize',
            'land_use_code': 'landUseCode',
            'assessed_value': 'assessedValue',
            'tax_amount': 'taxAmount',
            'building_type': 'buildingType',
            'style': 'style',
            'basement_development': 'basementDevelopment',
            'basement_percent_development': 'basementPercentDevelopment',
            'basement': 'basement',
            'bedrooms_total': 'bedroomsTotal',
            'bedrooms_ag': 'bedroomsAG',
            'bedrooms_with_closet': 'bedroomsWithCloset',
            'master_walk_in': 'masterWalkIn',
            'master_ensuite': 'masterEnsuite',
            'bathrooms_full': 'bathroomsFull',
            'bathrooms_half': 'bathroomsHalf',
            'bathrooms_main': 'bathroomsMain',
            'bathrooms_basement': 'bathroomsBasement',
            'room_number': 'roomNumber',
            'kitchen_countertops': 'kitchenCountertops',
            'kitchen_island': 'kitchenIsland',
            'kitchen_appliances': 'kitchenAppliances',
            'kitchen_layout': 'kitchenLayout',
            'flooring': 'flooring',
            'fireplace': 'fireplace',
            'heating_type': 'heatingType',
            'backyard_details': 'backyardDetails',
            'exterior': 'exterior',
            'parking': 'parking',
            'total_parking': 'totalParking',
            'enclosed_parking': 'enclosedParking',
            'roof_type': 'roofType',
            'roof_age_years': 'roofAgeYears',
            'is_renovated': 'isRenovated',
            'renovations_or_upgrades': 'renovationsOrUpgrades',
            'property_photos_user_submitted': 'propertyPhotosUserSubmitted',
            'latitude': 'latitude',
            'longitude': 'longitude',
            'google_place_id': 'googlePlaceId',
            'geo_hash5': 'geoHash5',
            'geo_hash12': 'geoHash12',
            'images': 'images',
            'rooms': 'rooms',
            'close_price': 'closePrice',
            'original_list_price': 'originalListPrice',
            'sold_date': 'soldDate',
            'dom': 'dom'
        }

        self._id = id
        self._address = address
        self._postal_code = postal_code
        self._community = community
        self._properly_city_code = properly_city_code
        self._zone = zone
        self._yr_built = yr_built
        self._living_space_square_footage_ag = living_space_square_footage_ag
        self._lot_size = lot_size
        self._land_use_code = land_use_code
        self._assessed_value = assessed_value
        self._tax_amount = tax_amount
        self._building_type = building_type
        self._style = style
        self._basement_development = basement_development
        self._basement_percent_development = basement_percent_development
        self._basement = basement
        self._bedrooms_total = bedrooms_total
        self._bedrooms_ag = bedrooms_ag
        self._bedrooms_with_closet = bedrooms_with_closet
        self._master_walk_in = master_walk_in
        self._master_ensuite = master_ensuite
        self._bathrooms_full = bathrooms_full
        self._bathrooms_half = bathrooms_half
        self._bathrooms_main = bathrooms_main
        self._bathrooms_basement = bathrooms_basement
        self._room_number = room_number
        self._kitchen_countertops = kitchen_countertops
        self._kitchen_island = kitchen_island
        self._kitchen_appliances = kitchen_appliances
        self._kitchen_layout = kitchen_layout
        self._flooring = flooring
        self._fireplace = fireplace
        self._heating_type = heating_type
        self._backyard_details = backyard_details
        self._exterior = exterior
        self._parking = parking
        self._total_parking = total_parking
        self._enclosed_parking = enclosed_parking
        self._roof_type = roof_type
        self._roof_age_years = roof_age_years
        self._is_renovated = is_renovated
        self._renovations_or_upgrades = renovations_or_upgrades
        self._property_photos_user_submitted = property_photos_user_submitted
        self._latitude = latitude
        self._longitude = longitude
        self._google_place_id = google_place_id
        self._geo_hash5 = geo_hash5
        self._geo_hash12 = geo_hash12
        self._images = images
        self._rooms = rooms
        self._close_price = close_price
        self._original_list_price = original_list_price
        self._sold_date = sold_date
        self._dom = dom

    @classmethod
    def from_dict(cls, dikt) -> 'SoldProperty':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The SoldProperty of this SoldProperty.  # noqa: E501
        :rtype: SoldProperty
        """
        return util.deserialize_model(dikt, cls)

    @property
    def id(self) -> str:
        """Gets the id of this SoldProperty.


        :return: The id of this SoldProperty.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str):
        """Sets the id of this SoldProperty.


        :param id: The id of this SoldProperty.
        :type id: str
        """

        self._id = id

    @property
    def address(self) -> str:
        """Gets the address of this SoldProperty.

        The address of the home.  # noqa: E501

        :return: The address of this SoldProperty.
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address: str):
        """Sets the address of this SoldProperty.

        The address of the home.  # noqa: E501

        :param address: The address of this SoldProperty.
        :type address: str
        """
        if address is None:
            raise ValueError("Invalid value for `address`, must not be `None`")  # noqa: E501

        self._address = address

    @property
    def postal_code(self) -> str:
        """Gets the postal_code of this SoldProperty.

        Postal code of the home.  # noqa: E501

        :return: The postal_code of this SoldProperty.
        :rtype: str
        """
        return self._postal_code

    @postal_code.setter
    def postal_code(self, postal_code: str):
        """Sets the postal_code of this SoldProperty.

        Postal code of the home.  # noqa: E501

        :param postal_code: The postal_code of this SoldProperty.
        :type postal_code: str
        """

        self._postal_code = postal_code

    @property
    def community(self) -> str:
        """Gets the community of this SoldProperty.

        The community of the home.  # noqa: E501

        :return: The community of this SoldProperty.
        :rtype: str
        """
        return self._community

    @community.setter
    def community(self, community: str):
        """Sets the community of this SoldProperty.

        The community of the home.  # noqa: E501

        :param community: The community of this SoldProperty.
        :type community: str
        """

        self._community = community

    @property
    def properly_city_code(self) -> str:
        """Gets the properly_city_code of this SoldProperty.

        Internal code to represent the city  # noqa: E501

        :return: The properly_city_code of this SoldProperty.
        :rtype: str
        """
        return self._properly_city_code

    @properly_city_code.setter
    def properly_city_code(self, properly_city_code: str):
        """Sets the properly_city_code of this SoldProperty.

        Internal code to represent the city  # noqa: E501

        :param properly_city_code: The properly_city_code of this SoldProperty.
        :type properly_city_code: str
        """

        self._properly_city_code = properly_city_code

    @property
    def zone(self) -> str:
        """Gets the zone of this SoldProperty.

        The zone the community is located.  # noqa: E501

        :return: The zone of this SoldProperty.
        :rtype: str
        """
        return self._zone

    @zone.setter
    def zone(self, zone: str):
        """Sets the zone of this SoldProperty.

        The zone the community is located.  # noqa: E501

        :param zone: The zone of this SoldProperty.
        :type zone: str
        """

        self._zone = zone

    @property
    def yr_built(self) -> int:
        """Gets the yr_built of this SoldProperty.

        The year the home was built.  # noqa: E501

        :return: The yr_built of this SoldProperty.
        :rtype: int
        """
        return self._yr_built

    @yr_built.setter
    def yr_built(self, yr_built: int):
        """Sets the yr_built of this SoldProperty.

        The year the home was built.  # noqa: E501

        :param yr_built: The yr_built of this SoldProperty.
        :type yr_built: int
        """
        if yr_built is None:
            raise ValueError("Invalid value for `yr_built`, must not be `None`")  # noqa: E501

        self._yr_built = yr_built

    @property
    def living_space_square_footage_ag(self) -> int:
        """Gets the living_space_square_footage_ag of this SoldProperty.


        :return: The living_space_square_footage_ag of this SoldProperty.
        :rtype: int
        """
        return self._living_space_square_footage_ag

    @living_space_square_footage_ag.setter
    def living_space_square_footage_ag(self, living_space_square_footage_ag: int):
        """Sets the living_space_square_footage_ag of this SoldProperty.


        :param living_space_square_footage_ag: The living_space_square_footage_ag of this SoldProperty.
        :type living_space_square_footage_ag: int
        """

        self._living_space_square_footage_ag = living_space_square_footage_ag

    @property
    def lot_size(self) -> float:
        """Gets the lot_size of this SoldProperty.

        How would you describe your lot size? * Below Average -> 0.8 * Average -> 1.0 * Above Average -> 1.2   # noqa: E501

        :return: The lot_size of this SoldProperty.
        :rtype: float
        """
        return self._lot_size

    @lot_size.setter
    def lot_size(self, lot_size: float):
        """Sets the lot_size of this SoldProperty.

        How would you describe your lot size? * Below Average -> 0.8 * Average -> 1.0 * Above Average -> 1.2   # noqa: E501

        :param lot_size: The lot_size of this SoldProperty.
        :type lot_size: float
        """

        self._lot_size = lot_size

    @property
    def land_use_code(self) -> str:
        """Gets the land_use_code of this SoldProperty.

        The land use code of the home. Varies by geography.  # noqa: E501

        :return: The land_use_code of this SoldProperty.
        :rtype: str
        """
        return self._land_use_code

    @land_use_code.setter
    def land_use_code(self, land_use_code: str):
        """Sets the land_use_code of this SoldProperty.

        The land use code of the home. Varies by geography.  # noqa: E501

        :param land_use_code: The land_use_code of this SoldProperty.
        :type land_use_code: str
        """

        self._land_use_code = land_use_code

    @property
    def assessed_value(self) -> float:
        """Gets the assessed_value of this SoldProperty.

        What is the most recent assesed value for the property?  # noqa: E501

        :return: The assessed_value of this SoldProperty.
        :rtype: float
        """
        return self._assessed_value

    @assessed_value.setter
    def assessed_value(self, assessed_value: float):
        """Sets the assessed_value of this SoldProperty.

        What is the most recent assesed value for the property?  # noqa: E501

        :param assessed_value: The assessed_value of this SoldProperty.
        :type assessed_value: float
        """

        self._assessed_value = assessed_value

    @property
    def tax_amount(self) -> float:
        """Gets the tax_amount of this SoldProperty.

        How much did you most recently pay in property taxes?  # noqa: E501

        :return: The tax_amount of this SoldProperty.
        :rtype: float
        """
        return self._tax_amount

    @tax_amount.setter
    def tax_amount(self, tax_amount: float):
        """Sets the tax_amount of this SoldProperty.

        How much did you most recently pay in property taxes?  # noqa: E501

        :param tax_amount: The tax_amount of this SoldProperty.
        :type tax_amount: float
        """

        self._tax_amount = tax_amount

    @property
    def building_type(self) -> str:
        """Gets the building_type of this SoldProperty.

        The building type.  # noqa: E501

        :return: The building_type of this SoldProperty.
        :rtype: str
        """
        return self._building_type

    @building_type.setter
    def building_type(self, building_type: str):
        """Sets the building_type of this SoldProperty.

        The building type.  # noqa: E501

        :param building_type: The building_type of this SoldProperty.
        :type building_type: str
        """
        allowed_values = ["Detached", "Semi Detached", "Row", "Lowrise Apartment", "Double Wide", "High Rise Apartment", "Single Wide"]  # noqa: E501
        if building_type not in allowed_values:
            raise ValueError(
                "Invalid value for `building_type` ({0}), must be one of {1}"
                .format(building_type, allowed_values)
            )

        self._building_type = building_type

    @property
    def style(self) -> str:
        """Gets the style of this SoldProperty.

        The home style.  # noqa: E501

        :return: The style of this SoldProperty.
        :rtype: str
        """
        return self._style

    @style.setter
    def style(self, style: str):
        """Sets the style of this SoldProperty.

        The home style.  # noqa: E501

        :param style: The style of this SoldProperty.
        :type style: str
        """

        self._style = style

    @property
    def basement_development(self) -> str:
        """Gets the basement_development of this SoldProperty.

        The basement development.  # noqa: E501

        :return: The basement_development of this SoldProperty.
        :rtype: str
        """
        return self._basement_development

    @basement_development.setter
    def basement_development(self, basement_development: str):
        """Sets the basement_development of this SoldProperty.

        The basement development.  # noqa: E501

        :param basement_development: The basement_development of this SoldProperty.
        :type basement_development: str
        """
        allowed_values = ["Fully Finished", "Partly Finished", "Unfinished", "Suite", "None", "Other"]  # noqa: E501
        if basement_development not in allowed_values:
            raise ValueError(
                "Invalid value for `basement_development` ({0}), must be one of {1}"
                .format(basement_development, allowed_values)
            )

        self._basement_development = basement_development

    @property
    def basement_percent_development(self) -> float:
        """Gets the basement_percent_development of this SoldProperty.

        More specific precentage completion  # noqa: E501

        :return: The basement_percent_development of this SoldProperty.
        :rtype: float
        """
        return self._basement_percent_development

    @basement_percent_development.setter
    def basement_percent_development(self, basement_percent_development: float):
        """Sets the basement_percent_development of this SoldProperty.

        More specific precentage completion  # noqa: E501

        :param basement_percent_development: The basement_percent_development of this SoldProperty.
        :type basement_percent_development: float
        """

        self._basement_percent_development = basement_percent_development

    @property
    def basement(self) -> List[str]:
        """Gets the basement of this SoldProperty.

        The type of basement.  # noqa: E501

        :return: The basement of this SoldProperty.
        :rtype: List[str]
        """
        return self._basement

    @basement.setter
    def basement(self, basement: List[str]):
        """Sets the basement of this SoldProperty.

        The type of basement.  # noqa: E501

        :param basement: The basement of this SoldProperty.
        :type basement: List[str]
        """
        allowed_values = ["Walkout/Walkup", "Other"]  # noqa: E501
        if not set(basement).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `basement` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(basement) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._basement = basement

    @property
    def bedrooms_total(self) -> float:
        """Gets the bedrooms_total of this SoldProperty.

        Total number of bedrooms.  # noqa: E501

        :return: The bedrooms_total of this SoldProperty.
        :rtype: float
        """
        return self._bedrooms_total

    @bedrooms_total.setter
    def bedrooms_total(self, bedrooms_total: float):
        """Sets the bedrooms_total of this SoldProperty.

        Total number of bedrooms.  # noqa: E501

        :param bedrooms_total: The bedrooms_total of this SoldProperty.
        :type bedrooms_total: float
        """

        self._bedrooms_total = bedrooms_total

    @property
    def bedrooms_ag(self) -> float:
        """Gets the bedrooms_ag of this SoldProperty.

        Number of bedrooms above grade.  # noqa: E501

        :return: The bedrooms_ag of this SoldProperty.
        :rtype: float
        """
        return self._bedrooms_ag

    @bedrooms_ag.setter
    def bedrooms_ag(self, bedrooms_ag: float):
        """Sets the bedrooms_ag of this SoldProperty.

        Number of bedrooms above grade.  # noqa: E501

        :param bedrooms_ag: The bedrooms_ag of this SoldProperty.
        :type bedrooms_ag: float
        """

        self._bedrooms_ag = bedrooms_ag

    @property
    def bedrooms_with_closet(self) -> float:
        """Gets the bedrooms_with_closet of this SoldProperty.

        Number of bedrooms With closet.  # noqa: E501

        :return: The bedrooms_with_closet of this SoldProperty.
        :rtype: float
        """
        return self._bedrooms_with_closet

    @bedrooms_with_closet.setter
    def bedrooms_with_closet(self, bedrooms_with_closet: float):
        """Sets the bedrooms_with_closet of this SoldProperty.

        Number of bedrooms With closet.  # noqa: E501

        :param bedrooms_with_closet: The bedrooms_with_closet of this SoldProperty.
        :type bedrooms_with_closet: float
        """

        self._bedrooms_with_closet = bedrooms_with_closet

    @property
    def master_walk_in(self) -> bool:
        """Gets the master_walk_in of this SoldProperty.

        Does the master bedroom have a walk-in closet?  # noqa: E501

        :return: The master_walk_in of this SoldProperty.
        :rtype: bool
        """
        return self._master_walk_in

    @master_walk_in.setter
    def master_walk_in(self, master_walk_in: bool):
        """Sets the master_walk_in of this SoldProperty.

        Does the master bedroom have a walk-in closet?  # noqa: E501

        :param master_walk_in: The master_walk_in of this SoldProperty.
        :type master_walk_in: bool
        """

        self._master_walk_in = master_walk_in

    @property
    def master_ensuite(self) -> bool:
        """Gets the master_ensuite of this SoldProperty.

        Does the master bedroom have ensuite?  # noqa: E501

        :return: The master_ensuite of this SoldProperty.
        :rtype: bool
        """
        return self._master_ensuite

    @master_ensuite.setter
    def master_ensuite(self, master_ensuite: bool):
        """Sets the master_ensuite of this SoldProperty.

        Does the master bedroom have ensuite?  # noqa: E501

        :param master_ensuite: The master_ensuite of this SoldProperty.
        :type master_ensuite: bool
        """

        self._master_ensuite = master_ensuite

    @property
    def bathrooms_full(self) -> float:
        """Gets the bathrooms_full of this SoldProperty.

        Number of full bathrooms.  # noqa: E501

        :return: The bathrooms_full of this SoldProperty.
        :rtype: float
        """
        return self._bathrooms_full

    @bathrooms_full.setter
    def bathrooms_full(self, bathrooms_full: float):
        """Sets the bathrooms_full of this SoldProperty.

        Number of full bathrooms.  # noqa: E501

        :param bathrooms_full: The bathrooms_full of this SoldProperty.
        :type bathrooms_full: float
        """

        self._bathrooms_full = bathrooms_full

    @property
    def bathrooms_half(self) -> float:
        """Gets the bathrooms_half of this SoldProperty.

        Number of half bathrooms.  # noqa: E501

        :return: The bathrooms_half of this SoldProperty.
        :rtype: float
        """
        return self._bathrooms_half

    @bathrooms_half.setter
    def bathrooms_half(self, bathrooms_half: float):
        """Sets the bathrooms_half of this SoldProperty.

        Number of half bathrooms.  # noqa: E501

        :param bathrooms_half: The bathrooms_half of this SoldProperty.
        :type bathrooms_half: float
        """

        self._bathrooms_half = bathrooms_half

    @property
    def bathrooms_main(self) -> float:
        """Gets the bathrooms_main of this SoldProperty.

        Number of bathrooms on the main floor.  # noqa: E501

        :return: The bathrooms_main of this SoldProperty.
        :rtype: float
        """
        return self._bathrooms_main

    @bathrooms_main.setter
    def bathrooms_main(self, bathrooms_main: float):
        """Sets the bathrooms_main of this SoldProperty.

        Number of bathrooms on the main floor.  # noqa: E501

        :param bathrooms_main: The bathrooms_main of this SoldProperty.
        :type bathrooms_main: float
        """

        self._bathrooms_main = bathrooms_main

    @property
    def bathrooms_basement(self) -> float:
        """Gets the bathrooms_basement of this SoldProperty.

        Number of bathrooms basement floor.  # noqa: E501

        :return: The bathrooms_basement of this SoldProperty.
        :rtype: float
        """
        return self._bathrooms_basement

    @bathrooms_basement.setter
    def bathrooms_basement(self, bathrooms_basement: float):
        """Sets the bathrooms_basement of this SoldProperty.

        Number of bathrooms basement floor.  # noqa: E501

        :param bathrooms_basement: The bathrooms_basement of this SoldProperty.
        :type bathrooms_basement: float
        """

        self._bathrooms_basement = bathrooms_basement

    @property
    def room_number(self) -> float:
        """Gets the room_number of this SoldProperty.

        Total number of rooms except bathrooms.  # noqa: E501

        :return: The room_number of this SoldProperty.
        :rtype: float
        """
        return self._room_number

    @room_number.setter
    def room_number(self, room_number: float):
        """Sets the room_number of this SoldProperty.

        Total number of rooms except bathrooms.  # noqa: E501

        :param room_number: The room_number of this SoldProperty.
        :type room_number: float
        """

        self._room_number = room_number

    @property
    def kitchen_countertops(self) -> List[str]:
        """Gets the kitchen_countertops of this SoldProperty.

        The type of material for the kitchen countertops.  # noqa: E501

        :return: The kitchen_countertops of this SoldProperty.
        :rtype: List[str]
        """
        return self._kitchen_countertops

    @kitchen_countertops.setter
    def kitchen_countertops(self, kitchen_countertops: List[str]):
        """Sets the kitchen_countertops of this SoldProperty.

        The type of material for the kitchen countertops.  # noqa: E501

        :param kitchen_countertops: The kitchen_countertops of this SoldProperty.
        :type kitchen_countertops: List[str]
        """
        allowed_values = ["Granite", "Not Stone", "Laminate", "Quartz", "Other"]  # noqa: E501
        if not set(kitchen_countertops).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `kitchen_countertops` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(kitchen_countertops) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._kitchen_countertops = kitchen_countertops

    @property
    def kitchen_island(self) -> bool:
        """Gets the kitchen_island of this SoldProperty.

        Does the kitchen have an island?  # noqa: E501

        :return: The kitchen_island of this SoldProperty.
        :rtype: bool
        """
        return self._kitchen_island

    @kitchen_island.setter
    def kitchen_island(self, kitchen_island: bool):
        """Sets the kitchen_island of this SoldProperty.

        Does the kitchen have an island?  # noqa: E501

        :param kitchen_island: The kitchen_island of this SoldProperty.
        :type kitchen_island: bool
        """

        self._kitchen_island = kitchen_island

    @property
    def kitchen_appliances(self) -> List[str]:
        """Gets the kitchen_appliances of this SoldProperty.

        The finish of the kitchen applicances.  # noqa: E501

        :return: The kitchen_appliances of this SoldProperty.
        :rtype: List[str]
        """
        return self._kitchen_appliances

    @kitchen_appliances.setter
    def kitchen_appliances(self, kitchen_appliances: List[str]):
        """Sets the kitchen_appliances of this SoldProperty.

        The finish of the kitchen applicances.  # noqa: E501

        :param kitchen_appliances: The kitchen_appliances of this SoldProperty.
        :type kitchen_appliances: List[str]
        """
        allowed_values = ["Stainless Steel", "White", "Black", "Other"]  # noqa: E501
        if not set(kitchen_appliances).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `kitchen_appliances` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(kitchen_appliances) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._kitchen_appliances = kitchen_appliances

    @property
    def kitchen_layout(self) -> str:
        """Gets the kitchen_layout of this SoldProperty.

        Kitchen layout.  # noqa: E501

        :return: The kitchen_layout of this SoldProperty.
        :rtype: str
        """
        return self._kitchen_layout

    @kitchen_layout.setter
    def kitchen_layout(self, kitchen_layout: str):
        """Sets the kitchen_layout of this SoldProperty.

        Kitchen layout.  # noqa: E501

        :param kitchen_layout: The kitchen_layout of this SoldProperty.
        :type kitchen_layout: str
        """
        allowed_values = ["Open Concept", "Contained"]  # noqa: E501
        if kitchen_layout not in allowed_values:
            raise ValueError(
                "Invalid value for `kitchen_layout` ({0}), must be one of {1}"
                .format(kitchen_layout, allowed_values)
            )

        self._kitchen_layout = kitchen_layout

    @property
    def flooring(self) -> List[str]:
        """Gets the flooring of this SoldProperty.

        Overall flooring.  # noqa: E501

        :return: The flooring of this SoldProperty.
        :rtype: List[str]
        """
        return self._flooring

    @flooring.setter
    def flooring(self, flooring: List[str]):
        """Sets the flooring of this SoldProperty.

        Overall flooring.  # noqa: E501

        :param flooring: The flooring of this SoldProperty.
        :type flooring: List[str]
        """
        allowed_values = ["Carpet", "Laminate Flooring", "Linoleum", "Hardwood", "Ceramic Tile", "Slate", "Non-Ceramic Tile", "Wall to Wall Carpet", "Carpet Over Hardwood", "Cork Flooring", "Marble", "Softwood", "Carpet Over Softwood"]  # noqa: E501
        if not set(flooring).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `flooring` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(flooring) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._flooring = flooring

    @property
    def fireplace(self) -> List[str]:
        """Gets the fireplace of this SoldProperty.

        The type of fireplace.  # noqa: E501

        :return: The fireplace of this SoldProperty.
        :rtype: List[str]
        """
        return self._fireplace

    @fireplace.setter
    def fireplace(self, fireplace: List[str]):
        """Sets the fireplace of this SoldProperty.

        The type of fireplace.  # noqa: E501

        :param fireplace: The fireplace of this SoldProperty.
        :type fireplace: List[str]
        """
        allowed_values = ["Electric", "Wood With Log Lighter", "Wood", "Gas"]  # noqa: E501
        if not set(fireplace).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `fireplace` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(fireplace) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._fireplace = fireplace

    @property
    def heating_type(self) -> List[str]:
        """Gets the heating_type of this SoldProperty.

        Do you have in floor heating?  # noqa: E501

        :return: The heating_type of this SoldProperty.
        :rtype: List[str]
        """
        return self._heating_type

    @heating_type.setter
    def heating_type(self, heating_type: List[str]):
        """Sets the heating_type of this SoldProperty.

        Do you have in floor heating?  # noqa: E501

        :param heating_type: The heating_type of this SoldProperty.
        :type heating_type: List[str]
        """
        allowed_values = ["In Floor Heat System", "No In Floor Heat System"]  # noqa: E501
        if not set(heating_type).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `heating_type` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(heating_type) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._heating_type = heating_type

    @property
    def backyard_details(self) -> str:
        """Gets the backyard_details of this SoldProperty.

        Backyard details (fence, deck, landscaping, etc.)  # noqa: E501

        :return: The backyard_details of this SoldProperty.
        :rtype: str
        """
        return self._backyard_details

    @backyard_details.setter
    def backyard_details(self, backyard_details: str):
        """Sets the backyard_details of this SoldProperty.

        Backyard details (fence, deck, landscaping, etc.)  # noqa: E501

        :param backyard_details: The backyard_details of this SoldProperty.
        :type backyard_details: str
        """

        self._backyard_details = backyard_details

    @property
    def exterior(self) -> List[str]:
        """Gets the exterior of this SoldProperty.

        The type of material of the exterior of the home.  # noqa: E501

        :return: The exterior of this SoldProperty.
        :rtype: List[str]
        """
        return self._exterior

    @exterior.setter
    def exterior(self, exterior: List[str]):
        """Sets the exterior of this SoldProperty.

        The type of material of the exterior of the home.  # noqa: E501

        :param exterior: The exterior of this SoldProperty.
        :type exterior: List[str]
        """
        allowed_values = ["Brick", "Composite", "Stucco", "Fiber Cement Siding", "Stone", "Metal", "Wood", "Concrete", "Asbestos", "Cedar", "Vinyl", "Shingles", "Log", "Asphalt Shingles", "Wood Shingle"]  # noqa: E501
        if not set(exterior).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `exterior` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(exterior) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._exterior = exterior

    @property
    def parking(self) -> List[str]:
        """Gets the parking of this SoldProperty.

        Parking features.  # noqa: E501

        :return: The parking of this SoldProperty.
        :rtype: List[str]
        """
        return self._parking

    @parking.setter
    def parking(self, parking: List[str]):
        """Sets the parking of this SoldProperty.

        Parking features.  # noqa: E501

        :param parking: The parking of this SoldProperty.
        :type parking: List[str]
        """
        allowed_values = ["Attached", "Detached", "Parking Pad", "Rear Drive Access", "RV Parking", "Outdoor Stalls", "220 Volt Wiring"]  # noqa: E501
        if not set(parking).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `parking` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(parking) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._parking = parking

    @property
    def total_parking(self) -> float:
        """Gets the total_parking of this SoldProperty.

        Total parking spots.  # noqa: E501

        :return: The total_parking of this SoldProperty.
        :rtype: float
        """
        return self._total_parking

    @total_parking.setter
    def total_parking(self, total_parking: float):
        """Sets the total_parking of this SoldProperty.

        Total parking spots.  # noqa: E501

        :param total_parking: The total_parking of this SoldProperty.
        :type total_parking: float
        """

        self._total_parking = total_parking

    @property
    def enclosed_parking(self) -> float:
        """Gets the enclosed_parking of this SoldProperty.

        Total enclosed parking.  # noqa: E501

        :return: The enclosed_parking of this SoldProperty.
        :rtype: float
        """
        return self._enclosed_parking

    @enclosed_parking.setter
    def enclosed_parking(self, enclosed_parking: float):
        """Sets the enclosed_parking of this SoldProperty.

        Total enclosed parking.  # noqa: E501

        :param enclosed_parking: The enclosed_parking of this SoldProperty.
        :type enclosed_parking: float
        """

        self._enclosed_parking = enclosed_parking

    @property
    def roof_type(self) -> str:
        """Gets the roof_type of this SoldProperty.

        The type of material of the roof.  # noqa: E501

        :return: The roof_type of this SoldProperty.
        :rtype: str
        """
        return self._roof_type

    @roof_type.setter
    def roof_type(self, roof_type: str):
        """Sets the roof_type of this SoldProperty.

        The type of material of the roof.  # noqa: E501

        :param roof_type: The roof_type of this SoldProperty.
        :type roof_type: str
        """
        allowed_values = ["Asphalt Shingles", "Concrete Tiles", "Wood Shingles", "Clay Tile", "Metal", "Tar & Gravel", "Pine Shakes", "Vinyl Shingles", "Cedar Shakes", "EPDM Membrane", "See Remarks", "Roll Roofing", "Fiberglass"]  # noqa: E501
        if roof_type not in allowed_values:
            raise ValueError(
                "Invalid value for `roof_type` ({0}), must be one of {1}"
                .format(roof_type, allowed_values)
            )

        self._roof_type = roof_type

    @property
    def roof_age_years(self) -> int:
        """Gets the roof_age_years of this SoldProperty.

        The age of the roof in years.  # noqa: E501

        :return: The roof_age_years of this SoldProperty.
        :rtype: int
        """
        return self._roof_age_years

    @roof_age_years.setter
    def roof_age_years(self, roof_age_years: int):
        """Sets the roof_age_years of this SoldProperty.

        The age of the roof in years.  # noqa: E501

        :param roof_age_years: The roof_age_years of this SoldProperty.
        :type roof_age_years: int
        """

        self._roof_age_years = roof_age_years

    @property
    def is_renovated(self) -> bool:
        """Gets the is_renovated of this SoldProperty.

        Has the house been renovated?  # noqa: E501

        :return: The is_renovated of this SoldProperty.
        :rtype: bool
        """
        return self._is_renovated

    @is_renovated.setter
    def is_renovated(self, is_renovated: bool):
        """Sets the is_renovated of this SoldProperty.

        Has the house been renovated?  # noqa: E501

        :param is_renovated: The is_renovated of this SoldProperty.
        :type is_renovated: bool
        """

        self._is_renovated = is_renovated

    @property
    def renovations_or_upgrades(self) -> str:
        """Gets the renovations_or_upgrades of this SoldProperty.

        The renovations or upgrades.  # noqa: E501

        :return: The renovations_or_upgrades of this SoldProperty.
        :rtype: str
        """
        return self._renovations_or_upgrades

    @renovations_or_upgrades.setter
    def renovations_or_upgrades(self, renovations_or_upgrades: str):
        """Sets the renovations_or_upgrades of this SoldProperty.

        The renovations or upgrades.  # noqa: E501

        :param renovations_or_upgrades: The renovations_or_upgrades of this SoldProperty.
        :type renovations_or_upgrades: str
        """

        self._renovations_or_upgrades = renovations_or_upgrades

    @property
    def property_photos_user_submitted(self) -> str:
        """Gets the property_photos_user_submitted of this SoldProperty.

        The photos of the home.  # noqa: E501

        :return: The property_photos_user_submitted of this SoldProperty.
        :rtype: str
        """
        return self._property_photos_user_submitted

    @property_photos_user_submitted.setter
    def property_photos_user_submitted(self, property_photos_user_submitted: str):
        """Sets the property_photos_user_submitted of this SoldProperty.

        The photos of the home.  # noqa: E501

        :param property_photos_user_submitted: The property_photos_user_submitted of this SoldProperty.
        :type property_photos_user_submitted: str
        """

        self._property_photos_user_submitted = property_photos_user_submitted

    @property
    def latitude(self) -> float:
        """Gets the latitude of this SoldProperty.

        The latitude of the location  # noqa: E501

        :return: The latitude of this SoldProperty.
        :rtype: float
        """
        return self._latitude

    @latitude.setter
    def latitude(self, latitude: float):
        """Sets the latitude of this SoldProperty.

        The latitude of the location  # noqa: E501

        :param latitude: The latitude of this SoldProperty.
        :type latitude: float
        """

        self._latitude = latitude

    @property
    def longitude(self) -> float:
        """Gets the longitude of this SoldProperty.

        The longitude of the location  # noqa: E501

        :return: The longitude of this SoldProperty.
        :rtype: float
        """
        return self._longitude

    @longitude.setter
    def longitude(self, longitude: float):
        """Sets the longitude of this SoldProperty.

        The longitude of the location  # noqa: E501

        :param longitude: The longitude of this SoldProperty.
        :type longitude: float
        """

        self._longitude = longitude

    @property
    def google_place_id(self) -> str:
        """Gets the google_place_id of this SoldProperty.

        The google place id for this location  # noqa: E501

        :return: The google_place_id of this SoldProperty.
        :rtype: str
        """
        return self._google_place_id

    @google_place_id.setter
    def google_place_id(self, google_place_id: str):
        """Sets the google_place_id of this SoldProperty.

        The google place id for this location  # noqa: E501

        :param google_place_id: The google_place_id of this SoldProperty.
        :type google_place_id: str
        """

        self._google_place_id = google_place_id

    @property
    def geo_hash5(self) -> str:
        """Gets the geo_hash5 of this SoldProperty.

        The geohash 5 character precision  # noqa: E501

        :return: The geo_hash5 of this SoldProperty.
        :rtype: str
        """
        return self._geo_hash5

    @geo_hash5.setter
    def geo_hash5(self, geo_hash5: str):
        """Sets the geo_hash5 of this SoldProperty.

        The geohash 5 character precision  # noqa: E501

        :param geo_hash5: The geo_hash5 of this SoldProperty.
        :type geo_hash5: str
        """

        self._geo_hash5 = geo_hash5

    @property
    def geo_hash12(self) -> str:
        """Gets the geo_hash12 of this SoldProperty.

        The full geohash  # noqa: E501

        :return: The geo_hash12 of this SoldProperty.
        :rtype: str
        """
        return self._geo_hash12

    @geo_hash12.setter
    def geo_hash12(self, geo_hash12: str):
        """Sets the geo_hash12 of this SoldProperty.

        The full geohash  # noqa: E501

        :param geo_hash12: The geo_hash12 of this SoldProperty.
        :type geo_hash12: str
        """

        self._geo_hash12 = geo_hash12

    @property
    def images(self) -> List[Image]:
        """Gets the images of this SoldProperty.


        :return: The images of this SoldProperty.
        :rtype: List[Image]
        """
        return self._images

    @images.setter
    def images(self, images: List[Image]):
        """Sets the images of this SoldProperty.


        :param images: The images of this SoldProperty.
        :type images: List[Image]
        """

        self._images = images

    @property
    def rooms(self) -> List[Room]:
        """Gets the rooms of this SoldProperty.


        :return: The rooms of this SoldProperty.
        :rtype: List[Room]
        """
        return self._rooms

    @rooms.setter
    def rooms(self, rooms: List[Room]):
        """Sets the rooms of this SoldProperty.


        :param rooms: The rooms of this SoldProperty.
        :type rooms: List[Room]
        """

        self._rooms = rooms

    @property
    def close_price(self) -> float:
        """Gets the close_price of this SoldProperty.

        The amount the buyer paid the seller for the home  # noqa: E501

        :return: The close_price of this SoldProperty.
        :rtype: float
        """
        return self._close_price

    @close_price.setter
    def close_price(self, close_price: float):
        """Sets the close_price of this SoldProperty.

        The amount the buyer paid the seller for the home  # noqa: E501

        :param close_price: The close_price of this SoldProperty.
        :type close_price: float
        """

        self._close_price = close_price

    @property
    def original_list_price(self) -> float:
        """Gets the original_list_price of this SoldProperty.

        The amount the home was initially listed at  # noqa: E501

        :return: The original_list_price of this SoldProperty.
        :rtype: float
        """
        return self._original_list_price

    @original_list_price.setter
    def original_list_price(self, original_list_price: float):
        """Sets the original_list_price of this SoldProperty.

        The amount the home was initially listed at  # noqa: E501

        :param original_list_price: The original_list_price of this SoldProperty.
        :type original_list_price: float
        """

        self._original_list_price = original_list_price

    @property
    def sold_date(self) -> str:
        """Gets the sold_date of this SoldProperty.

        The date the home was sold at in ISO 8601 Date format (eg. 2019-01-30)  # noqa: E501

        :return: The sold_date of this SoldProperty.
        :rtype: str
        """
        return self._sold_date

    @sold_date.setter
    def sold_date(self, sold_date: str):
        """Sets the sold_date of this SoldProperty.

        The date the home was sold at in ISO 8601 Date format (eg. 2019-01-30)  # noqa: E501

        :param sold_date: The sold_date of this SoldProperty.
        :type sold_date: str
        """
        if sold_date is None:
            raise ValueError("Invalid value for `sold_date`, must not be `None`")  # noqa: E501

        self._sold_date = sold_date

    @property
    def dom(self) -> float:
        """Gets the dom of this SoldProperty.

        The number of days on market before sold  # noqa: E501

        :return: The dom of this SoldProperty.
        :rtype: float
        """
        return self._dom

    @dom.setter
    def dom(self, dom: float):
        """Sets the dom of this SoldProperty.

        The number of days on market before sold  # noqa: E501

        :param dom: The dom of this SoldProperty.
        :type dom: float
        """

        self._dom = dom
