# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from properly_model_python.models.base_model_ import Model
from properly_model_python.models.custom_annotation import CustomAnnotation
from properly_model_python.models.image import Image
from properly_model_python.models.room import Room
from properly_model_python import util


class ListingProperty(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, id: str=None, address: str=None, postal_code: str=None, community: str=None, properly_city_code: str=None, properly_region_id: str=None, properly_municipality_code: str=None, zone: str=None, yr_built: int=None, living_space_square_footage_ag: int=None, lot_size: float=None, lot_depth: float=None, lot_frontage: float=None, land_use_code: str=None, assessed_value: float=None, tax_amount: float=None, building_type: str=None, style: str=None, basement_development: str=None, basement_percent_development: float=None, basement_size: str=None, basement: List[str]=None, bedrooms_total: float=None, bedrooms_standard: float=None, bedrooms_extra: float=None, bedrooms_ag: float=None, bedrooms_with_closet: float=None, master_walk_in: bool=None, master_ensuite: bool=None, bathrooms_total: float=None, bathrooms_full: float=None, bathrooms_half: float=None, bathrooms_main: float=None, bathrooms_basement: float=None, room_number: float=None, kitchen_countertops: List[str]=None, kitchen_island: bool=None, kitchen_appliances: List[str]=None, kitchen_layout: str=None, flooring: List[str]=None, fireplace: List[str]=None, heating_type: List[str]=None, backyard_details: str=None, pool_features: List[str]=None, property_features: List[str]=None, exterior: List[str]=None, parking: List[str]=None, total_parking: float=None, enclosed_parking: float=None, roof_type: str=None, roof_age_years: int=None, is_renovated: bool=None, renovations_or_upgrades: str=None, property_photos_user_submitted: str=None, latitude: float=None, longitude: float=None, google_place_id: str=None, building_place_id: str=None, geo_hash5: str=None, geo_hash12: str=None, custom_annotations: List[CustomAnnotation]=None, images: List[Image]=None, rooms: List[List[str]]=None, property_rooms: List[Room]=None, tax_assessment_roll_number: str=None, assessed_year: int=None, air_conditioning: str=None, approx_sqft: str=None, elevator: bool=None, direction_faces: str=None, basement_ensuite: bool=None, is_ph: bool=None, entry_level: float=None, unit_number: str=None, share_percentage: str=None, patio_and_porch_features: str=None, association_amenities: List[str]=None, locker: str=None, condo_corp_number: str=None, condo_corp: str=None, laundry_features: List[str]=None, association_fee: float=None, parking_fee: float=None, parking_included: bool=None, pets_allowed: str=None, city: str=None, province: str=None, stories: int=None, building_name: str=None, association_fee_frequency: str=None, list_agent_phone: str=None, list_agent_email: str=None, list_agent_full_name: str=None, list_agent_mls_id: str=None, list_price: float=None, list_date: str=None, listing_firm_name: str=None, dom: float=None, base_description: str=None, mls_id: str=None, lease: bool=None):  # noqa: E501
        """ListingProperty - a model defined in Swagger

        :param id: The id of this ListingProperty.  # noqa: E501
        :type id: str
        :param address: The address of this ListingProperty.  # noqa: E501
        :type address: str
        :param postal_code: The postal_code of this ListingProperty.  # noqa: E501
        :type postal_code: str
        :param community: The community of this ListingProperty.  # noqa: E501
        :type community: str
        :param properly_city_code: The properly_city_code of this ListingProperty.  # noqa: E501
        :type properly_city_code: str
        :param properly_region_id: The properly_region_id of this ListingProperty.  # noqa: E501
        :type properly_region_id: str
        :param properly_municipality_code: The properly_municipality_code of this ListingProperty.  # noqa: E501
        :type properly_municipality_code: str
        :param zone: The zone of this ListingProperty.  # noqa: E501
        :type zone: str
        :param yr_built: The yr_built of this ListingProperty.  # noqa: E501
        :type yr_built: int
        :param living_space_square_footage_ag: The living_space_square_footage_ag of this ListingProperty.  # noqa: E501
        :type living_space_square_footage_ag: int
        :param lot_size: The lot_size of this ListingProperty.  # noqa: E501
        :type lot_size: float
        :param lot_depth: The lot_depth of this ListingProperty.  # noqa: E501
        :type lot_depth: float
        :param lot_frontage: The lot_frontage of this ListingProperty.  # noqa: E501
        :type lot_frontage: float
        :param land_use_code: The land_use_code of this ListingProperty.  # noqa: E501
        :type land_use_code: str
        :param assessed_value: The assessed_value of this ListingProperty.  # noqa: E501
        :type assessed_value: float
        :param tax_amount: The tax_amount of this ListingProperty.  # noqa: E501
        :type tax_amount: float
        :param building_type: The building_type of this ListingProperty.  # noqa: E501
        :type building_type: str
        :param style: The style of this ListingProperty.  # noqa: E501
        :type style: str
        :param basement_development: The basement_development of this ListingProperty.  # noqa: E501
        :type basement_development: str
        :param basement_percent_development: The basement_percent_development of this ListingProperty.  # noqa: E501
        :type basement_percent_development: float
        :param basement_size: The basement_size of this ListingProperty.  # noqa: E501
        :type basement_size: str
        :param basement: The basement of this ListingProperty.  # noqa: E501
        :type basement: List[str]
        :param bedrooms_total: The bedrooms_total of this ListingProperty.  # noqa: E501
        :type bedrooms_total: float
        :param bedrooms_standard: The bedrooms_standard of this ListingProperty.  # noqa: E501
        :type bedrooms_standard: float
        :param bedrooms_extra: The bedrooms_extra of this ListingProperty.  # noqa: E501
        :type bedrooms_extra: float
        :param bedrooms_ag: The bedrooms_ag of this ListingProperty.  # noqa: E501
        :type bedrooms_ag: float
        :param bedrooms_with_closet: The bedrooms_with_closet of this ListingProperty.  # noqa: E501
        :type bedrooms_with_closet: float
        :param master_walk_in: The master_walk_in of this ListingProperty.  # noqa: E501
        :type master_walk_in: bool
        :param master_ensuite: The master_ensuite of this ListingProperty.  # noqa: E501
        :type master_ensuite: bool
        :param bathrooms_total: The bathrooms_total of this ListingProperty.  # noqa: E501
        :type bathrooms_total: float
        :param bathrooms_full: The bathrooms_full of this ListingProperty.  # noqa: E501
        :type bathrooms_full: float
        :param bathrooms_half: The bathrooms_half of this ListingProperty.  # noqa: E501
        :type bathrooms_half: float
        :param bathrooms_main: The bathrooms_main of this ListingProperty.  # noqa: E501
        :type bathrooms_main: float
        :param bathrooms_basement: The bathrooms_basement of this ListingProperty.  # noqa: E501
        :type bathrooms_basement: float
        :param room_number: The room_number of this ListingProperty.  # noqa: E501
        :type room_number: float
        :param kitchen_countertops: The kitchen_countertops of this ListingProperty.  # noqa: E501
        :type kitchen_countertops: List[str]
        :param kitchen_island: The kitchen_island of this ListingProperty.  # noqa: E501
        :type kitchen_island: bool
        :param kitchen_appliances: The kitchen_appliances of this ListingProperty.  # noqa: E501
        :type kitchen_appliances: List[str]
        :param kitchen_layout: The kitchen_layout of this ListingProperty.  # noqa: E501
        :type kitchen_layout: str
        :param flooring: The flooring of this ListingProperty.  # noqa: E501
        :type flooring: List[str]
        :param fireplace: The fireplace of this ListingProperty.  # noqa: E501
        :type fireplace: List[str]
        :param heating_type: The heating_type of this ListingProperty.  # noqa: E501
        :type heating_type: List[str]
        :param backyard_details: The backyard_details of this ListingProperty.  # noqa: E501
        :type backyard_details: str
        :param pool_features: The pool_features of this ListingProperty.  # noqa: E501
        :type pool_features: List[str]
        :param property_features: The property_features of this ListingProperty.  # noqa: E501
        :type property_features: List[str]
        :param exterior: The exterior of this ListingProperty.  # noqa: E501
        :type exterior: List[str]
        :param parking: The parking of this ListingProperty.  # noqa: E501
        :type parking: List[str]
        :param total_parking: The total_parking of this ListingProperty.  # noqa: E501
        :type total_parking: float
        :param enclosed_parking: The enclosed_parking of this ListingProperty.  # noqa: E501
        :type enclosed_parking: float
        :param roof_type: The roof_type of this ListingProperty.  # noqa: E501
        :type roof_type: str
        :param roof_age_years: The roof_age_years of this ListingProperty.  # noqa: E501
        :type roof_age_years: int
        :param is_renovated: The is_renovated of this ListingProperty.  # noqa: E501
        :type is_renovated: bool
        :param renovations_or_upgrades: The renovations_or_upgrades of this ListingProperty.  # noqa: E501
        :type renovations_or_upgrades: str
        :param property_photos_user_submitted: The property_photos_user_submitted of this ListingProperty.  # noqa: E501
        :type property_photos_user_submitted: str
        :param latitude: The latitude of this ListingProperty.  # noqa: E501
        :type latitude: float
        :param longitude: The longitude of this ListingProperty.  # noqa: E501
        :type longitude: float
        :param google_place_id: The google_place_id of this ListingProperty.  # noqa: E501
        :type google_place_id: str
        :param building_place_id: The building_place_id of this ListingProperty.  # noqa: E501
        :type building_place_id: str
        :param geo_hash5: The geo_hash5 of this ListingProperty.  # noqa: E501
        :type geo_hash5: str
        :param geo_hash12: The geo_hash12 of this ListingProperty.  # noqa: E501
        :type geo_hash12: str
        :param custom_annotations: The custom_annotations of this ListingProperty.  # noqa: E501
        :type custom_annotations: List[CustomAnnotation]
        :param images: The images of this ListingProperty.  # noqa: E501
        :type images: List[Image]
        :param rooms: The rooms of this ListingProperty.  # noqa: E501
        :type rooms: List[List[str]]
        :param property_rooms: The property_rooms of this ListingProperty.  # noqa: E501
        :type property_rooms: List[Room]
        :param tax_assessment_roll_number: The tax_assessment_roll_number of this ListingProperty.  # noqa: E501
        :type tax_assessment_roll_number: str
        :param assessed_year: The assessed_year of this ListingProperty.  # noqa: E501
        :type assessed_year: int
        :param air_conditioning: The air_conditioning of this ListingProperty.  # noqa: E501
        :type air_conditioning: str
        :param approx_sqft: The approx_sqft of this ListingProperty.  # noqa: E501
        :type approx_sqft: str
        :param elevator: The elevator of this ListingProperty.  # noqa: E501
        :type elevator: bool
        :param direction_faces: The direction_faces of this ListingProperty.  # noqa: E501
        :type direction_faces: str
        :param basement_ensuite: The basement_ensuite of this ListingProperty.  # noqa: E501
        :type basement_ensuite: bool
        :param is_ph: The is_ph of this ListingProperty.  # noqa: E501
        :type is_ph: bool
        :param entry_level: The entry_level of this ListingProperty.  # noqa: E501
        :type entry_level: float
        :param unit_number: The unit_number of this ListingProperty.  # noqa: E501
        :type unit_number: str
        :param share_percentage: The share_percentage of this ListingProperty.  # noqa: E501
        :type share_percentage: str
        :param patio_and_porch_features: The patio_and_porch_features of this ListingProperty.  # noqa: E501
        :type patio_and_porch_features: str
        :param association_amenities: The association_amenities of this ListingProperty.  # noqa: E501
        :type association_amenities: List[str]
        :param locker: The locker of this ListingProperty.  # noqa: E501
        :type locker: str
        :param condo_corp_number: The condo_corp_number of this ListingProperty.  # noqa: E501
        :type condo_corp_number: str
        :param condo_corp: The condo_corp of this ListingProperty.  # noqa: E501
        :type condo_corp: str
        :param laundry_features: The laundry_features of this ListingProperty.  # noqa: E501
        :type laundry_features: List[str]
        :param association_fee: The association_fee of this ListingProperty.  # noqa: E501
        :type association_fee: float
        :param parking_fee: The parking_fee of this ListingProperty.  # noqa: E501
        :type parking_fee: float
        :param parking_included: The parking_included of this ListingProperty.  # noqa: E501
        :type parking_included: bool
        :param pets_allowed: The pets_allowed of this ListingProperty.  # noqa: E501
        :type pets_allowed: str
        :param city: The city of this ListingProperty.  # noqa: E501
        :type city: str
        :param province: The province of this ListingProperty.  # noqa: E501
        :type province: str
        :param stories: The stories of this ListingProperty.  # noqa: E501
        :type stories: int
        :param building_name: The building_name of this ListingProperty.  # noqa: E501
        :type building_name: str
        :param association_fee_frequency: The association_fee_frequency of this ListingProperty.  # noqa: E501
        :type association_fee_frequency: str
        :param list_agent_phone: The list_agent_phone of this ListingProperty.  # noqa: E501
        :type list_agent_phone: str
        :param list_agent_email: The list_agent_email of this ListingProperty.  # noqa: E501
        :type list_agent_email: str
        :param list_agent_full_name: The list_agent_full_name of this ListingProperty.  # noqa: E501
        :type list_agent_full_name: str
        :param list_agent_mls_id: The list_agent_mls_id of this ListingProperty.  # noqa: E501
        :type list_agent_mls_id: str
        :param list_price: The list_price of this ListingProperty.  # noqa: E501
        :type list_price: float
        :param list_date: The list_date of this ListingProperty.  # noqa: E501
        :type list_date: str
        :param listing_firm_name: The listing_firm_name of this ListingProperty.  # noqa: E501
        :type listing_firm_name: str
        :param dom: The dom of this ListingProperty.  # noqa: E501
        :type dom: float
        :param base_description: The base_description of this ListingProperty.  # noqa: E501
        :type base_description: str
        :param mls_id: The mls_id of this ListingProperty.  # noqa: E501
        :type mls_id: str
        :param lease: The lease of this ListingProperty.  # noqa: E501
        :type lease: bool
        """
        self.swagger_types = {
            'id': str,
            'address': str,
            'postal_code': str,
            'community': str,
            'properly_city_code': str,
            'properly_region_id': str,
            'properly_municipality_code': str,
            'zone': str,
            'yr_built': int,
            'living_space_square_footage_ag': int,
            'lot_size': float,
            'lot_depth': float,
            'lot_frontage': float,
            'land_use_code': str,
            'assessed_value': float,
            'tax_amount': float,
            'building_type': str,
            'style': str,
            'basement_development': str,
            'basement_percent_development': float,
            'basement_size': str,
            'basement': List[str],
            'bedrooms_total': float,
            'bedrooms_standard': float,
            'bedrooms_extra': float,
            'bedrooms_ag': float,
            'bedrooms_with_closet': float,
            'master_walk_in': bool,
            'master_ensuite': bool,
            'bathrooms_total': float,
            'bathrooms_full': float,
            'bathrooms_half': float,
            'bathrooms_main': float,
            'bathrooms_basement': float,
            'room_number': float,
            'kitchen_countertops': List[str],
            'kitchen_island': bool,
            'kitchen_appliances': List[str],
            'kitchen_layout': str,
            'flooring': List[str],
            'fireplace': List[str],
            'heating_type': List[str],
            'backyard_details': str,
            'pool_features': List[str],
            'property_features': List[str],
            'exterior': List[str],
            'parking': List[str],
            'total_parking': float,
            'enclosed_parking': float,
            'roof_type': str,
            'roof_age_years': int,
            'is_renovated': bool,
            'renovations_or_upgrades': str,
            'property_photos_user_submitted': str,
            'latitude': float,
            'longitude': float,
            'google_place_id': str,
            'building_place_id': str,
            'geo_hash5': str,
            'geo_hash12': str,
            'custom_annotations': List[CustomAnnotation],
            'images': List[Image],
            'rooms': List[List[str]],
            'property_rooms': List[Room],
            'tax_assessment_roll_number': str,
            'assessed_year': int,
            'air_conditioning': str,
            'approx_sqft': str,
            'elevator': bool,
            'direction_faces': str,
            'basement_ensuite': bool,
            'is_ph': bool,
            'entry_level': float,
            'unit_number': str,
            'share_percentage': str,
            'patio_and_porch_features': str,
            'association_amenities': List[str],
            'locker': str,
            'condo_corp_number': str,
            'condo_corp': str,
            'laundry_features': List[str],
            'association_fee': float,
            'parking_fee': float,
            'parking_included': bool,
            'pets_allowed': str,
            'city': str,
            'province': str,
            'stories': int,
            'building_name': str,
            'association_fee_frequency': str,
            'list_agent_phone': str,
            'list_agent_email': str,
            'list_agent_full_name': str,
            'list_agent_mls_id': str,
            'list_price': float,
            'list_date': str,
            'listing_firm_name': str,
            'dom': float,
            'base_description': str,
            'mls_id': str,
            'lease': bool
        }

        self.attribute_map = {
            'id': 'id',
            'address': 'address',
            'postal_code': 'postalCode',
            'community': 'community',
            'properly_city_code': 'properlyCityCode',
            'properly_region_id': 'properlyRegionId',
            'properly_municipality_code': 'properlyMunicipalityCode',
            'zone': 'zone',
            'yr_built': 'yrBuilt',
            'living_space_square_footage_ag': 'livingSpaceSquareFootageAG',
            'lot_size': 'lotSize',
            'lot_depth': 'lotDepth',
            'lot_frontage': 'lotFrontage',
            'land_use_code': 'landUseCode',
            'assessed_value': 'assessedValue',
            'tax_amount': 'taxAmount',
            'building_type': 'buildingType',
            'style': 'style',
            'basement_development': 'basementDevelopment',
            'basement_percent_development': 'basementPercentDevelopment',
            'basement_size': 'basementSize',
            'basement': 'basement',
            'bedrooms_total': 'bedroomsTotal',
            'bedrooms_standard': 'bedroomsStandard',
            'bedrooms_extra': 'bedroomsExtra',
            'bedrooms_ag': 'bedroomsAG',
            'bedrooms_with_closet': 'bedroomsWithCloset',
            'master_walk_in': 'masterWalkIn',
            'master_ensuite': 'masterEnsuite',
            'bathrooms_total': 'bathroomsTotal',
            'bathrooms_full': 'bathroomsFull',
            'bathrooms_half': 'bathroomsHalf',
            'bathrooms_main': 'bathroomsMain',
            'bathrooms_basement': 'bathroomsBasement',
            'room_number': 'roomNumber',
            'kitchen_countertops': 'kitchenCountertops',
            'kitchen_island': 'kitchenIsland',
            'kitchen_appliances': 'kitchenAppliances',
            'kitchen_layout': 'kitchenLayout',
            'flooring': 'flooring',
            'fireplace': 'fireplace',
            'heating_type': 'heatingType',
            'backyard_details': 'backyardDetails',
            'pool_features': 'poolFeatures',
            'property_features': 'propertyFeatures',
            'exterior': 'exterior',
            'parking': 'parking',
            'total_parking': 'totalParking',
            'enclosed_parking': 'enclosedParking',
            'roof_type': 'roofType',
            'roof_age_years': 'roofAgeYears',
            'is_renovated': 'isRenovated',
            'renovations_or_upgrades': 'renovationsOrUpgrades',
            'property_photos_user_submitted': 'propertyPhotosUserSubmitted',
            'latitude': 'latitude',
            'longitude': 'longitude',
            'google_place_id': 'googlePlaceId',
            'building_place_id': 'buildingPlaceId',
            'geo_hash5': 'geoHash5',
            'geo_hash12': 'geoHash12',
            'custom_annotations': 'customAnnotations',
            'images': 'images',
            'rooms': 'rooms',
            'property_rooms': 'propertyRooms',
            'tax_assessment_roll_number': 'taxAssessmentRollNumber',
            'assessed_year': 'assessedYear',
            'air_conditioning': 'airConditioning',
            'approx_sqft': 'approxSQFT',
            'elevator': 'elevator',
            'direction_faces': 'directionFaces',
            'basement_ensuite': 'basementEnsuite',
            'is_ph': 'isPH',
            'entry_level': 'entryLevel',
            'unit_number': 'unitNumber',
            'share_percentage': 'sharePercentage',
            'patio_and_porch_features': 'patioAndPorchFeatures',
            'association_amenities': 'associationAmenities',
            'locker': 'locker',
            'condo_corp_number': 'condoCorpNumber',
            'condo_corp': 'condoCorp',
            'laundry_features': 'laundryFeatures',
            'association_fee': 'associationFee',
            'parking_fee': 'parkingFee',
            'parking_included': 'parkingIncluded',
            'pets_allowed': 'petsAllowed',
            'city': 'city',
            'province': 'province',
            'stories': 'stories',
            'building_name': 'buildingName',
            'association_fee_frequency': 'associationFeeFrequency',
            'list_agent_phone': 'listAgentPhone',
            'list_agent_email': 'listAgentEmail',
            'list_agent_full_name': 'listAgentFullName',
            'list_agent_mls_id': 'listAgentMlsId',
            'list_price': 'listPrice',
            'list_date': 'listDate',
            'listing_firm_name': 'listingFirmName',
            'dom': 'dom',
            'base_description': 'baseDescription',
            'mls_id': 'mlsId',
            'lease': 'lease'
        }

        self._id = id
        self._address = address
        self._postal_code = postal_code
        self._community = community
        self._properly_city_code = properly_city_code
        self._properly_region_id = properly_region_id
        self._properly_municipality_code = properly_municipality_code
        self._zone = zone
        self._yr_built = yr_built
        self._living_space_square_footage_ag = living_space_square_footage_ag
        self._lot_size = lot_size
        self._lot_depth = lot_depth
        self._lot_frontage = lot_frontage
        self._land_use_code = land_use_code
        self._assessed_value = assessed_value
        self._tax_amount = tax_amount
        self._building_type = building_type
        self._style = style
        self._basement_development = basement_development
        self._basement_percent_development = basement_percent_development
        self._basement_size = basement_size
        self._basement = basement
        self._bedrooms_total = bedrooms_total
        self._bedrooms_standard = bedrooms_standard
        self._bedrooms_extra = bedrooms_extra
        self._bedrooms_ag = bedrooms_ag
        self._bedrooms_with_closet = bedrooms_with_closet
        self._master_walk_in = master_walk_in
        self._master_ensuite = master_ensuite
        self._bathrooms_total = bathrooms_total
        self._bathrooms_full = bathrooms_full
        self._bathrooms_half = bathrooms_half
        self._bathrooms_main = bathrooms_main
        self._bathrooms_basement = bathrooms_basement
        self._room_number = room_number
        self._kitchen_countertops = kitchen_countertops
        self._kitchen_island = kitchen_island
        self._kitchen_appliances = kitchen_appliances
        self._kitchen_layout = kitchen_layout
        self._flooring = flooring
        self._fireplace = fireplace
        self._heating_type = heating_type
        self._backyard_details = backyard_details
        self._pool_features = pool_features
        self._property_features = property_features
        self._exterior = exterior
        self._parking = parking
        self._total_parking = total_parking
        self._enclosed_parking = enclosed_parking
        self._roof_type = roof_type
        self._roof_age_years = roof_age_years
        self._is_renovated = is_renovated
        self._renovations_or_upgrades = renovations_or_upgrades
        self._property_photos_user_submitted = property_photos_user_submitted
        self._latitude = latitude
        self._longitude = longitude
        self._google_place_id = google_place_id
        self._building_place_id = building_place_id
        self._geo_hash5 = geo_hash5
        self._geo_hash12 = geo_hash12
        self._custom_annotations = custom_annotations
        self._images = images
        self._rooms = rooms
        self._property_rooms = property_rooms
        self._tax_assessment_roll_number = tax_assessment_roll_number
        self._assessed_year = assessed_year
        self._air_conditioning = air_conditioning
        self._approx_sqft = approx_sqft
        self._elevator = elevator
        self._direction_faces = direction_faces
        self._basement_ensuite = basement_ensuite
        self._is_ph = is_ph
        self._entry_level = entry_level
        self._unit_number = unit_number
        self._share_percentage = share_percentage
        self._patio_and_porch_features = patio_and_porch_features
        self._association_amenities = association_amenities
        self._locker = locker
        self._condo_corp_number = condo_corp_number
        self._condo_corp = condo_corp
        self._laundry_features = laundry_features
        self._association_fee = association_fee
        self._parking_fee = parking_fee
        self._parking_included = parking_included
        self._pets_allowed = pets_allowed
        self._city = city
        self._province = province
        self._stories = stories
        self._building_name = building_name
        self._association_fee_frequency = association_fee_frequency
        self._list_agent_phone = list_agent_phone
        self._list_agent_email = list_agent_email
        self._list_agent_full_name = list_agent_full_name
        self._list_agent_mls_id = list_agent_mls_id
        self._list_price = list_price
        self._list_date = list_date
        self._listing_firm_name = listing_firm_name
        self._dom = dom
        self._base_description = base_description
        self._mls_id = mls_id
        self._lease = lease

    @classmethod
    def from_dict(cls, dikt) -> 'ListingProperty':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ListingProperty of this ListingProperty.  # noqa: E501
        :rtype: ListingProperty
        """
        return util.deserialize_model(dikt, cls)

    @property
    def id(self) -> str:
        """Gets the id of this ListingProperty.


        :return: The id of this ListingProperty.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str):
        """Sets the id of this ListingProperty.


        :param id: The id of this ListingProperty.
        :type id: str
        """

        self._id = id

    @property
    def address(self) -> str:
        """Gets the address of this ListingProperty.

        The address of the home.  # noqa: E501

        :return: The address of this ListingProperty.
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address: str):
        """Sets the address of this ListingProperty.

        The address of the home.  # noqa: E501

        :param address: The address of this ListingProperty.
        :type address: str
        """
        if address is None:
            raise ValueError("Invalid value for `address`, must not be `None`")  # noqa: E501

        self._address = address

    @property
    def postal_code(self) -> str:
        """Gets the postal_code of this ListingProperty.

        Postal code of the home.  # noqa: E501

        :return: The postal_code of this ListingProperty.
        :rtype: str
        """
        return self._postal_code

    @postal_code.setter
    def postal_code(self, postal_code: str):
        """Sets the postal_code of this ListingProperty.

        Postal code of the home.  # noqa: E501

        :param postal_code: The postal_code of this ListingProperty.
        :type postal_code: str
        """

        self._postal_code = postal_code

    @property
    def community(self) -> str:
        """Gets the community of this ListingProperty.

        The community of the home.  # noqa: E501

        :return: The community of this ListingProperty.
        :rtype: str
        """
        return self._community

    @community.setter
    def community(self, community: str):
        """Sets the community of this ListingProperty.

        The community of the home.  # noqa: E501

        :param community: The community of this ListingProperty.
        :type community: str
        """

        self._community = community

    @property
    def properly_city_code(self) -> str:
        """Gets the properly_city_code of this ListingProperty.

        Internal code to represent the listing board/broader city area.  # noqa: E501

        :return: The properly_city_code of this ListingProperty.
        :rtype: str
        """
        return self._properly_city_code

    @properly_city_code.setter
    def properly_city_code(self, properly_city_code: str):
        """Sets the properly_city_code of this ListingProperty.

        Internal code to represent the listing board/broader city area.  # noqa: E501

        :param properly_city_code: The properly_city_code of this ListingProperty.
        :type properly_city_code: str
        """

        self._properly_city_code = properly_city_code

    @property
    def properly_region_id(self) -> str:
        """Gets the properly_region_id of this ListingProperty.

        Internal code to represent a region within the broader city area  # noqa: E501

        :return: The properly_region_id of this ListingProperty.
        :rtype: str
        """
        return self._properly_region_id

    @properly_region_id.setter
    def properly_region_id(self, properly_region_id: str):
        """Sets the properly_region_id of this ListingProperty.

        Internal code to represent a region within the broader city area  # noqa: E501

        :param properly_region_id: The properly_region_id of this ListingProperty.
        :type properly_region_id: str
        """

        self._properly_region_id = properly_region_id

    @property
    def properly_municipality_code(self) -> str:
        """Gets the properly_municipality_code of this ListingProperty.

        Internal code to represent the legal municipality  # noqa: E501

        :return: The properly_municipality_code of this ListingProperty.
        :rtype: str
        """
        return self._properly_municipality_code

    @properly_municipality_code.setter
    def properly_municipality_code(self, properly_municipality_code: str):
        """Sets the properly_municipality_code of this ListingProperty.

        Internal code to represent the legal municipality  # noqa: E501

        :param properly_municipality_code: The properly_municipality_code of this ListingProperty.
        :type properly_municipality_code: str
        """

        self._properly_municipality_code = properly_municipality_code

    @property
    def zone(self) -> str:
        """Gets the zone of this ListingProperty.

        The zone the community is located.  # noqa: E501

        :return: The zone of this ListingProperty.
        :rtype: str
        """
        return self._zone

    @zone.setter
    def zone(self, zone: str):
        """Sets the zone of this ListingProperty.

        The zone the community is located.  # noqa: E501

        :param zone: The zone of this ListingProperty.
        :type zone: str
        """

        self._zone = zone

    @property
    def yr_built(self) -> int:
        """Gets the yr_built of this ListingProperty.

        The year the home was built.  # noqa: E501

        :return: The yr_built of this ListingProperty.
        :rtype: int
        """
        return self._yr_built

    @yr_built.setter
    def yr_built(self, yr_built: int):
        """Sets the yr_built of this ListingProperty.

        The year the home was built.  # noqa: E501

        :param yr_built: The yr_built of this ListingProperty.
        :type yr_built: int
        """

        self._yr_built = yr_built

    @property
    def living_space_square_footage_ag(self) -> int:
        """Gets the living_space_square_footage_ag of this ListingProperty.


        :return: The living_space_square_footage_ag of this ListingProperty.
        :rtype: int
        """
        return self._living_space_square_footage_ag

    @living_space_square_footage_ag.setter
    def living_space_square_footage_ag(self, living_space_square_footage_ag: int):
        """Sets the living_space_square_footage_ag of this ListingProperty.


        :param living_space_square_footage_ag: The living_space_square_footage_ag of this ListingProperty.
        :type living_space_square_footage_ag: int
        """

        self._living_space_square_footage_ag = living_space_square_footage_ag

    @property
    def lot_size(self) -> float:
        """Gets the lot_size of this ListingProperty.

        How would you describe your lot size? * Below Average -> 0.8 * Average -> 1.0 * Above Average -> 1.2   # noqa: E501

        :return: The lot_size of this ListingProperty.
        :rtype: float
        """
        return self._lot_size

    @lot_size.setter
    def lot_size(self, lot_size: float):
        """Sets the lot_size of this ListingProperty.

        How would you describe your lot size? * Below Average -> 0.8 * Average -> 1.0 * Above Average -> 1.2   # noqa: E501

        :param lot_size: The lot_size of this ListingProperty.
        :type lot_size: float
        """

        self._lot_size = lot_size

    @property
    def lot_depth(self) -> float:
        """Gets the lot_depth of this ListingProperty.

        Depth of the lot in feet  # noqa: E501

        :return: The lot_depth of this ListingProperty.
        :rtype: float
        """
        return self._lot_depth

    @lot_depth.setter
    def lot_depth(self, lot_depth: float):
        """Sets the lot_depth of this ListingProperty.

        Depth of the lot in feet  # noqa: E501

        :param lot_depth: The lot_depth of this ListingProperty.
        :type lot_depth: float
        """

        self._lot_depth = lot_depth

    @property
    def lot_frontage(self) -> float:
        """Gets the lot_frontage of this ListingProperty.

        Frontage of the lot in feet  # noqa: E501

        :return: The lot_frontage of this ListingProperty.
        :rtype: float
        """
        return self._lot_frontage

    @lot_frontage.setter
    def lot_frontage(self, lot_frontage: float):
        """Sets the lot_frontage of this ListingProperty.

        Frontage of the lot in feet  # noqa: E501

        :param lot_frontage: The lot_frontage of this ListingProperty.
        :type lot_frontage: float
        """

        self._lot_frontage = lot_frontage

    @property
    def land_use_code(self) -> str:
        """Gets the land_use_code of this ListingProperty.

        The land use code of the home. Varies by geography.  # noqa: E501

        :return: The land_use_code of this ListingProperty.
        :rtype: str
        """
        return self._land_use_code

    @land_use_code.setter
    def land_use_code(self, land_use_code: str):
        """Sets the land_use_code of this ListingProperty.

        The land use code of the home. Varies by geography.  # noqa: E501

        :param land_use_code: The land_use_code of this ListingProperty.
        :type land_use_code: str
        """

        self._land_use_code = land_use_code

    @property
    def assessed_value(self) -> float:
        """Gets the assessed_value of this ListingProperty.

        What is the most recent assesed value for the property?  # noqa: E501

        :return: The assessed_value of this ListingProperty.
        :rtype: float
        """
        return self._assessed_value

    @assessed_value.setter
    def assessed_value(self, assessed_value: float):
        """Sets the assessed_value of this ListingProperty.

        What is the most recent assesed value for the property?  # noqa: E501

        :param assessed_value: The assessed_value of this ListingProperty.
        :type assessed_value: float
        """

        self._assessed_value = assessed_value

    @property
    def tax_amount(self) -> float:
        """Gets the tax_amount of this ListingProperty.

        How much did you most recently pay in property taxes?  # noqa: E501

        :return: The tax_amount of this ListingProperty.
        :rtype: float
        """
        return self._tax_amount

    @tax_amount.setter
    def tax_amount(self, tax_amount: float):
        """Sets the tax_amount of this ListingProperty.

        How much did you most recently pay in property taxes?  # noqa: E501

        :param tax_amount: The tax_amount of this ListingProperty.
        :type tax_amount: float
        """

        self._tax_amount = tax_amount

    @property
    def building_type(self) -> str:
        """Gets the building_type of this ListingProperty.

        The building type.  # noqa: E501

        :return: The building_type of this ListingProperty.
        :rtype: str
        """
        return self._building_type

    @building_type.setter
    def building_type(self, building_type: str):
        """Sets the building_type of this ListingProperty.

        The building type.  # noqa: E501

        :param building_type: The building_type of this ListingProperty.
        :type building_type: str
        """
        allowed_values = ["Detached", "Semi Detached", "Row", "Lowrise Apartment", "Double Wide", "High Rise Apartment", "Single Wide", "Duplex", "Triplex", "Fourplex", "Multiplex", "Other"]  # noqa: E501
        if building_type not in allowed_values:
            raise ValueError(
                "Invalid value for `building_type` ({0}), must be one of {1}"
                .format(building_type, allowed_values)
            )

        self._building_type = building_type

    @property
    def style(self) -> str:
        """Gets the style of this ListingProperty.

        The home style.  # noqa: E501

        :return: The style of this ListingProperty.
        :rtype: str
        """
        return self._style

    @style.setter
    def style(self, style: str):
        """Sets the style of this ListingProperty.

        The home style.  # noqa: E501

        :param style: The style of this ListingProperty.
        :type style: str
        """

        self._style = style

    @property
    def basement_development(self) -> str:
        """Gets the basement_development of this ListingProperty.

        The basement development.  # noqa: E501

        :return: The basement_development of this ListingProperty.
        :rtype: str
        """
        return self._basement_development

    @basement_development.setter
    def basement_development(self, basement_development: str):
        """Sets the basement_development of this ListingProperty.

        The basement development.  # noqa: E501

        :param basement_development: The basement_development of this ListingProperty.
        :type basement_development: str
        """
        allowed_values = ["Fully Finished", "Partly Finished", "Unfinished", "Suite", "None", "Other"]  # noqa: E501
        if basement_development not in allowed_values:
            raise ValueError(
                "Invalid value for `basement_development` ({0}), must be one of {1}"
                .format(basement_development, allowed_values)
            )

        self._basement_development = basement_development

    @property
    def basement_percent_development(self) -> float:
        """Gets the basement_percent_development of this ListingProperty.

        More specific precentage completion  # noqa: E501

        :return: The basement_percent_development of this ListingProperty.
        :rtype: float
        """
        return self._basement_percent_development

    @basement_percent_development.setter
    def basement_percent_development(self, basement_percent_development: float):
        """Sets the basement_percent_development of this ListingProperty.

        More specific precentage completion  # noqa: E501

        :param basement_percent_development: The basement_percent_development of this ListingProperty.
        :type basement_percent_development: float
        """

        self._basement_percent_development = basement_percent_development

    @property
    def basement_size(self) -> str:
        """Gets the basement_size of this ListingProperty.

        The footprint size of the basement.  # noqa: E501

        :return: The basement_size of this ListingProperty.
        :rtype: str
        """
        return self._basement_size

    @basement_size.setter
    def basement_size(self, basement_size: str):
        """Sets the basement_size of this ListingProperty.

        The footprint size of the basement.  # noqa: E501

        :param basement_size: The basement_size of this ListingProperty.
        :type basement_size: str
        """
        allowed_values = ["Full", "Partial", "Crawl Space", "None"]  # noqa: E501
        if basement_size not in allowed_values:
            raise ValueError(
                "Invalid value for `basement_size` ({0}), must be one of {1}"
                .format(basement_size, allowed_values)
            )

        self._basement_size = basement_size

    @property
    def basement(self) -> List[str]:
        """Gets the basement of this ListingProperty.

        The type of basement.  # noqa: E501

        :return: The basement of this ListingProperty.
        :rtype: List[str]
        """
        return self._basement

    @basement.setter
    def basement(self, basement: List[str]):
        """Sets the basement of this ListingProperty.

        The type of basement.  # noqa: E501

        :param basement: The basement of this ListingProperty.
        :type basement: List[str]
        """
        allowed_values = ["Walkout/Walkup", "Other"]  # noqa: E501
        if not set(basement).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `basement` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(basement) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._basement = basement

    @property
    def bedrooms_total(self) -> float:
        """Gets the bedrooms_total of this ListingProperty.

        Total number of bedrooms.  # noqa: E501

        :return: The bedrooms_total of this ListingProperty.
        :rtype: float
        """
        return self._bedrooms_total

    @bedrooms_total.setter
    def bedrooms_total(self, bedrooms_total: float):
        """Sets the bedrooms_total of this ListingProperty.

        Total number of bedrooms.  # noqa: E501

        :param bedrooms_total: The bedrooms_total of this ListingProperty.
        :type bedrooms_total: float
        """

        self._bedrooms_total = bedrooms_total

    @property
    def bedrooms_standard(self) -> float:
        """Gets the bedrooms_standard of this ListingProperty.

        Number of bedrooms that meet the legal or conventional standard for a bedroom in the property's city.  # noqa: E501

        :return: The bedrooms_standard of this ListingProperty.
        :rtype: float
        """
        return self._bedrooms_standard

    @bedrooms_standard.setter
    def bedrooms_standard(self, bedrooms_standard: float):
        """Sets the bedrooms_standard of this ListingProperty.

        Number of bedrooms that meet the legal or conventional standard for a bedroom in the property's city.  # noqa: E501

        :param bedrooms_standard: The bedrooms_standard of this ListingProperty.
        :type bedrooms_standard: float
        """

        self._bedrooms_standard = bedrooms_standard

    @property
    def bedrooms_extra(self) -> float:
        """Gets the bedrooms_extra of this ListingProperty.

        Number of bedrooms that don't meet the standard but are still included in the total. In some cities these are often referred to as dens.  # noqa: E501

        :return: The bedrooms_extra of this ListingProperty.
        :rtype: float
        """
        return self._bedrooms_extra

    @bedrooms_extra.setter
    def bedrooms_extra(self, bedrooms_extra: float):
        """Sets the bedrooms_extra of this ListingProperty.

        Number of bedrooms that don't meet the standard but are still included in the total. In some cities these are often referred to as dens.  # noqa: E501

        :param bedrooms_extra: The bedrooms_extra of this ListingProperty.
        :type bedrooms_extra: float
        """

        self._bedrooms_extra = bedrooms_extra

    @property
    def bedrooms_ag(self) -> float:
        """Gets the bedrooms_ag of this ListingProperty.

        Number of bedrooms above grade.  # noqa: E501

        :return: The bedrooms_ag of this ListingProperty.
        :rtype: float
        """
        return self._bedrooms_ag

    @bedrooms_ag.setter
    def bedrooms_ag(self, bedrooms_ag: float):
        """Sets the bedrooms_ag of this ListingProperty.

        Number of bedrooms above grade.  # noqa: E501

        :param bedrooms_ag: The bedrooms_ag of this ListingProperty.
        :type bedrooms_ag: float
        """

        self._bedrooms_ag = bedrooms_ag

    @property
    def bedrooms_with_closet(self) -> float:
        """Gets the bedrooms_with_closet of this ListingProperty.

        Number of bedrooms With closet.  # noqa: E501

        :return: The bedrooms_with_closet of this ListingProperty.
        :rtype: float
        """
        return self._bedrooms_with_closet

    @bedrooms_with_closet.setter
    def bedrooms_with_closet(self, bedrooms_with_closet: float):
        """Sets the bedrooms_with_closet of this ListingProperty.

        Number of bedrooms With closet.  # noqa: E501

        :param bedrooms_with_closet: The bedrooms_with_closet of this ListingProperty.
        :type bedrooms_with_closet: float
        """

        self._bedrooms_with_closet = bedrooms_with_closet

    @property
    def master_walk_in(self) -> bool:
        """Gets the master_walk_in of this ListingProperty.

        Does the master bedroom have a walk-in closet?  # noqa: E501

        :return: The master_walk_in of this ListingProperty.
        :rtype: bool
        """
        return self._master_walk_in

    @master_walk_in.setter
    def master_walk_in(self, master_walk_in: bool):
        """Sets the master_walk_in of this ListingProperty.

        Does the master bedroom have a walk-in closet?  # noqa: E501

        :param master_walk_in: The master_walk_in of this ListingProperty.
        :type master_walk_in: bool
        """

        self._master_walk_in = master_walk_in

    @property
    def master_ensuite(self) -> bool:
        """Gets the master_ensuite of this ListingProperty.

        Does the master bedroom have ensuite?  # noqa: E501

        :return: The master_ensuite of this ListingProperty.
        :rtype: bool
        """
        return self._master_ensuite

    @master_ensuite.setter
    def master_ensuite(self, master_ensuite: bool):
        """Sets the master_ensuite of this ListingProperty.

        Does the master bedroom have ensuite?  # noqa: E501

        :param master_ensuite: The master_ensuite of this ListingProperty.
        :type master_ensuite: bool
        """

        self._master_ensuite = master_ensuite

    @property
    def bathrooms_total(self) -> float:
        """Gets the bathrooms_total of this ListingProperty.

        Number of total bathrooms  # noqa: E501

        :return: The bathrooms_total of this ListingProperty.
        :rtype: float
        """
        return self._bathrooms_total

    @bathrooms_total.setter
    def bathrooms_total(self, bathrooms_total: float):
        """Sets the bathrooms_total of this ListingProperty.

        Number of total bathrooms  # noqa: E501

        :param bathrooms_total: The bathrooms_total of this ListingProperty.
        :type bathrooms_total: float
        """

        self._bathrooms_total = bathrooms_total

    @property
    def bathrooms_full(self) -> float:
        """Gets the bathrooms_full of this ListingProperty.

        Number of full bathrooms.  # noqa: E501

        :return: The bathrooms_full of this ListingProperty.
        :rtype: float
        """
        return self._bathrooms_full

    @bathrooms_full.setter
    def bathrooms_full(self, bathrooms_full: float):
        """Sets the bathrooms_full of this ListingProperty.

        Number of full bathrooms.  # noqa: E501

        :param bathrooms_full: The bathrooms_full of this ListingProperty.
        :type bathrooms_full: float
        """

        self._bathrooms_full = bathrooms_full

    @property
    def bathrooms_half(self) -> float:
        """Gets the bathrooms_half of this ListingProperty.

        Number of half bathrooms.  # noqa: E501

        :return: The bathrooms_half of this ListingProperty.
        :rtype: float
        """
        return self._bathrooms_half

    @bathrooms_half.setter
    def bathrooms_half(self, bathrooms_half: float):
        """Sets the bathrooms_half of this ListingProperty.

        Number of half bathrooms.  # noqa: E501

        :param bathrooms_half: The bathrooms_half of this ListingProperty.
        :type bathrooms_half: float
        """

        self._bathrooms_half = bathrooms_half

    @property
    def bathrooms_main(self) -> float:
        """Gets the bathrooms_main of this ListingProperty.

        Number of bathrooms on the main floor.  # noqa: E501

        :return: The bathrooms_main of this ListingProperty.
        :rtype: float
        """
        return self._bathrooms_main

    @bathrooms_main.setter
    def bathrooms_main(self, bathrooms_main: float):
        """Sets the bathrooms_main of this ListingProperty.

        Number of bathrooms on the main floor.  # noqa: E501

        :param bathrooms_main: The bathrooms_main of this ListingProperty.
        :type bathrooms_main: float
        """

        self._bathrooms_main = bathrooms_main

    @property
    def bathrooms_basement(self) -> float:
        """Gets the bathrooms_basement of this ListingProperty.

        Number of bathrooms basement floor.  # noqa: E501

        :return: The bathrooms_basement of this ListingProperty.
        :rtype: float
        """
        return self._bathrooms_basement

    @bathrooms_basement.setter
    def bathrooms_basement(self, bathrooms_basement: float):
        """Sets the bathrooms_basement of this ListingProperty.

        Number of bathrooms basement floor.  # noqa: E501

        :param bathrooms_basement: The bathrooms_basement of this ListingProperty.
        :type bathrooms_basement: float
        """

        self._bathrooms_basement = bathrooms_basement

    @property
    def room_number(self) -> float:
        """Gets the room_number of this ListingProperty.

        Total number of rooms except bathrooms.  # noqa: E501

        :return: The room_number of this ListingProperty.
        :rtype: float
        """
        return self._room_number

    @room_number.setter
    def room_number(self, room_number: float):
        """Sets the room_number of this ListingProperty.

        Total number of rooms except bathrooms.  # noqa: E501

        :param room_number: The room_number of this ListingProperty.
        :type room_number: float
        """

        self._room_number = room_number

    @property
    def kitchen_countertops(self) -> List[str]:
        """Gets the kitchen_countertops of this ListingProperty.

        The type of material for the kitchen countertops.  # noqa: E501

        :return: The kitchen_countertops of this ListingProperty.
        :rtype: List[str]
        """
        return self._kitchen_countertops

    @kitchen_countertops.setter
    def kitchen_countertops(self, kitchen_countertops: List[str]):
        """Sets the kitchen_countertops of this ListingProperty.

        The type of material for the kitchen countertops.  # noqa: E501

        :param kitchen_countertops: The kitchen_countertops of this ListingProperty.
        :type kitchen_countertops: List[str]
        """
        allowed_values = ["Granite", "Not Stone", "Laminate", "Quartz", "Tile", "Other"]  # noqa: E501
        if not set(kitchen_countertops).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `kitchen_countertops` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(kitchen_countertops) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._kitchen_countertops = kitchen_countertops

    @property
    def kitchen_island(self) -> bool:
        """Gets the kitchen_island of this ListingProperty.

        Does the kitchen have an island?  # noqa: E501

        :return: The kitchen_island of this ListingProperty.
        :rtype: bool
        """
        return self._kitchen_island

    @kitchen_island.setter
    def kitchen_island(self, kitchen_island: bool):
        """Sets the kitchen_island of this ListingProperty.

        Does the kitchen have an island?  # noqa: E501

        :param kitchen_island: The kitchen_island of this ListingProperty.
        :type kitchen_island: bool
        """

        self._kitchen_island = kitchen_island

    @property
    def kitchen_appliances(self) -> List[str]:
        """Gets the kitchen_appliances of this ListingProperty.

        The finish of the kitchen applicances.  # noqa: E501

        :return: The kitchen_appliances of this ListingProperty.
        :rtype: List[str]
        """
        return self._kitchen_appliances

    @kitchen_appliances.setter
    def kitchen_appliances(self, kitchen_appliances: List[str]):
        """Sets the kitchen_appliances of this ListingProperty.

        The finish of the kitchen applicances.  # noqa: E501

        :param kitchen_appliances: The kitchen_appliances of this ListingProperty.
        :type kitchen_appliances: List[str]
        """
        allowed_values = ["Stainless Steel", "White", "Black", "Other"]  # noqa: E501
        if not set(kitchen_appliances).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `kitchen_appliances` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(kitchen_appliances) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._kitchen_appliances = kitchen_appliances

    @property
    def kitchen_layout(self) -> str:
        """Gets the kitchen_layout of this ListingProperty.

        Kitchen layout.  # noqa: E501

        :return: The kitchen_layout of this ListingProperty.
        :rtype: str
        """
        return self._kitchen_layout

    @kitchen_layout.setter
    def kitchen_layout(self, kitchen_layout: str):
        """Sets the kitchen_layout of this ListingProperty.

        Kitchen layout.  # noqa: E501

        :param kitchen_layout: The kitchen_layout of this ListingProperty.
        :type kitchen_layout: str
        """
        allowed_values = ["Open Concept", "Contained"]  # noqa: E501
        if kitchen_layout not in allowed_values:
            raise ValueError(
                "Invalid value for `kitchen_layout` ({0}), must be one of {1}"
                .format(kitchen_layout, allowed_values)
            )

        self._kitchen_layout = kitchen_layout

    @property
    def flooring(self) -> List[str]:
        """Gets the flooring of this ListingProperty.

        Overall flooring.  # noqa: E501

        :return: The flooring of this ListingProperty.
        :rtype: List[str]
        """
        return self._flooring

    @flooring.setter
    def flooring(self, flooring: List[str]):
        """Sets the flooring of this ListingProperty.

        Overall flooring.  # noqa: E501

        :param flooring: The flooring of this ListingProperty.
        :type flooring: List[str]
        """
        allowed_values = ["Carpet", "Laminate Flooring", "Linoleum", "Hardwood", "Ceramic Tile", "Slate", "Non-Ceramic Tile", "Wall to Wall Carpet", "Carpet Over Hardwood", "Cork Flooring", "Marble", "Softwood", "Carpet Over Softwood", "Stone", "Other"]  # noqa: E501
        if not set(flooring).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `flooring` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(flooring) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._flooring = flooring

    @property
    def fireplace(self) -> List[str]:
        """Gets the fireplace of this ListingProperty.

        The type of fireplace.  # noqa: E501

        :return: The fireplace of this ListingProperty.
        :rtype: List[str]
        """
        return self._fireplace

    @fireplace.setter
    def fireplace(self, fireplace: List[str]):
        """Sets the fireplace of this ListingProperty.

        The type of fireplace.  # noqa: E501

        :param fireplace: The fireplace of this ListingProperty.
        :type fireplace: List[str]
        """
        allowed_values = ["Electric", "Wood With Log Lighter", "Wood", "Gas"]  # noqa: E501
        if not set(fireplace).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `fireplace` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(fireplace) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._fireplace = fireplace

    @property
    def heating_type(self) -> List[str]:
        """Gets the heating_type of this ListingProperty.

        Do you have in floor heating?  # noqa: E501

        :return: The heating_type of this ListingProperty.
        :rtype: List[str]
        """
        return self._heating_type

    @heating_type.setter
    def heating_type(self, heating_type: List[str]):
        """Sets the heating_type of this ListingProperty.

        Do you have in floor heating?  # noqa: E501

        :param heating_type: The heating_type of this ListingProperty.
        :type heating_type: List[str]
        """
        allowed_values = ["In Floor Heat System", "No In Floor Heat System", "Radiant", "Forced Air", "Baseboard", "Water", "Heat Pump", "Fan Coil", "Other"]  # noqa: E501
        if not set(heating_type).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `heating_type` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(heating_type) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._heating_type = heating_type

    @property
    def backyard_details(self) -> str:
        """Gets the backyard_details of this ListingProperty.

        Backyard details (fence, deck, landscaping, etc.)  # noqa: E501

        :return: The backyard_details of this ListingProperty.
        :rtype: str
        """
        return self._backyard_details

    @backyard_details.setter
    def backyard_details(self, backyard_details: str):
        """Sets the backyard_details of this ListingProperty.

        Backyard details (fence, deck, landscaping, etc.)  # noqa: E501

        :param backyard_details: The backyard_details of this ListingProperty.
        :type backyard_details: str
        """

        self._backyard_details = backyard_details

    @property
    def pool_features(self) -> List[str]:
        """Gets the pool_features of this ListingProperty.

        Pool features.  # noqa: E501

        :return: The pool_features of this ListingProperty.
        :rtype: List[str]
        """
        return self._pool_features

    @pool_features.setter
    def pool_features(self, pool_features: List[str]):
        """Sets the pool_features of this ListingProperty.

        Pool features.  # noqa: E501

        :param pool_features: The pool_features of this ListingProperty.
        :type pool_features: List[str]
        """
        allowed_values = ["Above Ground", "In Ground", "Indoor", "None"]  # noqa: E501
        if not set(pool_features).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `pool_features` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(pool_features) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._pool_features = pool_features

    @property
    def property_features(self) -> List[str]:
        """Gets the property_features of this ListingProperty.

        Residential property features.  # noqa: E501

        :return: The property_features of this ListingProperty.
        :rtype: List[str]
        """
        return self._property_features

    @property_features.setter
    def property_features(self, property_features: List[str]):
        """Sets the property_features of this ListingProperty.

        Residential property features.  # noqa: E501

        :param property_features: The property_features of this ListingProperty.
        :type property_features: List[str]
        """
        allowed_values = ["Beach", "Campground", "Cul De Sac", "Fenced Yard", "Golf", "Greenbelt", "Hospital", "Island", "Library", "Marina", "Park", "Place Of Worship", "Public Transit", "Ravine", "School", "Skiing", "Treed", "Waterfront"]  # noqa: E501
        if not set(property_features).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `property_features` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(property_features) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._property_features = property_features

    @property
    def exterior(self) -> List[str]:
        """Gets the exterior of this ListingProperty.

        The type of material of the exterior of the home.  # noqa: E501

        :return: The exterior of this ListingProperty.
        :rtype: List[str]
        """
        return self._exterior

    @exterior.setter
    def exterior(self, exterior: List[str]):
        """Sets the exterior of this ListingProperty.

        The type of material of the exterior of the home.  # noqa: E501

        :param exterior: The exterior of this ListingProperty.
        :type exterior: List[str]
        """
        allowed_values = ["Brick", "Insulbrick", "Composite", "Stucco", "Fiber Cement Siding", "Stone", "Metal", "Wood", "Concrete", "Asbestos", "Cedar", "Vinyl", "Shingles", "Log", "Asphalt Shingles", "Wood Shingle", "Aluminum Siding", "Batten", "Other"]  # noqa: E501
        if not set(exterior).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `exterior` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(exterior) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._exterior = exterior

    @property
    def parking(self) -> List[str]:
        """Gets the parking of this ListingProperty.

        Parking features.  # noqa: E501

        :return: The parking of this ListingProperty.
        :rtype: List[str]
        """
        return self._parking

    @parking.setter
    def parking(self, parking: List[str]):
        """Sets the parking of this ListingProperty.

        Parking features.  # noqa: E501

        :param parking: The parking of this ListingProperty.
        :type parking: List[str]
        """
        allowed_values = ["Attached", "Carport", "Detached", "Driveway", "Parking Pad", "Rear Drive Access", "RV Parking", "Outdoor Stalls", "220 Volt Wiring", "Street Parking", "Built-In", "Surface", "Underground", "None", "Other"]  # noqa: E501
        if not set(parking).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `parking` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(parking) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._parking = parking

    @property
    def total_parking(self) -> float:
        """Gets the total_parking of this ListingProperty.

        Total parking spots.  # noqa: E501

        :return: The total_parking of this ListingProperty.
        :rtype: float
        """
        return self._total_parking

    @total_parking.setter
    def total_parking(self, total_parking: float):
        """Sets the total_parking of this ListingProperty.

        Total parking spots.  # noqa: E501

        :param total_parking: The total_parking of this ListingProperty.
        :type total_parking: float
        """

        self._total_parking = total_parking

    @property
    def enclosed_parking(self) -> float:
        """Gets the enclosed_parking of this ListingProperty.

        Total enclosed parking.  # noqa: E501

        :return: The enclosed_parking of this ListingProperty.
        :rtype: float
        """
        return self._enclosed_parking

    @enclosed_parking.setter
    def enclosed_parking(self, enclosed_parking: float):
        """Sets the enclosed_parking of this ListingProperty.

        Total enclosed parking.  # noqa: E501

        :param enclosed_parking: The enclosed_parking of this ListingProperty.
        :type enclosed_parking: float
        """

        self._enclosed_parking = enclosed_parking

    @property
    def roof_type(self) -> str:
        """Gets the roof_type of this ListingProperty.

        The type of material of the roof.  # noqa: E501

        :return: The roof_type of this ListingProperty.
        :rtype: str
        """
        return self._roof_type

    @roof_type.setter
    def roof_type(self, roof_type: str):
        """Sets the roof_type of this ListingProperty.

        The type of material of the roof.  # noqa: E501

        :param roof_type: The roof_type of this ListingProperty.
        :type roof_type: str
        """
        allowed_values = ["Asphalt Shingles", "Concrete Tiles", "Wood Shingles", "Clay Tile", "Metal", "Tar & Gravel", "Pine Shakes", "Vinyl Shingles", "Cedar Shakes", "EPDM Membrane", "See Remarks", "Roll Roofing", "Fiberglass"]  # noqa: E501
        if roof_type not in allowed_values:
            raise ValueError(
                "Invalid value for `roof_type` ({0}), must be one of {1}"
                .format(roof_type, allowed_values)
            )

        self._roof_type = roof_type

    @property
    def roof_age_years(self) -> int:
        """Gets the roof_age_years of this ListingProperty.

        The age of the roof in years.  # noqa: E501

        :return: The roof_age_years of this ListingProperty.
        :rtype: int
        """
        return self._roof_age_years

    @roof_age_years.setter
    def roof_age_years(self, roof_age_years: int):
        """Sets the roof_age_years of this ListingProperty.

        The age of the roof in years.  # noqa: E501

        :param roof_age_years: The roof_age_years of this ListingProperty.
        :type roof_age_years: int
        """

        self._roof_age_years = roof_age_years

    @property
    def is_renovated(self) -> bool:
        """Gets the is_renovated of this ListingProperty.

        Has the house been renovated?  # noqa: E501

        :return: The is_renovated of this ListingProperty.
        :rtype: bool
        """
        return self._is_renovated

    @is_renovated.setter
    def is_renovated(self, is_renovated: bool):
        """Sets the is_renovated of this ListingProperty.

        Has the house been renovated?  # noqa: E501

        :param is_renovated: The is_renovated of this ListingProperty.
        :type is_renovated: bool
        """

        self._is_renovated = is_renovated

    @property
    def renovations_or_upgrades(self) -> str:
        """Gets the renovations_or_upgrades of this ListingProperty.

        The renovations or upgrades.  # noqa: E501

        :return: The renovations_or_upgrades of this ListingProperty.
        :rtype: str
        """
        return self._renovations_or_upgrades

    @renovations_or_upgrades.setter
    def renovations_or_upgrades(self, renovations_or_upgrades: str):
        """Sets the renovations_or_upgrades of this ListingProperty.

        The renovations or upgrades.  # noqa: E501

        :param renovations_or_upgrades: The renovations_or_upgrades of this ListingProperty.
        :type renovations_or_upgrades: str
        """

        self._renovations_or_upgrades = renovations_or_upgrades

    @property
    def property_photos_user_submitted(self) -> str:
        """Gets the property_photos_user_submitted of this ListingProperty.

        The photos of the home.  # noqa: E501

        :return: The property_photos_user_submitted of this ListingProperty.
        :rtype: str
        """
        return self._property_photos_user_submitted

    @property_photos_user_submitted.setter
    def property_photos_user_submitted(self, property_photos_user_submitted: str):
        """Sets the property_photos_user_submitted of this ListingProperty.

        The photos of the home.  # noqa: E501

        :param property_photos_user_submitted: The property_photos_user_submitted of this ListingProperty.
        :type property_photos_user_submitted: str
        """

        self._property_photos_user_submitted = property_photos_user_submitted

    @property
    def latitude(self) -> float:
        """Gets the latitude of this ListingProperty.

        The latitude of the location  # noqa: E501

        :return: The latitude of this ListingProperty.
        :rtype: float
        """
        return self._latitude

    @latitude.setter
    def latitude(self, latitude: float):
        """Sets the latitude of this ListingProperty.

        The latitude of the location  # noqa: E501

        :param latitude: The latitude of this ListingProperty.
        :type latitude: float
        """

        self._latitude = latitude

    @property
    def longitude(self) -> float:
        """Gets the longitude of this ListingProperty.

        The longitude of the location  # noqa: E501

        :return: The longitude of this ListingProperty.
        :rtype: float
        """
        return self._longitude

    @longitude.setter
    def longitude(self, longitude: float):
        """Sets the longitude of this ListingProperty.

        The longitude of the location  # noqa: E501

        :param longitude: The longitude of this ListingProperty.
        :type longitude: float
        """

        self._longitude = longitude

    @property
    def google_place_id(self) -> str:
        """Gets the google_place_id of this ListingProperty.

        The google place id for this location  # noqa: E501

        :return: The google_place_id of this ListingProperty.
        :rtype: str
        """
        return self._google_place_id

    @google_place_id.setter
    def google_place_id(self, google_place_id: str):
        """Sets the google_place_id of this ListingProperty.

        The google place id for this location  # noqa: E501

        :param google_place_id: The google_place_id of this ListingProperty.
        :type google_place_id: str
        """

        self._google_place_id = google_place_id

    @property
    def building_place_id(self) -> str:
        """Gets the building_place_id of this ListingProperty.

        The google place id for the whole building  # noqa: E501

        :return: The building_place_id of this ListingProperty.
        :rtype: str
        """
        return self._building_place_id

    @building_place_id.setter
    def building_place_id(self, building_place_id: str):
        """Sets the building_place_id of this ListingProperty.

        The google place id for the whole building  # noqa: E501

        :param building_place_id: The building_place_id of this ListingProperty.
        :type building_place_id: str
        """

        self._building_place_id = building_place_id

    @property
    def geo_hash5(self) -> str:
        """Gets the geo_hash5 of this ListingProperty.

        The geohash 5 character precision  # noqa: E501

        :return: The geo_hash5 of this ListingProperty.
        :rtype: str
        """
        return self._geo_hash5

    @geo_hash5.setter
    def geo_hash5(self, geo_hash5: str):
        """Sets the geo_hash5 of this ListingProperty.

        The geohash 5 character precision  # noqa: E501

        :param geo_hash5: The geo_hash5 of this ListingProperty.
        :type geo_hash5: str
        """

        self._geo_hash5 = geo_hash5

    @property
    def geo_hash12(self) -> str:
        """Gets the geo_hash12 of this ListingProperty.

        The full geohash  # noqa: E501

        :return: The geo_hash12 of this ListingProperty.
        :rtype: str
        """
        return self._geo_hash12

    @geo_hash12.setter
    def geo_hash12(self, geo_hash12: str):
        """Sets the geo_hash12 of this ListingProperty.

        The full geohash  # noqa: E501

        :param geo_hash12: The geo_hash12 of this ListingProperty.
        :type geo_hash12: str
        """

        self._geo_hash12 = geo_hash12

    @property
    def custom_annotations(self) -> List[CustomAnnotation]:
        """Gets the custom_annotations of this ListingProperty.


        :return: The custom_annotations of this ListingProperty.
        :rtype: List[CustomAnnotation]
        """
        return self._custom_annotations

    @custom_annotations.setter
    def custom_annotations(self, custom_annotations: List[CustomAnnotation]):
        """Sets the custom_annotations of this ListingProperty.


        :param custom_annotations: The custom_annotations of this ListingProperty.
        :type custom_annotations: List[CustomAnnotation]
        """

        self._custom_annotations = custom_annotations

    @property
    def images(self) -> List[Image]:
        """Gets the images of this ListingProperty.


        :return: The images of this ListingProperty.
        :rtype: List[Image]
        """
        return self._images

    @images.setter
    def images(self, images: List[Image]):
        """Sets the images of this ListingProperty.


        :param images: The images of this ListingProperty.
        :type images: List[Image]
        """

        self._images = images

    @property
    def rooms(self) -> List[List[str]]:
        """Gets the rooms of this ListingProperty.

        Information about the rooms in the home with room type, level, dimensions in feet  # noqa: E501

        :return: The rooms of this ListingProperty.
        :rtype: List[List[str]]
        """
        return self._rooms

    @rooms.setter
    def rooms(self, rooms: List[List[str]]):
        """Sets the rooms of this ListingProperty.

        Information about the rooms in the home with room type, level, dimensions in feet  # noqa: E501

        :param rooms: The rooms of this ListingProperty.
        :type rooms: List[List[str]]
        """

        self._rooms = rooms

    @property
    def property_rooms(self) -> List[Room]:
        """Gets the property_rooms of this ListingProperty.

        Information about the rooms in the home with room type, level, dimensions in feet  # noqa: E501

        :return: The property_rooms of this ListingProperty.
        :rtype: List[Room]
        """
        return self._property_rooms

    @property_rooms.setter
    def property_rooms(self, property_rooms: List[Room]):
        """Sets the property_rooms of this ListingProperty.

        Information about the rooms in the home with room type, level, dimensions in feet  # noqa: E501

        :param property_rooms: The property_rooms of this ListingProperty.
        :type property_rooms: List[Room]
        """

        self._property_rooms = property_rooms

    @property
    def tax_assessment_roll_number(self) -> str:
        """Gets the tax_assessment_roll_number of this ListingProperty.

        The tax assessment identification number. May be called \"roll number\" depending on the community.  # noqa: E501

        :return: The tax_assessment_roll_number of this ListingProperty.
        :rtype: str
        """
        return self._tax_assessment_roll_number

    @tax_assessment_roll_number.setter
    def tax_assessment_roll_number(self, tax_assessment_roll_number: str):
        """Sets the tax_assessment_roll_number of this ListingProperty.

        The tax assessment identification number. May be called \"roll number\" depending on the community.  # noqa: E501

        :param tax_assessment_roll_number: The tax_assessment_roll_number of this ListingProperty.
        :type tax_assessment_roll_number: str
        """

        self._tax_assessment_roll_number = tax_assessment_roll_number

    @property
    def assessed_year(self) -> int:
        """Gets the assessed_year of this ListingProperty.

        The year the tax assessed value is valid for.  # noqa: E501

        :return: The assessed_year of this ListingProperty.
        :rtype: int
        """
        return self._assessed_year

    @assessed_year.setter
    def assessed_year(self, assessed_year: int):
        """Sets the assessed_year of this ListingProperty.

        The year the tax assessed value is valid for.  # noqa: E501

        :param assessed_year: The assessed_year of this ListingProperty.
        :type assessed_year: int
        """

        self._assessed_year = assessed_year

    @property
    def air_conditioning(self) -> str:
        """Gets the air_conditioning of this ListingProperty.

        The type of air conditioning  # noqa: E501

        :return: The air_conditioning of this ListingProperty.
        :rtype: str
        """
        return self._air_conditioning

    @air_conditioning.setter
    def air_conditioning(self, air_conditioning: str):
        """Sets the air_conditioning of this ListingProperty.

        The type of air conditioning  # noqa: E501

        :param air_conditioning: The air_conditioning of this ListingProperty.
        :type air_conditioning: str
        """
        allowed_values = ["Other", "Central Air", "Wall Unit", "Window Unit", "None"]  # noqa: E501
        if air_conditioning not in allowed_values:
            raise ValueError(
                "Invalid value for `air_conditioning` ({0}), must be one of {1}"
                .format(air_conditioning, allowed_values)
            )

        self._air_conditioning = air_conditioning

    @property
    def approx_sqft(self) -> str:
        """Gets the approx_sqft of this ListingProperty.

        An indication of approximate SQFT where actual SQFT is unknown  # noqa: E501

        :return: The approx_sqft of this ListingProperty.
        :rtype: str
        """
        return self._approx_sqft

    @approx_sqft.setter
    def approx_sqft(self, approx_sqft: str):
        """Sets the approx_sqft of this ListingProperty.

        An indication of approximate SQFT where actual SQFT is unknown  # noqa: E501

        :param approx_sqft: The approx_sqft of this ListingProperty.
        :type approx_sqft: str
        """

        self._approx_sqft = approx_sqft

    @property
    def elevator(self) -> bool:
        """Gets the elevator of this ListingProperty.

        Is there an elevator to the unit for condos or within the property for multiplexes?  # noqa: E501

        :return: The elevator of this ListingProperty.
        :rtype: bool
        """
        return self._elevator

    @elevator.setter
    def elevator(self, elevator: bool):
        """Sets the elevator of this ListingProperty.

        Is there an elevator to the unit for condos or within the property for multiplexes?  # noqa: E501

        :param elevator: The elevator of this ListingProperty.
        :type elevator: bool
        """

        self._elevator = elevator

    @property
    def direction_faces(self) -> str:
        """Gets the direction_faces of this ListingProperty.

        Direction the front faces  # noqa: E501

        :return: The direction_faces of this ListingProperty.
        :rtype: str
        """
        return self._direction_faces

    @direction_faces.setter
    def direction_faces(self, direction_faces: str):
        """Sets the direction_faces of this ListingProperty.

        Direction the front faces  # noqa: E501

        :param direction_faces: The direction_faces of this ListingProperty.
        :type direction_faces: str
        """
        allowed_values = ["N", "S", "E", "W", "NW", "NE", "SW", "SE", "None"]  # noqa: E501
        if direction_faces not in allowed_values:
            raise ValueError(
                "Invalid value for `direction_faces` ({0}), must be one of {1}"
                .format(direction_faces, allowed_values)
            )

        self._direction_faces = direction_faces

    @property
    def basement_ensuite(self) -> bool:
        """Gets the basement_ensuite of this ListingProperty.

        Is there an apartment unit in your basement?  # noqa: E501

        :return: The basement_ensuite of this ListingProperty.
        :rtype: bool
        """
        return self._basement_ensuite

    @basement_ensuite.setter
    def basement_ensuite(self, basement_ensuite: bool):
        """Sets the basement_ensuite of this ListingProperty.

        Is there an apartment unit in your basement?  # noqa: E501

        :param basement_ensuite: The basement_ensuite of this ListingProperty.
        :type basement_ensuite: bool
        """

        self._basement_ensuite = basement_ensuite

    @property
    def is_ph(self) -> bool:
        """Gets the is_ph of this ListingProperty.

        Is your unit a penthouse unit?  # noqa: E501

        :return: The is_ph of this ListingProperty.
        :rtype: bool
        """
        return self._is_ph

    @is_ph.setter
    def is_ph(self, is_ph: bool):
        """Sets the is_ph of this ListingProperty.

        Is your unit a penthouse unit?  # noqa: E501

        :param is_ph: The is_ph of this ListingProperty.
        :type is_ph: bool
        """

        self._is_ph = is_ph

    @property
    def entry_level(self) -> float:
        """Gets the entry_level of this ListingProperty.

        The entryLevel of a condo/apartment. Equivalent to the floor number minus any missing floors (e.g. floor 13 doesn't exist for some buildings)  # noqa: E501

        :return: The entry_level of this ListingProperty.
        :rtype: float
        """
        return self._entry_level

    @entry_level.setter
    def entry_level(self, entry_level: float):
        """Sets the entry_level of this ListingProperty.

        The entryLevel of a condo/apartment. Equivalent to the floor number minus any missing floors (e.g. floor 13 doesn't exist for some buildings)  # noqa: E501

        :param entry_level: The entry_level of this ListingProperty.
        :type entry_level: float
        """

        self._entry_level = entry_level

    @property
    def unit_number(self) -> str:
        """Gets the unit_number of this ListingProperty.

        Unit number for apartments and condos  # noqa: E501

        :return: The unit_number of this ListingProperty.
        :rtype: str
        """
        return self._unit_number

    @unit_number.setter
    def unit_number(self, unit_number: str):
        """Sets the unit_number of this ListingProperty.

        Unit number for apartments and condos  # noqa: E501

        :param unit_number: The unit_number of this ListingProperty.
        :type unit_number: str
        """

        self._unit_number = unit_number

    @property
    def share_percentage(self) -> str:
        """Gets the share_percentage of this ListingProperty.

        The percent shares in the property  # noqa: E501

        :return: The share_percentage of this ListingProperty.
        :rtype: str
        """
        return self._share_percentage

    @share_percentage.setter
    def share_percentage(self, share_percentage: str):
        """Sets the share_percentage of this ListingProperty.

        The percent shares in the property  # noqa: E501

        :param share_percentage: The share_percentage of this ListingProperty.
        :type share_percentage: str
        """

        self._share_percentage = share_percentage

    @property
    def patio_and_porch_features(self) -> str:
        """Gets the patio_and_porch_features of this ListingProperty.

        Description of the patio, proch, or balcony  # noqa: E501

        :return: The patio_and_porch_features of this ListingProperty.
        :rtype: str
        """
        return self._patio_and_porch_features

    @patio_and_porch_features.setter
    def patio_and_porch_features(self, patio_and_porch_features: str):
        """Sets the patio_and_porch_features of this ListingProperty.

        Description of the patio, proch, or balcony  # noqa: E501

        :param patio_and_porch_features: The patio_and_porch_features of this ListingProperty.
        :type patio_and_porch_features: str
        """

        self._patio_and_porch_features = patio_and_porch_features

    @property
    def association_amenities(self) -> List[str]:
        """Gets the association_amenities of this ListingProperty.

        The list of shared amenities for this property  # noqa: E501

        :return: The association_amenities of this ListingProperty.
        :rtype: List[str]
        """
        return self._association_amenities

    @association_amenities.setter
    def association_amenities(self, association_amenities: List[str]):
        """Sets the association_amenities of this ListingProperty.

        The list of shared amenities for this property  # noqa: E501

        :param association_amenities: The association_amenities of this ListingProperty.
        :type association_amenities: List[str]
        """

        self._association_amenities = association_amenities

    @property
    def locker(self) -> str:
        """Gets the locker of this ListingProperty.

        Type of locker that comes with this property  # noqa: E501

        :return: The locker of this ListingProperty.
        :rtype: str
        """
        return self._locker

    @locker.setter
    def locker(self, locker: str):
        """Sets the locker of this ListingProperty.

        Type of locker that comes with this property  # noqa: E501

        :param locker: The locker of this ListingProperty.
        :type locker: str
        """
        allowed_values = ["Owned", "Exclusive", "Ensuite", "Ensuite & Owned", "Ensuite & Exclusive", "Ensuite & Common", "Common", "Not disclosed", "None"]  # noqa: E501
        if locker not in allowed_values:
            raise ValueError(
                "Invalid value for `locker` ({0}), must be one of {1}"
                .format(locker, allowed_values)
            )

        self._locker = locker

    @property
    def condo_corp_number(self) -> str:
        """Gets the condo_corp_number of this ListingProperty.

        The condominium corporation registration number  # noqa: E501

        :return: The condo_corp_number of this ListingProperty.
        :rtype: str
        """
        return self._condo_corp_number

    @condo_corp_number.setter
    def condo_corp_number(self, condo_corp_number: str):
        """Sets the condo_corp_number of this ListingProperty.

        The condominium corporation registration number  # noqa: E501

        :param condo_corp_number: The condo_corp_number of this ListingProperty.
        :type condo_corp_number: str
        """

        self._condo_corp_number = condo_corp_number

    @property
    def condo_corp(self) -> str:
        """Gets the condo_corp of this ListingProperty.

        The condominium corporation name  # noqa: E501

        :return: The condo_corp of this ListingProperty.
        :rtype: str
        """
        return self._condo_corp

    @condo_corp.setter
    def condo_corp(self, condo_corp: str):
        """Sets the condo_corp of this ListingProperty.

        The condominium corporation name  # noqa: E501

        :param condo_corp: The condo_corp of this ListingProperty.
        :type condo_corp: str
        """

        self._condo_corp = condo_corp

    @property
    def laundry_features(self) -> List[str]:
        """Gets the laundry_features of this ListingProperty.

        The list of available laundry features  # noqa: E501

        :return: The laundry_features of this ListingProperty.
        :rtype: List[str]
        """
        return self._laundry_features

    @laundry_features.setter
    def laundry_features(self, laundry_features: List[str]):
        """Sets the laundry_features of this ListingProperty.

        The list of available laundry features  # noqa: E501

        :param laundry_features: The laundry_features of this ListingProperty.
        :type laundry_features: List[str]
        """

        self._laundry_features = laundry_features

    @property
    def association_fee(self) -> float:
        """Gets the association_fee of this ListingProperty.

        The condominium or housing authority fee  # noqa: E501

        :return: The association_fee of this ListingProperty.
        :rtype: float
        """
        return self._association_fee

    @association_fee.setter
    def association_fee(self, association_fee: float):
        """Sets the association_fee of this ListingProperty.

        The condominium or housing authority fee  # noqa: E501

        :param association_fee: The association_fee of this ListingProperty.
        :type association_fee: float
        """

        self._association_fee = association_fee

    @property
    def parking_fee(self) -> float:
        """Gets the parking_fee of this ListingProperty.

        The fee for the parking space(s)  # noqa: E501

        :return: The parking_fee of this ListingProperty.
        :rtype: float
        """
        return self._parking_fee

    @parking_fee.setter
    def parking_fee(self, parking_fee: float):
        """Sets the parking_fee of this ListingProperty.

        The fee for the parking space(s)  # noqa: E501

        :param parking_fee: The parking_fee of this ListingProperty.
        :type parking_fee: float
        """

        self._parking_fee = parking_fee

    @property
    def parking_included(self) -> bool:
        """Gets the parking_included of this ListingProperty.

        Is parking including  # noqa: E501

        :return: The parking_included of this ListingProperty.
        :rtype: bool
        """
        return self._parking_included

    @parking_included.setter
    def parking_included(self, parking_included: bool):
        """Sets the parking_included of this ListingProperty.

        Is parking including  # noqa: E501

        :param parking_included: The parking_included of this ListingProperty.
        :type parking_included: bool
        """

        self._parking_included = parking_included

    @property
    def pets_allowed(self) -> str:
        """Gets the pets_allowed of this ListingProperty.

        Whether pet are allowed and the conditions which they are allowed  # noqa: E501

        :return: The pets_allowed of this ListingProperty.
        :rtype: str
        """
        return self._pets_allowed

    @pets_allowed.setter
    def pets_allowed(self, pets_allowed: str):
        """Sets the pets_allowed of this ListingProperty.

        Whether pet are allowed and the conditions which they are allowed  # noqa: E501

        :param pets_allowed: The pets_allowed of this ListingProperty.
        :type pets_allowed: str
        """

        self._pets_allowed = pets_allowed

    @property
    def city(self) -> str:
        """Gets the city of this ListingProperty.

        The city or municipality of the property  # noqa: E501

        :return: The city of this ListingProperty.
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city: str):
        """Sets the city of this ListingProperty.

        The city or municipality of the property  # noqa: E501

        :param city: The city of this ListingProperty.
        :type city: str
        """

        self._city = city

    @property
    def province(self) -> str:
        """Gets the province of this ListingProperty.

        The proviuce of the property  # noqa: E501

        :return: The province of this ListingProperty.
        :rtype: str
        """
        return self._province

    @province.setter
    def province(self, province: str):
        """Sets the province of this ListingProperty.

        The proviuce of the property  # noqa: E501

        :param province: The province of this ListingProperty.
        :type province: str
        """

        self._province = province

    @property
    def stories(self) -> int:
        """Gets the stories of this ListingProperty.

        The number of floors in the building.  # noqa: E501

        :return: The stories of this ListingProperty.
        :rtype: int
        """
        return self._stories

    @stories.setter
    def stories(self, stories: int):
        """Sets the stories of this ListingProperty.

        The number of floors in the building.  # noqa: E501

        :param stories: The stories of this ListingProperty.
        :type stories: int
        """

        self._stories = stories

    @property
    def building_name(self) -> str:
        """Gets the building_name of this ListingProperty.

        The name of the building  # noqa: E501

        :return: The building_name of this ListingProperty.
        :rtype: str
        """
        return self._building_name

    @building_name.setter
    def building_name(self, building_name: str):
        """Sets the building_name of this ListingProperty.

        The name of the building  # noqa: E501

        :param building_name: The building_name of this ListingProperty.
        :type building_name: str
        """

        self._building_name = building_name

    @property
    def association_fee_frequency(self) -> str:
        """Gets the association_fee_frequency of this ListingProperty.

        The period of time at which the Association Fee is charged  # noqa: E501

        :return: The association_fee_frequency of this ListingProperty.
        :rtype: str
        """
        return self._association_fee_frequency

    @association_fee_frequency.setter
    def association_fee_frequency(self, association_fee_frequency: str):
        """Sets the association_fee_frequency of this ListingProperty.

        The period of time at which the Association Fee is charged  # noqa: E501

        :param association_fee_frequency: The association_fee_frequency of this ListingProperty.
        :type association_fee_frequency: str
        """

        self._association_fee_frequency = association_fee_frequency

    @property
    def list_agent_phone(self) -> str:
        """Gets the list_agent_phone of this ListingProperty.

        The listing agent's phone number  # noqa: E501

        :return: The list_agent_phone of this ListingProperty.
        :rtype: str
        """
        return self._list_agent_phone

    @list_agent_phone.setter
    def list_agent_phone(self, list_agent_phone: str):
        """Sets the list_agent_phone of this ListingProperty.

        The listing agent's phone number  # noqa: E501

        :param list_agent_phone: The list_agent_phone of this ListingProperty.
        :type list_agent_phone: str
        """

        self._list_agent_phone = list_agent_phone

    @property
    def list_agent_email(self) -> str:
        """Gets the list_agent_email of this ListingProperty.

        The listing agent's email  # noqa: E501

        :return: The list_agent_email of this ListingProperty.
        :rtype: str
        """
        return self._list_agent_email

    @list_agent_email.setter
    def list_agent_email(self, list_agent_email: str):
        """Sets the list_agent_email of this ListingProperty.

        The listing agent's email  # noqa: E501

        :param list_agent_email: The list_agent_email of this ListingProperty.
        :type list_agent_email: str
        """

        self._list_agent_email = list_agent_email

    @property
    def list_agent_full_name(self) -> str:
        """Gets the list_agent_full_name of this ListingProperty.

        The listing agent's full name  # noqa: E501

        :return: The list_agent_full_name of this ListingProperty.
        :rtype: str
        """
        return self._list_agent_full_name

    @list_agent_full_name.setter
    def list_agent_full_name(self, list_agent_full_name: str):
        """Sets the list_agent_full_name of this ListingProperty.

        The listing agent's full name  # noqa: E501

        :param list_agent_full_name: The list_agent_full_name of this ListingProperty.
        :type list_agent_full_name: str
        """

        self._list_agent_full_name = list_agent_full_name

    @property
    def list_agent_mls_id(self) -> str:
        """Gets the list_agent_mls_id of this ListingProperty.

        The listing agent's MLS ID code  # noqa: E501

        :return: The list_agent_mls_id of this ListingProperty.
        :rtype: str
        """
        return self._list_agent_mls_id

    @list_agent_mls_id.setter
    def list_agent_mls_id(self, list_agent_mls_id: str):
        """Sets the list_agent_mls_id of this ListingProperty.

        The listing agent's MLS ID code  # noqa: E501

        :param list_agent_mls_id: The list_agent_mls_id of this ListingProperty.
        :type list_agent_mls_id: str
        """

        self._list_agent_mls_id = list_agent_mls_id

    @property
    def list_price(self) -> float:
        """Gets the list_price of this ListingProperty.

        The amount the seller is listing the home for  # noqa: E501

        :return: The list_price of this ListingProperty.
        :rtype: float
        """
        return self._list_price

    @list_price.setter
    def list_price(self, list_price: float):
        """Sets the list_price of this ListingProperty.

        The amount the seller is listing the home for  # noqa: E501

        :param list_price: The list_price of this ListingProperty.
        :type list_price: float
        """
        if list_price is None:
            raise ValueError("Invalid value for `list_price`, must not be `None`")  # noqa: E501

        self._list_price = list_price

    @property
    def list_date(self) -> str:
        """Gets the list_date of this ListingProperty.

        The date the home was initially listed at in ISO 8601 Date format (eg. 2019-01-30)  # noqa: E501

        :return: The list_date of this ListingProperty.
        :rtype: str
        """
        return self._list_date

    @list_date.setter
    def list_date(self, list_date: str):
        """Sets the list_date of this ListingProperty.

        The date the home was initially listed at in ISO 8601 Date format (eg. 2019-01-30)  # noqa: E501

        :param list_date: The list_date of this ListingProperty.
        :type list_date: str
        """

        self._list_date = list_date

    @property
    def listing_firm_name(self) -> str:
        """Gets the listing_firm_name of this ListingProperty.

        The brokerage listing the home  # noqa: E501

        :return: The listing_firm_name of this ListingProperty.
        :rtype: str
        """
        return self._listing_firm_name

    @listing_firm_name.setter
    def listing_firm_name(self, listing_firm_name: str):
        """Sets the listing_firm_name of this ListingProperty.

        The brokerage listing the home  # noqa: E501

        :param listing_firm_name: The listing_firm_name of this ListingProperty.
        :type listing_firm_name: str
        """

        self._listing_firm_name = listing_firm_name

    @property
    def dom(self) -> float:
        """Gets the dom of this ListingProperty.

        The number of days on market before sold  # noqa: E501

        :return: The dom of this ListingProperty.
        :rtype: float
        """
        return self._dom

    @dom.setter
    def dom(self, dom: float):
        """Sets the dom of this ListingProperty.

        The number of days on market before sold  # noqa: E501

        :param dom: The dom of this ListingProperty.
        :type dom: float
        """

        self._dom = dom

    @property
    def base_description(self) -> str:
        """Gets the base_description of this ListingProperty.

        The description of the property  # noqa: E501

        :return: The base_description of this ListingProperty.
        :rtype: str
        """
        return self._base_description

    @base_description.setter
    def base_description(self, base_description: str):
        """Sets the base_description of this ListingProperty.

        The description of the property  # noqa: E501

        :param base_description: The base_description of this ListingProperty.
        :type base_description: str
        """

        self._base_description = base_description

    @property
    def mls_id(self) -> str:
        """Gets the mls_id of this ListingProperty.

        ID reference to a MLS system  # noqa: E501

        :return: The mls_id of this ListingProperty.
        :rtype: str
        """
        return self._mls_id

    @mls_id.setter
    def mls_id(self, mls_id: str):
        """Sets the mls_id of this ListingProperty.

        ID reference to a MLS system  # noqa: E501

        :param mls_id: The mls_id of this ListingProperty.
        :type mls_id: str
        """

        self._mls_id = mls_id

    @property
    def lease(self) -> bool:
        """Gets the lease of this ListingProperty.

        Is this listing property a lease?  # noqa: E501

        :return: The lease of this ListingProperty.
        :rtype: bool
        """
        return self._lease

    @lease.setter
    def lease(self, lease: bool):
        """Sets the lease of this ListingProperty.

        Is this listing property a lease?  # noqa: E501

        :param lease: The lease of this ListingProperty.
        :type lease: bool
        """

        self._lease = lease
