# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from properly_model_python.search_models.models.simple_listing import SimpleListing
from properly_model_python.search_models.models.base_model_ import Model
from properly_model_python.search_models import util


class SearchResult(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(
        self,
        id: str = None,
        search_id: str = None,
        search_as_of_millis: int = None,
        results: List[SimpleListing] = None,
    ):  # noqa: E501
        """SearchResult - a model defined in Swagger

        :param id: The id of this SearchResult.  # noqa: E501
        :type id: str
        :param search_id: The search_id of this SearchResult.  # noqa: E501
        :type search_id: str
        :param search_as_of_millis: The search_as_of_millis of this SearchResult.  # noqa: E501
        :type search_as_of_millis: int
        :param results: The results of this SearchResult.  # noqa: E501
        :type results: List[SimpleListing]
        """
        self.swagger_types = {"id": str, "search_id": str, "search_as_of_millis": int, "results": List[SimpleListing]}

        self.attribute_map = {
            "id": "id",
            "search_id": "searchId",
            "search_as_of_millis": "searchAsOfMillis",
            "results": "results",
        }

        self._id = id
        self._search_id = search_id
        self._search_as_of_millis = search_as_of_millis
        self._results = results

    @classmethod
    def from_dict(cls, dikt) -> "SearchResult":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The SearchResult of this SearchResult.  # noqa: E501
        :rtype: SearchResult
        """
        return util.deserialize_model(dikt, cls)

    @property
    def id(self) -> str:
        """Gets the id of this SearchResult.

        identifier for this result run  # noqa: E501

        :return: The id of this SearchResult.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str):
        """Sets the id of this SearchResult.

        identifier for this result run  # noqa: E501

        :param id: The id of this SearchResult.
        :type id: str
        """

        self._id = id

    @property
    def search_id(self) -> str:
        """Gets the search_id of this SearchResult.

        identifier for the search used to generate this result  # noqa: E501

        :return: The search_id of this SearchResult.
        :rtype: str
        """
        return self._search_id

    @search_id.setter
    def search_id(self, search_id: str):
        """Sets the search_id of this SearchResult.

        identifier for the search used to generate this result  # noqa: E501

        :param search_id: The search_id of this SearchResult.
        :type search_id: str
        """

        self._search_id = search_id

    @property
    def search_as_of_millis(self) -> int:
        """Gets the search_as_of_millis of this SearchResult.

        millis since epoch when search conducted  # noqa: E501

        :return: The search_as_of_millis of this SearchResult.
        :rtype: int
        """
        return self._search_as_of_millis

    @search_as_of_millis.setter
    def search_as_of_millis(self, search_as_of_millis: int):
        """Sets the search_as_of_millis of this SearchResult.

        millis since epoch when search conducted  # noqa: E501

        :param search_as_of_millis: The search_as_of_millis of this SearchResult.
        :type search_as_of_millis: int
        """

        self._search_as_of_millis = search_as_of_millis

    @property
    def results(self) -> List[SimpleListing]:
        """Gets the results of this SearchResult.


        :return: The results of this SearchResult.
        :rtype: List[SimpleListing]
        """
        return self._results

    @results.setter
    def results(self, results: List[SimpleListing]):
        """Sets the results of this SearchResult.


        :param results: The results of this SearchResult.
        :type results: List[SimpleListing]
        """

        self._results = results
