# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from properly_model_python.models.base_model_ import Model
from properly_model_python import util


class SearchNotification(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, id: str=None, alert_type: str=None, user: Person=None, new_results: List[SimpleListing]=None, unsubscribe_url: str=None, searcher: Person=None, search: Search=None, changed_results: List[SimpleListing]=None):  # noqa: E501
        """SearchNotification - a model defined in Swagger

        :param id: The id of this SearchNotification.  # noqa: E501
        :type id: str
        :param alert_type: The alert_type of this SearchNotification.  # noqa: E501
        :type alert_type: str
        :param user: The user of this SearchNotification.  # noqa: E501
        :type user: Person
        :param new_results: The new_results of this SearchNotification.  # noqa: E501
        :type new_results: List[SimpleListing]
        :param unsubscribe_url: The unsubscribe_url of this SearchNotification.  # noqa: E501
        :type unsubscribe_url: str
        :param searcher: The searcher of this SearchNotification.  # noqa: E501
        :type searcher: Person
        :param search: The search of this SearchNotification.  # noqa: E501
        :type search: Search
        :param changed_results: The changed_results of this SearchNotification.  # noqa: E501
        :type changed_results: List[SimpleListing]
        """
        self.swagger_types = {
            'id': str,
            'alert_type': str,
            'user': Person,
            'new_results': List[SimpleListing],
            'unsubscribe_url': str,
            'searcher': Person,
            'search': Search,
            'changed_results': List[SimpleListing]
        }

        self.attribute_map = {
            'id': 'id',
            'alert_type': 'alertType',
            'user': 'user',
            'new_results': 'newResults',
            'unsubscribe_url': 'unsubscribeUrl',
            'searcher': 'searcher',
            'search': 'search',
            'changed_results': 'changedResults'
        }

        self._id = id
        self._alert_type = alert_type
        self._user = user
        self._new_results = new_results
        self._unsubscribe_url = unsubscribe_url
        self._searcher = searcher
        self._search = search
        self._changed_results = changed_results

    @classmethod
    def from_dict(cls, dikt) -> 'SearchNotification':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The SearchNotification of this SearchNotification.  # noqa: E501
        :rtype: SearchNotification
        """
        return util.deserialize_model(dikt, cls)

    @property
    def id(self) -> str:
        """Gets the id of this SearchNotification.

        identifies the notification  # noqa: E501

        :return: The id of this SearchNotification.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str):
        """Sets the id of this SearchNotification.

        identifies the notification  # noqa: E501

        :param id: The id of this SearchNotification.
        :type id: str
        """

        self._id = id

    @property
    def alert_type(self) -> str:
        """Gets the alert_type of this SearchNotification.

        The type of alert notification this is  # noqa: E501

        :return: The alert_type of this SearchNotification.
        :rtype: str
        """
        return self._alert_type

    @alert_type.setter
    def alert_type(self, alert_type: str):
        """Sets the alert_type of this SearchNotification.

        The type of alert notification this is  # noqa: E501

        :param alert_type: The alert_type of this SearchNotification.
        :type alert_type: str
        """

        self._alert_type = alert_type

    @property
    def user(self) -> Person:
        """Gets the user of this SearchNotification.


        :return: The user of this SearchNotification.
        :rtype: Person
        """
        return self._user

    @user.setter
    def user(self, user: Person):
        """Sets the user of this SearchNotification.


        :param user: The user of this SearchNotification.
        :type user: Person
        """

        self._user = user

    @property
    def new_results(self) -> List[SimpleListing]:
        """Gets the new_results of this SearchNotification.


        :return: The new_results of this SearchNotification.
        :rtype: List[SimpleListing]
        """
        return self._new_results

    @new_results.setter
    def new_results(self, new_results: List[SimpleListing]):
        """Sets the new_results of this SearchNotification.


        :param new_results: The new_results of this SearchNotification.
        :type new_results: List[SimpleListing]
        """

        self._new_results = new_results

    @property
    def unsubscribe_url(self) -> str:
        """Gets the unsubscribe_url of this SearchNotification.

        A url which will unsubscribe the authenicated user from the alert.  # noqa: E501

        :return: The unsubscribe_url of this SearchNotification.
        :rtype: str
        """
        return self._unsubscribe_url

    @unsubscribe_url.setter
    def unsubscribe_url(self, unsubscribe_url: str):
        """Sets the unsubscribe_url of this SearchNotification.

        A url which will unsubscribe the authenicated user from the alert.  # noqa: E501

        :param unsubscribe_url: The unsubscribe_url of this SearchNotification.
        :type unsubscribe_url: str
        """

        self._unsubscribe_url = unsubscribe_url

    @property
    def searcher(self) -> Person:
        """Gets the searcher of this SearchNotification.


        :return: The searcher of this SearchNotification.
        :rtype: Person
        """
        return self._searcher

    @searcher.setter
    def searcher(self, searcher: Person):
        """Sets the searcher of this SearchNotification.


        :param searcher: The searcher of this SearchNotification.
        :type searcher: Person
        """

        self._searcher = searcher

    @property
    def search(self) -> Search:
        """Gets the search of this SearchNotification.


        :return: The search of this SearchNotification.
        :rtype: Search
        """
        return self._search

    @search.setter
    def search(self, search: Search):
        """Sets the search of this SearchNotification.


        :param search: The search of this SearchNotification.
        :type search: Search
        """

        self._search = search

    @property
    def changed_results(self) -> List[SimpleListing]:
        """Gets the changed_results of this SearchNotification.


        :return: The changed_results of this SearchNotification.
        :rtype: List[SimpleListing]
        """
        return self._changed_results

    @changed_results.setter
    def changed_results(self, changed_results: List[SimpleListing]):
        """Sets the changed_results of this SearchNotification.


        :param changed_results: The changed_results of this SearchNotification.
        :type changed_results: List[SimpleListing]
        """

        self._changed_results = changed_results
