# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from properly_model_python.models.base_model_ import Model
from properly_model_python import util


class UsersAlert(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, alert_type: str=None, user_id: str=None, subscribed: bool=None, unsubscribed: bool=None):  # noqa: E501
        """UsersAlert - a model defined in Swagger

        :param alert_type: The alert_type of this UsersAlert.  # noqa: E501
        :type alert_type: str
        :param user_id: The user_id of this UsersAlert.  # noqa: E501
        :type user_id: str
        :param subscribed: The subscribed of this UsersAlert.  # noqa: E501
        :type subscribed: bool
        :param unsubscribed: The unsubscribed of this UsersAlert.  # noqa: E501
        :type unsubscribed: bool
        """
        self.swagger_types = {
            'alert_type': str,
            'user_id': str,
            'subscribed': bool,
            'unsubscribed': bool
        }

        self.attribute_map = {
            'alert_type': 'alertType',
            'user_id': 'userId',
            'subscribed': 'subscribed',
            'unsubscribed': 'unsubscribed'
        }

        self._alert_type = alert_type
        self._user_id = user_id
        self._subscribed = subscribed
        self._unsubscribed = unsubscribed

    @classmethod
    def from_dict(cls, dikt) -> 'UsersAlert':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The UsersAlert of this UsersAlert.  # noqa: E501
        :rtype: UsersAlert
        """
        return util.deserialize_model(dikt, cls)

    @property
    def alert_type(self) -> str:
        """Gets the alert_type of this UsersAlert.

        Type of alert  # noqa: E501

        :return: The alert_type of this UsersAlert.
        :rtype: str
        """
        return self._alert_type

    @alert_type.setter
    def alert_type(self, alert_type: str):
        """Sets the alert_type of this UsersAlert.

        Type of alert  # noqa: E501

        :param alert_type: The alert_type of this UsersAlert.
        :type alert_type: str
        """

        self._alert_type = alert_type

    @property
    def user_id(self) -> str:
        """Gets the user_id of this UsersAlert.


        :return: The user_id of this UsersAlert.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str):
        """Sets the user_id of this UsersAlert.


        :param user_id: The user_id of this UsersAlert.
        :type user_id: str
        """

        self._user_id = user_id

    @property
    def subscribed(self) -> bool:
        """Gets the subscribed of this UsersAlert.

        Whether the alert is currently subscribed to  # noqa: E501

        :return: The subscribed of this UsersAlert.
        :rtype: bool
        """
        return self._subscribed

    @subscribed.setter
    def subscribed(self, subscribed: bool):
        """Sets the subscribed of this UsersAlert.

        Whether the alert is currently subscribed to  # noqa: E501

        :param subscribed: The subscribed of this UsersAlert.
        :type subscribed: bool
        """

        self._subscribed = subscribed

    @property
    def unsubscribed(self) -> bool:
        """Gets the unsubscribed of this UsersAlert.

        Whether the alert has been unsubscribed from. Different from if the alert does not exist yet.  # noqa: E501

        :return: The unsubscribed of this UsersAlert.
        :rtype: bool
        """
        return self._unsubscribed

    @unsubscribed.setter
    def unsubscribed(self, unsubscribed: bool):
        """Sets the unsubscribed of this UsersAlert.

        Whether the alert has been unsubscribed from. Different from if the alert does not exist yet.  # noqa: E501

        :param unsubscribed: The unsubscribed of this UsersAlert.
        :type unsubscribed: bool
        """

        self._unsubscribed = unsubscribed
