# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from properly_model_python.models.base_model_ import Model
from properly_model_python.alert_models.models.person import Person
from properly_model_python.alert_models.models.simple_listing import SimpleListing
from properly_model_python import util


class AlertNotification(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, id: str=None, alert_type: str=None, user: Person=None, new_results: List[SimpleListing]=None, unsubscribe_url: str=None, properly_city_code: str=None):  # noqa: E501
        """AlertNotification - a model defined in Swagger

        :param id: The id of this AlertNotification.  # noqa: E501
        :type id: str
        :param alert_type: The alert_type of this AlertNotification.  # noqa: E501
        :type alert_type: str
        :param user: The user of this AlertNotification.  # noqa: E501
        :type user: Person
        :param new_results: The new_results of this AlertNotification.  # noqa: E501
        :type new_results: List[SimpleListing]
        :param unsubscribe_url: The unsubscribe_url of this AlertNotification.  # noqa: E501
        :type unsubscribe_url: str
        :param properly_city_code: The properly_city_code of this AlertNotification.  # noqa: E501
        :type properly_city_code: str
        """
        self.swagger_types = {
            'id': str,
            'alert_type': str,
            'user': Person,
            'new_results': List[SimpleListing],
            'unsubscribe_url': str,
            'properly_city_code': str
        }

        self.attribute_map = {
            'id': 'id',
            'alert_type': 'alertType',
            'user': 'user',
            'new_results': 'newResults',
            'unsubscribe_url': 'unsubscribeUrl',
            'properly_city_code': 'properlyCityCode'
        }

        self._id = id
        self._alert_type = alert_type
        self._user = user
        self._new_results = new_results
        self._unsubscribe_url = unsubscribe_url
        self._properly_city_code = properly_city_code

    @classmethod
    def from_dict(cls, dikt) -> 'AlertNotification':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The AlertNotification of this AlertNotification.  # noqa: E501
        :rtype: AlertNotification
        """
        return util.deserialize_model(dikt, cls)

    @property
    def id(self) -> str:
        """Gets the id of this AlertNotification.

        identifies the notification  # noqa: E501

        :return: The id of this AlertNotification.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str):
        """Sets the id of this AlertNotification.

        identifies the notification  # noqa: E501

        :param id: The id of this AlertNotification.
        :type id: str
        """

        self._id = id

    @property
    def alert_type(self) -> str:
        """Gets the alert_type of this AlertNotification.

        The type of alert notification this is  # noqa: E501

        :return: The alert_type of this AlertNotification.
        :rtype: str
        """
        return self._alert_type

    @alert_type.setter
    def alert_type(self, alert_type: str):
        """Sets the alert_type of this AlertNotification.

        The type of alert notification this is  # noqa: E501

        :param alert_type: The alert_type of this AlertNotification.
        :type alert_type: str
        """

        self._alert_type = alert_type

    @property
    def user(self) -> Person:
        """Gets the user of this AlertNotification.


        :return: The user of this AlertNotification.
        :rtype: Person
        """
        return self._user

    @user.setter
    def user(self, user: Person):
        """Sets the user of this AlertNotification.


        :param user: The user of this AlertNotification.
        :type user: Person
        """

        self._user = user

    @property
    def new_results(self) -> List[SimpleListing]:
        """Gets the new_results of this AlertNotification.


        :return: The new_results of this AlertNotification.
        :rtype: List[SimpleListing]
        """
        return self._new_results

    @new_results.setter
    def new_results(self, new_results: List[SimpleListing]):
        """Sets the new_results of this AlertNotification.


        :param new_results: The new_results of this AlertNotification.
        :type new_results: List[SimpleListing]
        """

        self._new_results = new_results

    @property
    def unsubscribe_url(self) -> str:
        """Gets the unsubscribe_url of this AlertNotification.

        A url which will unsubscribe the authenicated user from the alert.  # noqa: E501

        :return: The unsubscribe_url of this AlertNotification.
        :rtype: str
        """
        return self._unsubscribe_url

    @unsubscribe_url.setter
    def unsubscribe_url(self, unsubscribe_url: str):
        """Sets the unsubscribe_url of this AlertNotification.

        A url which will unsubscribe the authenicated user from the alert.  # noqa: E501

        :param unsubscribe_url: The unsubscribe_url of this AlertNotification.
        :type unsubscribe_url: str
        """

        self._unsubscribe_url = unsubscribe_url

    @property
    def properly_city_code(self) -> str:
        """Gets the properly_city_code of this AlertNotification.

        properly city code  # noqa: E501

        :return: The properly_city_code of this AlertNotification.
        :rtype: str
        """
        return self._properly_city_code

    @properly_city_code.setter
    def properly_city_code(self, properly_city_code: str):
        """Sets the properly_city_code of this AlertNotification.

        properly city code  # noqa: E501

        :param properly_city_code: The properly_city_code of this AlertNotification.
        :type properly_city_code: str
        """

        self._properly_city_code = properly_city_code
