# properly-util-python


## Quick Run

1. Setup the environment for development by calling ./setup.sh
2. Make your changes to the code
3. Increase the `version` in [setup.py](https://github.com/GoProperly/properly-util-python/blob/master/setup.py#L8)
4. Run `./tests.sh` to run automated tests.



## Uploading the Package

NOTE: This is necessary if you are Installing using pypi, if you install using git this can be skipped

5. `source deploy.sh`
6.  `deploy.sh "<your_commit_message>" <version>`

Make sure you have the latest versions of setuptools and wheel installed:

`python3 -m pip install --user --upgrade setuptools wheel`

You’ll need to install Twine:

`python3 -m pip install --user --upgrade twine`

Build dist/

`python3 setup.py sdist bdist_wheel`

Upload to pypi.org
`twine upload dist/*`

Source: https://packaging.python.org/tutorials/packaging-projects/


## Installing the Package PyPi

`pip install properly-util-python`

or

`pip install --no-cache-dir --upgrade properly-util-python`

## Installing the package direct from github: 


`pip install -e git+https://github.com/GoProperly/properly-util-python.git#egg=properly-util-python`

Note: -e indicates that extra-url-info is saved for pip freeze: https://pip.pypa.io/en/stable/reference/pip_wheel/#extra-index-url


## Resources

see:https://stackoverflow.com/questions/15268953/how-to-install-python-package-from-github#comment37317873_15268990

Based on this tutorial:
http://greenash.net.au/thoughts/2015/06/splitting-a-python-codebase-into-dependencies-for-fun-and-profit/

Currently we are hosting our package in Git since it is quick and easy to set up.
However, that has a number of disadvantages, the most visible disadvantage being that pip install will run much slower, because it has to do a git pull every time you ask it to check that foodutils is installed (even if you specify the same commit / tag each time).
http://carljm.github.io/tamingdeps/#33