/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.linqs.psl.application.groundrulestore.GroundRuleStore;
import org.linqs.psl.config.Config;
import org.linqs.psl.database.DataStore;
import org.linqs.psl.database.QueryResultIterable;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.database.rdbms.QueryRewriter;
import org.linqs.psl.database.rdbms.RDBMSDataStore;
import org.linqs.psl.model.Model;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.util.Parallel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Grounding {
    private static final Logger log = LoggerFactory.getLogger(Grounding.class);
    public static final String CONFIG_PREFIX = "grounding";
    public static final String REWRITE_QUERY_KEY = "grounding.rewritequeries";
    public static final boolean REWRITE_QUERY_DEFAULT = false;

    private Grounding() {
    }

    public static int groundAll(Model model, AtomManager atomManager, GroundRuleStore groundRuleStore) {
        return Grounding.groundAll(model.getRules(), atomManager, groundRuleStore);
    }

    public static int groundAllSerial(List<Rule> rules, AtomManager atomManager, GroundRuleStore groundRuleStore) {
        int groundCount = 0;
        for (Rule rule : rules) {
            groundCount += rule.groundAll(atomManager, groundRuleStore);
        }
        return groundCount;
    }

    public static int groundAll(List<Rule> rules, AtomManager atomManager, GroundRuleStore groundRuleStore) {
        boolean rewrite = Config.getBoolean(REWRITE_QUERY_KEY, false);
        HashMap queries = new HashMap();
        ArrayList<Rule> bypassRules = new ArrayList<Rule>();
        DataStore dataStore = atomManager.getDatabase().getDataStore();
        if (rewrite && !(dataStore instanceof RDBMSDataStore)) {
            log.warn("Cannot rewrite queries with a non-RDBMS DataStore. Queries will not be rewritten.");
            rewrite = false;
        }
        for (Rule rule : rules) {
            if (!rule.supportsIndividualGrounding()) {
                bypassRules.add(rule);
                continue;
            }
            Formula query = rule.getGroundingFormula();
            if (rewrite) {
                query = QueryRewriter.rewrite(query, (RDBMSDataStore)dataStore);
            }
            if (!queries.containsKey(query)) {
                queries.put(query, new ArrayList());
            }
            ((List)queries.get(query)).add(rule);
        }
        int initialSize = groundRuleStore.size();
        for (Map.Entry entry : queries.entrySet()) {
            Grounding.groundParallel((Formula)entry.getKey(), (List)entry.getValue(), atomManager, groundRuleStore);
        }
        Grounding.groundAllSerial(bypassRules, atomManager, groundRuleStore);
        return groundRuleStore.size() - initialSize;
    }

    private static int groundParallel(Formula query, List<Rule> rules, AtomManager atomManager, GroundRuleStore groundRuleStore) {
        log.debug("Grounding {} rules with query: [{}].", (Object)rules.size(), (Object)query);
        for (Rule rule : rules) {
            log.trace("    " + rule);
        }
        boolean oldAccessExceptionState = atomManager.enableAccessExceptions(false);
        int initialCount = groundRuleStore.size();
        QueryResultIterable queryResults = atomManager.executeGroundingQuery(query);
        Parallel.RunTimings timings = Parallel.foreach(queryResults, new GroundWorker(atomManager, groundRuleStore, queryResults.getVariableMap(), rules));
        int groundCount = groundRuleStore.size() - initialCount;
        atomManager.enableAccessExceptions(oldAccessExceptionState);
        log.trace("Got {} results from query [{}].", (Object)timings.iterations, (Object)query);
        log.debug("Generated {} ground rules with query: [{}].", (Object)groundCount, (Object)query);
        return groundCount;
    }

    private static class GroundWorker
    extends Parallel.Worker<Constant[]> {
        private AtomManager atomManager;
        private GroundRuleStore groundRuleStore;
        private Map<Variable, Integer> variableMap;
        private List<Rule> rules;

        public GroundWorker(AtomManager atomManager, GroundRuleStore groundRuleStore, Map<Variable, Integer> variableMap, List<Rule> rules) {
            this.atomManager = atomManager;
            this.groundRuleStore = groundRuleStore;
            this.variableMap = variableMap;
            this.rules = rules;
        }

        public Object clone() {
            return new GroundWorker(this.atomManager, this.groundRuleStore, this.variableMap, this.rules);
        }

        @Override
        public void work(int index, Constant[] row) {
            for (Rule rule : this.rules) {
                GroundRule groundRule = rule.ground(row, this.variableMap, this.atomManager);
                if (groundRule == null) continue;
                this.groundRuleStore.addGroundRule(groundRule);
            }
        }
    }
}

