/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.rdbms;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SelectivityHistogram<T extends Comparable<? super T>> {
    public static final double BUCKET_USAGE_GUESS = 0.5;
    private Class columnType = null;
    private boolean isEmpty;
    private List<T> histogramBounds;
    private List<BigInteger> histogramCounts;
    private Map<T, BigInteger> exactHistogram;
    private List<T> sortedExactHistogramKeys;

    public SelectivityHistogram() {
        this(false);
    }

    private SelectivityHistogram(boolean isEmpty) {
        this.isEmpty = isEmpty;
        this.histogramBounds = null;
        this.histogramCounts = null;
        this.exactHistogram = null;
        this.sortedExactHistogramKeys = null;
    }

    public void addHistogramBounds(List<T> bounds, List<? extends Number> counts) {
        if (bounds.size() == 0 || counts.size() == 0) {
            this.isEmpty = true;
            return;
        }
        assert (bounds.size() == counts.size() + 1);
        assert (bounds.size() >= 2);
        this.histogramBounds = new ArrayList<T>(bounds);
        this.histogramCounts = new ArrayList<BigInteger>(counts.size());
        for (Number number : counts) {
            if (number instanceof BigInteger) {
                this.histogramCounts.add((BigInteger)number);
                continue;
            }
            this.histogramCounts.add(BigInteger.valueOf(number.longValue()));
        }
        this.checkTypes(this.histogramBounds);
    }

    public void addHistogramExact(Map<T, ? extends Number> histogram) {
        if (histogram.size() == 0) {
            this.isEmpty = true;
            return;
        }
        assert (histogram.size() > 0);
        this.exactHistogram = new HashMap<T, BigInteger>();
        for (Map.Entry<T, Number> entry : histogram.entrySet()) {
            Comparable key = (Comparable)entry.getKey();
            Number count = entry.getValue();
            if (count instanceof BigInteger) {
                this.exactHistogram.put(key, (BigInteger)count);
                continue;
            }
            this.exactHistogram.put(key, BigInteger.valueOf(count.longValue()));
        }
        this.sortedExactHistogramKeys = new ArrayList<T>(histogram.keySet());
        Collections.sort(this.sortedExactHistogramKeys);
        this.checkTypes(this.sortedExactHistogramKeys);
    }

    private void checkTypes(Iterable<T> values) {
        for (Comparable value : values) {
            if (this.columnType == null) {
                this.columnType = value.getClass();
            }
            if (value.getClass() == this.columnType) continue;
            throw new IllegalArgumentException(String.format("Inconsistent types. Expected %s, found %s.", this.columnType.getName(), value.getClass().getName()));
        }
    }

    public long size() {
        if (!this.isValid() || this.isEmpty) {
            return 0L;
        }
        BigInteger count = BigInteger.ZERO;
        if (this.exactHistogram != null) {
            for (BigInteger bucketCount : this.exactHistogram.values()) {
                count = count.add(bucketCount);
            }
        } else {
            for (BigInteger bucketCount : this.histogramCounts) {
                count = count.add(bucketCount);
            }
        }
        return count.min(BigInteger.valueOf(Long.MAX_VALUE)).longValue();
    }

    public boolean isValid() {
        return this.isEmpty || this.columnType != null;
    }

    public SelectivityHistogram<T> join(SelectivityHistogram<T> other) {
        if (!this.isValid() || !other.isValid()) {
            throw new IllegalArgumentException("Connot compute join on invalid histograms.");
        }
        if (this.isEmpty || other.isEmpty) {
            return new SelectivityHistogram<T>(true);
        }
        if (this.columnType != other.columnType) {
            throw new IllegalArgumentException(String.format("Both histograms must match column type exactly. Got %s and %s.", this.columnType.getName(), other.columnType.getName()));
        }
        if (this.exactHistogram != null && other.exactHistogram != null) {
            return this.computeExactJoin(other);
        }
        if (this.exactHistogram != null) {
            return this.computeExactBucketJoin(other);
        }
        if (other.exactHistogram != null) {
            return super.computeExactBucketJoin(this);
        }
        return this.computeBucketJoin(other);
    }

    public String toString() {
        int i;
        if (this.isEmpty) {
            return "Empty Histogram";
        }
        if (!this.isValid()) {
            return "Invalid Histogram";
        }
        StringBuilder builder = new StringBuilder();
        if (this.exactHistogram != null) {
            for (i = 0; i < this.sortedExactHistogramKeys.size(); ++i) {
                Comparable exactValue = (Comparable)this.sortedExactHistogramKeys.get(i);
                if (i != 0) {
                    builder.append(", ");
                }
                builder.append(exactValue);
                builder.append(" (" + this.exactHistogram.get(exactValue) + ")");
            }
            if (this.histogramBounds != null) {
                builder.append("\n");
            }
        }
        if (this.histogramBounds != null) {
            for (i = 0; i < this.histogramCounts.size(); ++i) {
                if (i != 0) {
                    builder.append(", ");
                }
                Comparable bucketStart = (Comparable)this.histogramBounds.get(i + 0);
                Comparable bucketEnd = (Comparable)this.histogramBounds.get(i + 1);
                builder.append("[" + bucketStart + ", " + bucketEnd + "): " + this.histogramCounts.get(i));
            }
        }
        return builder.toString();
    }

    private SelectivityHistogram<T> computeExactJoin(SelectivityHistogram<T> other) {
        HashMap<Comparable, BigInteger> result = new HashMap<Comparable, BigInteger>();
        for (Map.Entry<T, BigInteger> entry : this.exactHistogram.entrySet()) {
            Comparable columnValue = (Comparable)entry.getKey();
            BigInteger count = entry.getValue();
            if (!other.exactHistogram.containsKey(columnValue)) continue;
            result.put(columnValue, count.multiply(other.exactHistogram.get(columnValue)));
        }
        SelectivityHistogram<Comparable> histogram = new SelectivityHistogram<Comparable>();
        histogram.addHistogramExact(result);
        return histogram;
    }

    private SelectivityHistogram<T> computeExactBucketJoin(SelectivityHistogram<T> other) {
        HashMap<Comparable, BigInteger> result = new HashMap<Comparable, BigInteger>();
        int currentExactIndex = 0;
        int bucketIndex = 0;
        while (currentExactIndex != this.sortedExactHistogramKeys.size()) {
            Comparable currentExactValue = (Comparable)this.sortedExactHistogramKeys.get(currentExactIndex);
            if (bucketIndex == other.histogramCounts.size() - 1) {
                ++currentExactIndex;
                BigInteger bucketCount = super.bucketOverlap(currentExactValue, currentExactValue, (Comparable)other.histogramBounds.get(bucketIndex + 0), (Comparable)other.histogramBounds.get(bucketIndex + 1), other.histogramCounts.get(bucketIndex));
                result.put(currentExactValue, bucketCount.multiply(this.exactHistogram.get(currentExactValue)));
                continue;
            }
            Comparable bucketStartValue = (Comparable)other.histogramBounds.get(bucketIndex + 0);
            Comparable bucketEndValue = (Comparable)other.histogramBounds.get(bucketIndex + 1);
            if (currentExactValue.compareTo(bucketEndValue) > 0) {
                ++bucketIndex;
                continue;
            }
            ++currentExactIndex;
            BigInteger bucketCount = super.bucketOverlap(currentExactValue, currentExactValue, bucketStartValue, bucketEndValue, other.histogramCounts.get(bucketIndex));
            result.put(currentExactValue, bucketCount.multiply(this.exactHistogram.get(currentExactValue)));
        }
        SelectivityHistogram<Comparable> histogram = new SelectivityHistogram<Comparable>();
        histogram.addHistogramExact(result);
        return histogram;
    }

    private SelectivityHistogram<T> computeBucketJoin(SelectivityHistogram<T> other) {
        ArrayList<Comparable> bounds = new ArrayList<Comparable>();
        ArrayList<BigInteger> counts = new ArrayList<BigInteger>();
        boolean emptyBucket = false;
        int contextBucketIndex = 0;
        int otherBucketIndex = 0;
        Comparable currentRangeStart = null;
        Comparable currentRangeEnd = null;
        while (contextBucketIndex != this.histogramCounts.size() && otherBucketIndex != other.histogramCounts.size()) {
            Comparable contextBucketStart = (Comparable)this.histogramBounds.get(contextBucketIndex + 0);
            Comparable contextBucketEnd = (Comparable)this.histogramBounds.get(contextBucketIndex + 1);
            BigInteger contextCount = this.histogramCounts.get(contextBucketIndex);
            Comparable otherBucketStart = (Comparable)other.histogramBounds.get(otherBucketIndex + 0);
            Comparable otherBucketEnd = (Comparable)other.histogramBounds.get(otherBucketIndex + 1);
            BigInteger otherCount = other.histogramCounts.get(otherBucketIndex);
            int startComparison = contextBucketStart.compareTo(otherBucketStart);
            currentRangeStart = startComparison < 0 ? otherBucketStart : contextBucketStart;
            int endComparison = contextBucketEnd.compareTo(otherBucketEnd);
            currentRangeEnd = endComparison < 0 ? contextBucketEnd : otherBucketEnd;
            if (endComparison <= 0) {
                ++contextBucketIndex;
            }
            if (endComparison >= 0) {
                ++otherBucketIndex;
            }
            if (currentRangeStart.compareTo(currentRangeEnd) > 0) {
                emptyBucket = true;
                continue;
            }
            BigInteger contextBucketCount = this.bucketOverlap(currentRangeStart, currentRangeEnd, contextBucketStart, contextBucketEnd, contextCount);
            BigInteger otherBucketCount = super.bucketOverlap(currentRangeStart, currentRangeEnd, otherBucketStart, otherBucketEnd, otherCount);
            if (bounds.size() == 0 || emptyBucket) {
                emptyBucket = false;
                bounds.add(currentRangeStart);
            }
            bounds.add(currentRangeEnd);
            counts.add(contextBucketCount.multiply(otherBucketCount));
        }
        SelectivityHistogram<Comparable> histogram = new SelectivityHistogram<Comparable>();
        histogram.addHistogramBounds(bounds, counts);
        return histogram;
    }

    private BigInteger bucketOverlap(T rangeStart, T rangeEnd, T bucketStart, T bucketEnd, BigInteger bucketCount) {
        BigDecimal floatBucketCount = new BigDecimal(bucketCount);
        if (rangeStart.compareTo(bucketStart) < 0 && rangeEnd.compareTo(bucketEnd) > 0) {
            return bucketCount;
        }
        if (this.columnType == Integer.class) {
            int bucketSize = (Integer)bucketEnd - (Integer)bucketStart + 1;
            int overlapStart = Math.max((Integer)rangeStart, (Integer)bucketStart);
            int overlapEnd = Math.min((Integer)rangeEnd, (Integer)bucketEnd);
            int overlapSize = overlapEnd - overlapStart;
            if (overlapSize == 0) {
                overlapSize = 1;
            }
            BigDecimal count = floatBucketCount.multiply(BigDecimal.valueOf((double)overlapSize / (double)bucketSize));
            return count.setScale(0, RoundingMode.CEILING).toBigInteger();
        }
        BigDecimal count = floatBucketCount.multiply(BigDecimal.valueOf(0.5));
        return count.setScale(0, RoundingMode.CEILING).toBigInteger();
    }
}

