/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.linqs.psl.model.rule.Rule;

public class Model {
    protected final List<Rule> rules = new LinkedList<Rule>();
    protected final Set<Rule> ruleSet = new HashSet<Rule>();

    public List<Rule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public void addRule(Rule rule) {
        if (this.ruleSet.contains(rule)) {
            throw new IllegalArgumentException("Rule already added to this model.");
        }
        this.rules.add(rule);
        this.ruleSet.add(rule);
    }

    public void removeRule(Rule rule) {
        if (!this.ruleSet.contains(rule)) {
            throw new IllegalArgumentException("Rule not in this model.");
        }
        this.rules.remove(rule);
        this.ruleSet.remove(rule);
    }

    public void clear() {
        this.rules.clear();
        this.ruleSet.clear();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Model:\n");
        s.append(this.asString());
        return s.toString();
    }

    public String asString() {
        StringBuilder s = new StringBuilder();
        if (this.rules.size() > 0) {
            s.append(this.rules.get(0));
        }
        for (int i = 1; i < this.rules.size(); ++i) {
            s.append("\n").append(this.rules.get(i));
        }
        return s.toString();
    }
}

