/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.arithmetic;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.rule.arithmetic.AbstractArithmeticRule;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.util.ListUtils;

public abstract class AbstractGroundArithmeticRule
implements GroundRule {
    protected final AbstractArithmeticRule rule;
    protected final float[] coefficients;
    protected final GroundAtom[] atoms;
    protected final FunctionComparator comparator;
    protected final float constant;

    protected AbstractGroundArithmeticRule(AbstractArithmeticRule rule, List<Float> coefficients, List<GroundAtom> atoms, FunctionComparator comparator, float constant) {
        this(rule, ListUtils.toPrimitiveFloatArray(coefficients), atoms.toArray(new GroundAtom[0]), comparator, constant, false);
    }

    protected AbstractGroundArithmeticRule(AbstractArithmeticRule rule, float[] coefficients, GroundAtom[] atoms, FunctionComparator comparator, float constant) {
        this(rule, coefficients, atoms, comparator, constant, true);
    }

    protected AbstractGroundArithmeticRule(AbstractArithmeticRule rule, float[] coefficients, GroundAtom[] atoms, FunctionComparator comparator, float constant, boolean copy) {
        this.rule = rule;
        this.comparator = comparator;
        this.constant = constant;
        if (copy) {
            this.coefficients = Arrays.copyOf(coefficients, coefficients.length);
            this.atoms = Arrays.copyOf(atoms, atoms.length);
        } else {
            this.coefficients = coefficients;
            this.atoms = atoms;
        }
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public Set<GroundAtom> getAtoms() {
        HashSet<GroundAtom> atomSet = new HashSet<GroundAtom>();
        for (GroundAtom atom : this.atoms) {
            atomSet.add(atom);
        }
        return atomSet;
    }

    @Override
    public List<GroundRule> negate() {
        throw new UnsupportedOperationException("Negating arithmetic rules not yet supported.");
    }

    @Override
    public String baseToString() {
        StringBuilder sb = new StringBuilder();
        if (this.coefficients.length > 0) {
            for (int i = 0; i < this.coefficients.length; ++i) {
                if (i != 0) {
                    sb.append(" + ");
                }
                sb.append(this.coefficients[i]);
                sb.append(" * ");
                sb.append(this.atoms[i]);
            }
        } else {
            sb.append("0.0");
        }
        sb.append(" ");
        switch (this.comparator) {
            case Equality: {
                sb.append("=");
                break;
            }
            case LargerThan: {
                sb.append(">=");
                break;
            }
            case SmallerThan: {
                sb.append("<=");
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized comparator: " + (Object)((Object)this.comparator));
            }
        }
        sb.append(" ");
        sb.append(this.constant);
        return sb.toString();
    }

    public String toString() {
        return this.baseToString();
    }

    public float[] getCoefficients() {
        return this.coefficients;
    }

    public GroundAtom[] getOrderedAtoms() {
        return this.atoms;
    }

    public FunctionComparator getComparator() {
        return this.comparator;
    }

    public float getConstant() {
        return this.constant;
    }
}

