/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.logical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.formula.Disjunction;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.formula.Negation;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.logical.AbstractLogicalRule;
import org.linqs.psl.reasoner.function.GeneralFunction;
import org.linqs.psl.util.HashCode;
import org.linqs.psl.util.IteratorUtils;

public abstract class AbstractGroundLogicalRule
implements GroundRule {
    protected final AbstractLogicalRule rule;
    protected final List<GroundAtom> posLiterals;
    protected final List<GroundAtom> negLiterals;
    protected final GeneralFunction function;
    private final int hashcode;

    protected AbstractGroundLogicalRule(AbstractLogicalRule rule, List<GroundAtom> posLiterals, List<GroundAtom> negLiterals, short rvaCount) {
        int i;
        this.rule = rule;
        this.posLiterals = Collections.unmodifiableList(new ArrayList<GroundAtom>(posLiterals));
        this.negLiterals = Collections.unmodifiableList(new ArrayList<GroundAtom>(negLiterals));
        int hash = HashCode.build(rule);
        boolean nonNegative = this.posLiterals.size() + this.negLiterals.size() > 1;
        this.function = new GeneralFunction(nonNegative, false, rvaCount);
        for (i = 0; i < this.posLiterals.size(); ++i) {
            this.function.add(1.0f, this.posLiterals.get(i));
            hash = HashCode.build(hash, this.posLiterals.get(i));
        }
        for (i = 0; i < this.negLiterals.size(); ++i) {
            this.function.add(-1.0f, this.negLiterals.get(i));
            hash = HashCode.build(hash, this.negLiterals.get(i));
        }
        this.function.add(1.0f - (float)this.posLiterals.size());
        this.hashcode = hash;
    }

    protected GeneralFunction getFunction() {
        return this.function;
    }

    @Override
    public Set<GroundAtom> getAtoms() {
        HashSet<GroundAtom> atoms = new HashSet<GroundAtom>();
        for (GroundAtom atom : this.posLiterals) {
            atoms.add(atom);
        }
        for (GroundAtom atom : this.negLiterals) {
            atoms.add(atom);
        }
        return atoms;
    }

    public List<GroundAtom> getPositiveAtoms() {
        return this.posLiterals;
    }

    public List<GroundAtom> getNegativeAtoms() {
        return this.negLiterals;
    }

    public int size() {
        return this.posLiterals.size() + this.negLiterals.size();
    }

    @Override
    public List<GroundRule> negate() {
        int numAtoms = this.size();
        ArrayList<GroundRule> negatedRules = new ArrayList<GroundRule>((int)Math.pow(2.0, numAtoms) - 1);
        ArrayList<GroundAtom> positiveAtoms = new ArrayList<GroundAtom>(numAtoms);
        ArrayList<GroundAtom> negativeAtoms = new ArrayList<GroundAtom>(numAtoms);
        Formula[] disjunction = new Formula[numAtoms];
        for (boolean[] subset : IteratorUtils.powerset(numAtoms)) {
            boolean skip = true;
            if (numAtoms == 1) {
                skip = !subset[0];
            } else {
                for (boolean negated : subset) {
                    if (negated) continue;
                    skip = false;
                    break;
                }
            }
            if (skip) continue;
            String name = String.format("%s -- Negated (%s)", this.rule.getName(), Arrays.toString(subset));
            positiveAtoms.clear();
            negativeAtoms.clear();
            int subsetIndex = 0;
            for (GroundAtom atom : this.posLiterals) {
                if (subset[subsetIndex]) {
                    negativeAtoms.add(atom);
                    disjunction[subsetIndex] = new Negation(atom);
                } else {
                    positiveAtoms.add(atom);
                    disjunction[subsetIndex] = atom;
                }
                ++subsetIndex;
            }
            for (GroundAtom atom : this.negLiterals) {
                if (subset[subsetIndex]) {
                    positiveAtoms.add(atom);
                    disjunction[subsetIndex] = atom;
                } else {
                    negativeAtoms.add(atom);
                    disjunction[subsetIndex] = new Negation(atom);
                }
                ++subsetIndex;
            }
            Formula formula = null;
            formula = disjunction.length > 1 ? new Disjunction(disjunction) : disjunction[0];
            negatedRules.add(this.instantiateNegatedGroundRule(formula, positiveAtoms, negativeAtoms, name));
        }
        return negatedRules;
    }

    protected abstract GroundRule instantiateNegatedGroundRule(Formula var1, List<GroundAtom> var2, List<GroundAtom> var3, String var4);

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof AbstractGroundLogicalRule) || this.hashCode() != other.hashCode()) {
            return false;
        }
        AbstractGroundLogicalRule otherRule = (AbstractGroundLogicalRule)other;
        if (!this.rule.equals(otherRule.getRule())) {
            return false;
        }
        return this.posLiterals.equals(otherRule.posLiterals) && this.negLiterals.equals(otherRule.negLiterals);
    }

    public int hashCode() {
        return this.hashcode;
    }

    @Override
    public String baseToString() {
        Formula[] literals = new Formula[this.posLiterals.size() + this.negLiterals.size()];
        for (int i = 0; i < this.posLiterals.size(); ++i) {
            literals[i] = new Negation(this.posLiterals.get(i));
        }
        for (int j = 0; j < this.negLiterals.size(); ++j) {
            literals[i++] = this.negLiterals.get(j);
        }
        return literals.length > 1 ? new Disjunction(literals).toString() : literals[0].toString();
    }

    public String toString() {
        return this.baseToString();
    }
}

