/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.logical;

import java.util.List;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.model.rule.WeightedRule;
import org.linqs.psl.model.rule.logical.AbstractGroundLogicalRule;
import org.linqs.psl.model.rule.logical.WeightedLogicalRule;
import org.linqs.psl.reasoner.function.GeneralFunction;
import org.linqs.psl.util.IteratorUtils;

public class WeightedGroundLogicalRule
extends AbstractGroundLogicalRule
implements WeightedGroundRule {
    protected WeightedGroundLogicalRule(WeightedLogicalRule rule, List<GroundAtom> posLiterals, List<GroundAtom> negLiterals, short rvaCount) {
        super(rule, posLiterals, negLiterals, rvaCount);
        this.function.setSquared(rule.isSquared());
    }

    @Override
    public WeightedRule getRule() {
        return (WeightedRule)((Object)this.rule);
    }

    @Override
    public boolean isSquared() {
        return ((WeightedRule)((Object)this.rule)).isSquared();
    }

    @Override
    public double getWeight() {
        return ((WeightedRule)((Object)this.rule)).getWeight();
    }

    @Override
    public void setWeight(double weight) {
        ((WeightedRule)((Object)this.rule)).setWeight(weight);
    }

    @Override
    public GeneralFunction getFunctionDefinition() {
        return this.function;
    }

    @Override
    public double getIncompatibility() {
        return this.function.getValue();
    }

    @Override
    public double getIncompatibility(GroundAtom replacementAtom, float replacementValue) {
        return this.function.getValue(replacementAtom, replacementValue);
    }

    @Override
    public String toString() {
        return "" + this.getWeight() + ": " + this.baseToString() + (this.isSquared() ? " ^2" : "");
    }

    @Override
    protected GroundRule instantiateNegatedGroundRule(Formula disjunction, List<GroundAtom> positiveAtoms, List<GroundAtom> negativeAtoms, String name) {
        short rvaCount = 0;
        for (GroundAtom atom : IteratorUtils.join(positiveAtoms, negativeAtoms)) {
            if (!(atom instanceof RandomVariableAtom)) continue;
            rvaCount = (short)(rvaCount + 1);
        }
        WeightedLogicalRule newRule = new WeightedLogicalRule(this.rule.getFormula(), -1.0 * ((WeightedLogicalRule)this.rule).getWeight(), this.isSquared(), name);
        return new WeightedGroundLogicalRule(newRule, positiveAtoms, negativeAtoms, rvaCount);
    }
}

