/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.logical;

import java.util.List;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.rule.WeightedRule;
import org.linqs.psl.model.rule.logical.AbstractLogicalRule;
import org.linqs.psl.model.rule.logical.WeightedGroundLogicalRule;
import org.linqs.psl.util.MathUtils;

public class WeightedLogicalRule
extends AbstractLogicalRule
implements WeightedRule {
    protected double weight;
    protected boolean squared;

    public WeightedLogicalRule(Formula formula, double weight, boolean squared) {
        this(formula, weight, squared, formula.toString());
    }

    public WeightedLogicalRule(Formula formula, double weight, boolean squared, String name) {
        super(formula, name);
        this.weight = weight;
        this.squared = squared;
    }

    @Override
    protected WeightedGroundLogicalRule groundFormulaInstance(List<GroundAtom> posLiterals, List<GroundAtom> negLiterals, short rvaCount) {
        return new WeightedGroundLogicalRule(this, posLiterals, negLiterals, rvaCount);
    }

    @Override
    public boolean isSquared() {
        return this.squared;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    public String toString() {
        String squaredSuffix = this.squared ? " ^2" : "";
        return "" + this.weight + ": " + this.formula + squaredSuffix;
    }

    @Override
    public boolean isWeighted() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        WeightedLogicalRule otherRule = (WeightedLogicalRule)other;
        if (this.squared != otherRule.squared || !MathUtils.equals(this.weight, otherRule.weight)) {
            return false;
        }
        return super.equals(other);
    }
}

