/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.misc;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.UnweightedGroundRule;
import org.linqs.psl.model.rule.UnweightedRule;
import org.linqs.psl.reasoner.function.ConstraintTerm;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.reasoner.function.GeneralFunction;

public class GroundValueConstraint
implements UnweightedGroundRule {
    private final RandomVariableAtom atom;
    private final float value;

    public GroundValueConstraint(RandomVariableAtom atom, float value) {
        this.atom = atom;
        this.value = value;
    }

    public RandomVariableAtom getAtom() {
        return this.atom;
    }

    @Override
    public Set<GroundAtom> getAtoms() {
        HashSet<GroundAtom> atoms = new HashSet<GroundAtom>();
        atoms.add(this.atom);
        return atoms;
    }

    @Override
    public UnweightedRule getRule() {
        return null;
    }

    @Override
    public ConstraintTerm getConstraintDefinition() {
        GeneralFunction sum = new GeneralFunction(false, false, 1);
        sum.add(1.0f, this.atom);
        return new ConstraintTerm(sum, FunctionComparator.Equality, this.value);
    }

    @Override
    public double getInfeasibility() {
        return Math.abs(this.atom.getValue() - this.value);
    }

    @Override
    public List<GroundRule> negate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String baseToString() {
        return this.getConstraintDefinition().toString();
    }
}

