/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.reasoner.admm.term.Hyperplane;
import org.linqs.psl.reasoner.admm.term.HyperplaneTerm;
import org.linqs.psl.reasoner.admm.term.LocalVariable;

public class HingeLossTerm
extends HyperplaneTerm {
    public HingeLossTerm(GroundRule groundRule, Hyperplane hyperplane) {
        super(groundRule, hyperplane);
    }

    @Override
    public void minimize(float stepSize, float[] consensusValues) {
        LocalVariable variable;
        int i;
        float weight = (float)((WeightedGroundRule)this.groundRule).getWeight();
        float total = 0.0f;
        for (i = 0; i < this.size; ++i) {
            variable = this.variables[i];
            variable.setValue(consensusValues[variable.getGlobalId()] - variable.getLagrange() / stepSize);
            total += this.coefficients[i] * variable.getValue();
        }
        if (total <= this.constant) {
            return;
        }
        total = 0.0f;
        for (i = 0; i < this.size; ++i) {
            variable = this.variables[i];
            variable.setValue(consensusValues[variable.getGlobalId()] - variable.getLagrange() / stepSize);
            variable.setValue(variable.getValue() - weight * this.coefficients[i] / stepSize);
            total += this.coefficients[i] * variable.getValue();
        }
        if (total >= this.constant) {
            return;
        }
        this.project(stepSize, consensusValues);
    }

    @Override
    public float evaluate() {
        float weight = (float)((WeightedGroundRule)this.groundRule).getWeight();
        return weight * Math.max(super.evaluate(), 0.0f);
    }
}

