/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import org.linqs.psl.reasoner.admm.term.LocalVariable;
import org.linqs.psl.util.ArrayUtils;

public class Hyperplane {
    private LocalVariable[] variables;
    private float[] coefficients;
    private int size;
    private float constant;

    public Hyperplane(int maxSize, float constant) {
        this(new LocalVariable[maxSize], new float[maxSize], constant, 0);
    }

    public Hyperplane(LocalVariable[] variables, float[] coefficients, float constant, int size) {
        this.variables = variables;
        this.coefficients = coefficients;
        this.constant = constant;
        this.size = size;
    }

    public void addTerm(LocalVariable variable, float coefficient) {
        this.variables[this.size] = variable;
        this.coefficients[this.size] = coefficient;
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    public LocalVariable getVariable(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Tried to access variable at index " + index + ", but only " + this.size + " exist.");
        }
        return this.variables[index];
    }

    public float getCoefficient(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Tried to access coefficient at index " + index + ", but only " + this.size + " exist.");
        }
        return this.coefficients[index];
    }

    public void appendCoefficient(int index, float value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Tried to access coefficient at index " + index + ", but only " + this.size + " exist.");
        }
        int n = index;
        this.coefficients[n] = this.coefficients[n] + value;
    }

    public float getConstant() {
        return this.constant;
    }

    public void setConstant(float constant) {
        this.constant = constant;
    }

    public int indexOfVariable(LocalVariable needle) {
        return ArrayUtils.indexOf(this.variables, this.size, needle);
    }

    public LocalVariable[] getVariables() {
        return this.variables;
    }

    public float[] getCoefficients() {
        return this.coefficients;
    }
}

