/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.reasoner.admm.term.ADMMObjectiveTerm;
import org.linqs.psl.reasoner.admm.term.Hyperplane;

public abstract class HyperplaneTerm
extends ADMMObjectiveTerm {
    protected final float[] coefficients;
    protected final float[] unitNormal;
    protected final float constant;
    protected final float[] point;

    public HyperplaneTerm(GroundRule groundRule, Hyperplane hyperplane) {
        super(hyperplane, groundRule);
        this.coefficients = hyperplane.getCoefficients();
        this.constant = hyperplane.getConstant();
        this.point = new float[this.size];
        if (this.size >= 3) {
            int i;
            float length = 0.0f;
            for (i = 0; i < this.size; ++i) {
                length += this.coefficients[i] * this.coefficients[i];
            }
            length = (float)Math.sqrt(length);
            this.unitNormal = new float[this.size];
            for (i = 0; i < this.size; ++i) {
                this.unitNormal[i] = this.coefficients[i] / length;
            }
        } else {
            this.unitNormal = null;
        }
    }

    protected void project(float stepSize, float[] consensusValues) {
        int i;
        if (this.size == 1) {
            this.variables[0].setValue(this.constant / this.coefficients[0]);
            return;
        }
        if (this.size == 2) {
            float coeff0 = this.coefficients[0];
            float coeff1 = this.coefficients[1];
            float x0 = stepSize * consensusValues[this.variables[0].getGlobalId()] - this.variables[0].getLagrange();
            x0 = (float)((double)x0 - (double)(stepSize * coeff0 / coeff1) * (-1.0 * (double)this.constant / (double)coeff1 + (double)consensusValues[this.variables[1].getGlobalId()] - (double)(this.variables[1].getLagrange() / stepSize)));
            x0 = (float)((double)x0 / ((double)stepSize * (1.0 + (double)(coeff0 * coeff0 / coeff1 / coeff1))));
            float x1 = (this.constant - coeff0 * x0) / coeff1;
            this.variables[0].setValue(x0);
            this.variables[1].setValue(x1);
            return;
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.point[i2] = consensusValues[this.variables[i2].getGlobalId()] - this.variables[i2].getLagrange() / stepSize;
        }
        float multiplier = -1.0f * this.constant / this.coefficients[0] * this.unitNormal[0];
        for (i = 0; i < this.size; ++i) {
            multiplier += this.point[i] * this.unitNormal[i];
        }
        for (i = 0; i < this.size; ++i) {
            this.variables[i].setValue(this.point[i] - multiplier * this.unitNormal[i]);
        }
    }

    @Override
    public float evaluate() {
        float value = 0.0f;
        for (int i = 0; i < this.size; ++i) {
            value += this.coefficients[i] * this.variables[i].getValue();
        }
        return value - this.constant;
    }
}

