/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.reasoner.admm.term.Hyperplane;
import org.linqs.psl.reasoner.admm.term.HyperplaneTerm;
import org.linqs.psl.reasoner.admm.term.LocalVariable;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.util.MathUtils;

public class LinearConstraintTerm
extends HyperplaneTerm {
    private final FunctionComparator comparator;

    protected LinearConstraintTerm(GroundRule groundRule, Hyperplane hyperplane, FunctionComparator comparator) {
        super(groundRule, hyperplane);
        this.comparator = comparator;
    }

    @Override
    public float evaluate() {
        if (this.comparator.equals((Object)FunctionComparator.Equality)) {
            if (MathUtils.isZero((double)super.evaluate(), 0.005)) {
                return 0.0f;
            }
            return Float.POSITIVE_INFINITY;
        }
        if (this.comparator.equals((Object)FunctionComparator.SmallerThan)) {
            if (super.evaluate() <= 0.0f) {
                return 0.0f;
            }
            return Float.POSITIVE_INFINITY;
        }
        if (this.comparator.equals((Object)FunctionComparator.LargerThan)) {
            if (super.evaluate() >= 0.0f) {
                return 0.0f;
            }
            return Float.POSITIVE_INFINITY;
        }
        throw new IllegalStateException("Unknown comparison function.");
    }

    @Override
    public void minimize(float stepSize, float[] consensusValues) {
        if (!this.comparator.equals((Object)FunctionComparator.Equality)) {
            float total = 0.0f;
            for (int i = 0; i < this.size; ++i) {
                LocalVariable variable = this.variables[i];
                variable.setValue(consensusValues[variable.getGlobalId()] - variable.getLagrange() / stepSize);
                total += this.coefficients[i] * variable.getValue();
            }
            if (this.comparator.equals((Object)FunctionComparator.SmallerThan) && total <= this.constant || this.comparator.equals((Object)FunctionComparator.LargerThan) && total >= this.constant) {
                return;
            }
        }
        this.project(stepSize, consensusValues);
    }
}

