/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

import java.util.Random;
import org.linqs.psl.config.Config;

public final class RandUtils {
    public static final String CONFIG_PREFIX = "random";
    public static final String SEED_KEY = "random.seed";
    public static final int SEED_DEFAULT = 4;
    private static Random rng = null;

    private RandUtils() {
    }

    private static synchronized void ensureRNG() {
        if (rng != null) {
            return;
        }
        rng = new Random(Config.getInt(SEED_KEY, 4));
    }

    public static synchronized void seed(int seed) {
        RandUtils.ensureRNG();
        rng.setSeed(seed);
    }

    public static synchronized boolean nextBoolean() {
        RandUtils.ensureRNG();
        return rng.nextBoolean();
    }

    public static synchronized double nextDouble() {
        RandUtils.ensureRNG();
        return rng.nextDouble();
    }

    public static synchronized float nextFloat() {
        RandUtils.ensureRNG();
        return rng.nextFloat();
    }

    public static synchronized double nextGaussian() {
        RandUtils.ensureRNG();
        return rng.nextGaussian();
    }

    public static synchronized int nextInt() {
        RandUtils.ensureRNG();
        return rng.nextInt();
    }

    public static synchronized int nextInt(int max) {
        RandUtils.ensureRNG();
        return rng.nextInt(max);
    }

    public static synchronized long nextLong() {
        RandUtils.ensureRNG();
        return rng.nextLong();
    }
}

