/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.inference;

import org.linqs.psl.application.inference.InferenceApplication;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.atom.PersistedAtomManager;
import org.linqs.psl.model.Model;
import org.linqs.psl.reasoner.dcd.DCDReasoner;
import org.linqs.psl.reasoner.dcd.term.DCDStreamingTermStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCDStreamingInference
extends InferenceApplication {
    private static final Logger log = LoggerFactory.getLogger(DCDStreamingInference.class);

    public DCDStreamingInference(Model model, Database db) {
        super(model, db);
    }

    @Override
    protected void initialize() {
        this.reasoner = new DCDReasoner();
        log.debug("Creating persisted atom mannager.");
        this.atomManager = new PersistedAtomManager(this.db);
        log.trace("Atom manager initialization complete.");
        this.termStore = new DCDStreamingTermStore(this.model.getRules(), this.atomManager);
        this.termStore.ensureVariableCapacity(this.atomManager.getCachedRVACount());
    }

    @Override
    protected void completeInitialize() {
    }

    @Override
    public void inference() {
        log.info("Beginning inference.");
        this.reasoner.optimize(this.termStore);
        log.info("Inference complete. Writing results to Database.");
        ((PersistedAtomManager)this.atomManager).commitPersistedAtoms();
        log.info("Results committed to database.");
    }

    @Override
    public void close() {
        this.termStore.close();
        this.reasoner.close();
        this.termStore = null;
        this.reasoner = null;
        this.model = null;
        this.db = null;
    }
}

