/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.inference;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.linqs.psl.application.ModelApplication;
import org.linqs.psl.config.Config;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.grounding.GroundRuleStore;
import org.linqs.psl.grounding.MemoryGroundRuleStore;
import org.linqs.psl.model.Model;
import org.linqs.psl.reasoner.Reasoner;
import org.linqs.psl.reasoner.admm.ADMMReasoner;
import org.linqs.psl.reasoner.admm.term.ADMMTermGenerator;
import org.linqs.psl.reasoner.admm.term.ADMMTermStore;
import org.linqs.psl.reasoner.term.TermGenerator;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.util.Reflection;

public abstract class InferenceApplication
implements ModelApplication {
    public static final String CONFIG_PREFIX = "inference";
    public static final String REASONER_KEY = "inference.reasoner";
    public static final String REASONER_DEFAULT = ADMMReasoner.class.getName();
    public static final String GROUND_RULE_STORE_KEY = "inference.groundrulestore";
    public static final String GROUND_RULE_STORE_DEFAULT = MemoryGroundRuleStore.class.getName();
    public static final String TERM_STORE_KEY = "inference.termstore";
    public static final String TERM_STORE_DEFAULT = ADMMTermStore.class.getName();
    public static final String TERM_GENERATOR_KEY = "inference.termgenerator";
    public static final String TERM_GENERATOR_DEFAULT = ADMMTermGenerator.class.getName();
    protected Model model;
    protected Database db;
    protected Reasoner reasoner;
    protected GroundRuleStore groundRuleStore;
    protected TermStore termStore;
    protected TermGenerator termGenerator;
    protected AtomManager atomManager;

    public InferenceApplication(Model model, Database db) {
        this.model = model;
        this.db = db;
        this.initialize();
    }

    protected void initialize() {
        try {
            this.reasoner = (Reasoner)Config.getNewObject(REASONER_KEY, REASONER_DEFAULT);
            this.termStore = (TermStore)Config.getNewObject(TERM_STORE_KEY, TERM_STORE_DEFAULT);
            this.groundRuleStore = (GroundRuleStore)Config.getNewObject(GROUND_RULE_STORE_KEY, GROUND_RULE_STORE_DEFAULT);
            this.termGenerator = (TermGenerator)Config.getNewObject(TERM_GENERATOR_KEY, TERM_GENERATOR_DEFAULT);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to prepare storage for inference.", ex);
        }
        this.completeInitialize();
    }

    protected abstract void completeInitialize();

    public abstract void inference();

    public Reasoner getReasoner() {
        return this.reasoner;
    }

    public GroundRuleStore getGroundRuleStore() {
        return this.groundRuleStore;
    }

    public TermStore getTermStore() {
        return this.termStore;
    }

    public AtomManager getAtomManager() {
        return this.atomManager;
    }

    @Override
    public void close() {
        this.termStore.close();
        this.groundRuleStore.close();
        this.reasoner.close();
        this.termStore = null;
        this.groundRuleStore = null;
        this.reasoner = null;
        this.model = null;
        this.db = null;
    }

    public static InferenceApplication getInferenceApplication(String className, Model model, Database db) {
        className = Reflection.resolveClassName(className);
        Class<?> classObject = null;
        try {
            Class<?> uncheckedClassObject;
            classObject = uncheckedClassObject = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Could not find class: " + className, ex);
        }
        Constructor<?> constructor = null;
        try {
            constructor = classObject.getConstructor(Model.class, Database.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("No sutible constructor found for inference application: " + className + ".", ex);
        }
        InferenceApplication inferenceApplication = null;
        try {
            inferenceApplication = (InferenceApplication)constructor.newInstance(model, db);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Unable to instantiate inference application (" + className + ")", ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Insufficient access to constructor for " + className, ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Error thrown while constructing " + className, ex);
        }
        return inferenceApplication;
    }
}

