/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.inference;

import org.linqs.psl.application.inference.InferenceApplication;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.atom.PersistedAtomManager;
import org.linqs.psl.grounding.Grounding;
import org.linqs.psl.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPEInference
extends InferenceApplication {
    private static final Logger log = LoggerFactory.getLogger(MPEInference.class);

    public MPEInference(Model model, Database db) {
        super(model, db);
    }

    @Override
    protected void completeInitialize() {
        log.debug("Creating persisted atom mannager.");
        this.atomManager = new PersistedAtomManager(this.db);
        log.trace("Atom manager initialization complete.");
        log.info("Grounding out model.");
        int groundCount = Grounding.groundAll(this.model, this.atomManager, this.groundRuleStore);
        log.info("Grounding complete.");
        this.termStore.ensureVariableCapacity(this.atomManager.getCachedRVACount());
        log.debug("Initializing objective terms for {} ground rules.", (Object)groundCount);
        int termCount = this.termGenerator.generateTerms(this.groundRuleStore, this.termStore);
        log.debug("Generated {} objective terms from {} ground rules.", (Object)termCount, (Object)groundCount);
    }

    @Override
    public void inference() {
        log.info("Beginning inference.");
        this.reasoner.optimize(this.termStore);
        log.info("Inference complete. Writing results to Database.");
        ((PersistedAtomManager)this.atomManager).commitPersistedAtoms();
        log.info("Results committed to database.");
    }
}

