/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.learning.weight.em;

import java.util.List;
import org.linqs.psl.application.learning.weight.em.ExpectationMaximization;
import org.linqs.psl.config.Config;
import org.linqs.psl.database.Database;
import org.linqs.psl.model.Model;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.rule.WeightedRule;

public class HardEM
extends ExpectationMaximization {
    public static final String CONFIG_PREFIX = "hardem";
    public static final String ADAGRAD_KEY = "hardem.adagrad";
    public static final boolean ADAGRAD_DEFAULT = false;
    public static final double MIN_SCALING_FACTOR = 1.0E-8;
    private final boolean useAdaGrad = Config.getBoolean("hardem.adagrad", false);

    public HardEM(Model model, Database rvDB, Database observedDB) {
        this(model.getRules(), rvDB, observedDB);
    }

    public HardEM(List<Rule> rules, Database rvDB, Database observedDB) {
        super(rules, rvDB, observedDB);
    }

    @Override
    protected double[] computeScalingFactor() {
        if (!this.useAdaGrad) {
            return super.computeScalingFactor();
        }
        double[] scalingFactor = new double[this.mutableRules.size()];
        for (int i = 0; i < this.mutableRules.size(); ++i) {
            double weight = ((WeightedRule)this.mutableRules.get(i)).getWeight();
            double gradient = this.expectedIncompatibility[i] - this.observedIncompatibility[i] - this.l2Regularization * weight - this.l1Regularization;
            scalingFactor[i] = Math.max(1.0E-8, Math.abs(gradient));
        }
        return scalingFactor;
    }
}

