/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.dcd.term;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.WeightedRule;
import org.linqs.psl.reasoner.dcd.term.DCDObjectiveTerm;
import org.linqs.psl.reasoner.dcd.term.DCDStreamingTermStore;
import org.linqs.psl.reasoner.term.HyperplaneTermGenerator;
import org.linqs.psl.reasoner.term.streaming.StreamingInitialRoundIterator;
import org.linqs.psl.util.RuntimeStats;

public class DCDStreamingInitialRoundIterator
extends StreamingInitialRoundIterator<DCDObjectiveTerm> {
    public DCDStreamingInitialRoundIterator(DCDStreamingTermStore parentStore, List<WeightedRule> rules, AtomManager atomManager, HyperplaneTermGenerator<DCDObjectiveTerm, RandomVariableAtom> termGenerator, List<DCDObjectiveTerm> termCache, List<DCDObjectiveTerm> termPool, ByteBuffer termBuffer, ByteBuffer volatileBuffer, int pageSize) {
        super(parentStore, rules, atomManager, termGenerator, termCache, termPool, termBuffer, volatileBuffer, pageSize);
    }

    @Override
    protected void writeFullPage(String termPagePath, String volatilePagePath) {
        this.flushTermCache(termPagePath);
        this.flushVolatileCache(volatilePagePath);
        this.termCache.clear();
    }

    private void flushTermCache(String termPagePath) {
        int termsSize = 0;
        for (DCDObjectiveTerm term : this.termCache) {
            termsSize += term.fixedByteSize();
        }
        int termBufferSize = termsSize + 8;
        if (this.termBuffer == null || this.termBuffer.capacity() < termBufferSize) {
            this.termBuffer = ByteBuffer.allocate((int)((double)termBufferSize * 1.25));
        }
        this.termBuffer.clear();
        this.termBuffer.putInt(termsSize);
        this.termBuffer.putInt(this.termCache.size());
        for (DCDObjectiveTerm term : this.termCache) {
            term.writeFixedValues(this.termBuffer);
        }
        try (FileOutputStream stream = new FileOutputStream(termPagePath);){
            stream.write(this.termBuffer.array(), 0, termBufferSize);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to write term cache page: " + termPagePath, ex);
        }
        RuntimeStats.logDiskWrite(termBufferSize);
    }

    private void flushVolatileCache(String volatilePagePath) {
        int volatileBufferSize = 4 * this.termCache.size();
        if (this.volatileBuffer == null || this.volatileBuffer.capacity() < volatileBufferSize) {
            this.volatileBuffer = ByteBuffer.allocate((int)((double)volatileBufferSize * 1.25));
        }
        this.volatileBuffer.clear();
        for (DCDObjectiveTerm term : this.termCache) {
            this.volatileBuffer.putFloat(term.getLagrange());
        }
        try (FileOutputStream stream = new FileOutputStream(volatilePagePath);){
            stream.write(this.volatileBuffer.array(), 0, volatileBufferSize);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to write volatile cache page: " + volatilePagePath, ex);
        }
        RuntimeStats.logDiskWrite(volatileBufferSize);
    }
}

