/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.Expression;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import java.io.IOException;

public class ComboExpression
extends Expression {
    private SqlObjectList<Expression> _expressions;

    public ComboExpression(Op comboOp) {
        this(comboOp, (Object[])null);
    }

    public ComboExpression(Op comboOp, Object ... expressions) {
        this((Object)comboOp, expressions);
    }

    public ComboExpression(Object comboOpStr, Object ... expressions) {
        this._expressions = SqlObjectList.create(comboOpStr.toString());
        this._expressions.addObjects(Converter.CUSTOM_TO_EXPRESSION, expressions);
    }

    protected void collectSchemaObjects(ValidationContext vContext) {
        this._expressions.collectSchemaObjects(vContext);
    }

    public boolean isEmpty() {
        return ComboExpression.areEmpty(this._expressions);
    }

    public boolean hasParens() {
        return ComboExpression.hasParens(this._expressions);
    }

    public ComboExpression addExpression(Object expr) {
        return this.addExpressions(expr);
    }

    public ComboExpression addExpressions(Object ... exprs) {
        this._expressions.addObjects(Converter.CUSTOM_TO_EXPRESSION, exprs);
        return this;
    }

    public void appendTo(AppendableExt app) throws IOException {
        this.appendNestedClauses(app, this._expressions);
    }

    public static ComboExpression add() {
        return new ComboExpression(Op.ADD);
    }

    public static ComboExpression add(Object ... expressions) {
        return new ComboExpression(Op.ADD, expressions);
    }

    public static ComboExpression subtract() {
        return new ComboExpression(Op.SUBTRACT);
    }

    public static ComboExpression subtract(Object ... expressions) {
        return new ComboExpression(Op.SUBTRACT, expressions);
    }

    public static ComboExpression multiply() {
        return new ComboExpression(Op.MULTIPLY);
    }

    public static ComboExpression multiply(Object ... expressions) {
        return new ComboExpression(Op.MULTIPLY, expressions);
    }

    public static ComboExpression divide() {
        return new ComboExpression(Op.DIVIDE);
    }

    public static ComboExpression divide(Object ... expressions) {
        return new ComboExpression(Op.DIVIDE, expressions);
    }

    public static ComboExpression concatenate() {
        return new ComboExpression(Op.CONCATENATE);
    }

    public static ComboExpression concatenate(Object ... expressions) {
        return new ComboExpression(Op.CONCATENATE, expressions);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Op {
        ADD(" + "),
        SUBTRACT(" - "),
        MULTIPLY(" * "),
        DIVIDE(" / "),
        CONCATENATE(" || ");

        private final String _opStr;

        private Op(String opStr) {
            this._opStr = opStr;
        }

        public String toString() {
            return this._opStr;
        }
    }
}

