/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.BaseCreateQuery;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.DropQuery;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.custom.CustomSyntax;
import com.healthmarketscience.sqlbuilder.custom.HookAnchor;
import com.healthmarketscience.sqlbuilder.custom.HookType;
import com.healthmarketscience.sqlbuilder.custom.oracle.OraTableSpaceClause;
import com.healthmarketscience.sqlbuilder.dbspec.Index;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateIndexQuery
extends BaseCreateQuery<CreateIndexQuery> {
    private IndexType _indexType;
    protected SqlObject _table;

    public CreateIndexQuery(Index index) {
        this((Object)index.getTable(), (Object)index);
        this._columns.addObjects(Converter.COLUMN_TO_OBJ, index.getColumns());
    }

    public CreateIndexQuery(Table table, String indexName) {
        this((Object)table, (Object)indexName);
    }

    public CreateIndexQuery(Table table, Object index) {
        this((Object)table, index);
    }

    public CreateIndexQuery(Object tableStr, Object index) {
        super(Converter.toCustomIndexSqlObject(index));
        this._table = Converter.toCustomTableSqlObject(tableStr);
    }

    public CreateIndexQuery setIndexType(IndexType indexType) {
        this._indexType = indexType;
        return this;
    }

    public CreateIndexQuery setTableName(String nameName) {
        return this.setCustomTableName(nameName);
    }

    public CreateIndexQuery setCustomTableName(Object name) {
        this._table = Converter.toCustomTableSqlObject(name);
        return this;
    }

    @Override
    public DropQuery getDropQuery() {
        return new DropQuery(DropQuery.Type.INDEX, this._object);
    }

    @Override
    public CreateIndexQuery addCustomColumns(Object ... columnStrs) {
        this._columns.addObjects(Converter.CUSTOM_COLUMN_TO_OBJ, columnStrs);
        return this;
    }

    @Deprecated
    public CreateIndexQuery setTableSpace(String tableSpace) {
        return this.addCustomization(new OraTableSpaceClause(tableSpace));
    }

    public CreateIndexQuery addCustomization(Hook hook, HookType type, Object obj) {
        super.addCustomization(hook, type, obj);
        return this;
    }

    public CreateIndexQuery addCustomization(CustomSyntax obj) {
        if (obj != null) {
            obj.apply(this);
        }
        return this;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        this._table.collectSchemaObjects(vContext);
    }

    @Override
    protected void appendTo(AppendableExt app, SqlContext newContext) throws IOException {
        newContext.setUseTableAliases(false);
        this.customAppendTo(app, Hook.HEADER);
        app.append("CREATE ");
        if (this._indexType != null) {
            app.append((Object)this._indexType);
        }
        this.customAppendTo(app, Hook.INDEX, "INDEX ").append(this._object).append(" ON ").append(this._table).append(" (").append(this._columns).append(")");
        this.customAppendTo(app, Hook.TRAILER);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IndexType {
        UNIQUE("UNIQUE ");

        private final String _typeClause;

        private IndexType(String typeClause) {
            this._typeClause = typeClause;
        }

        public String toString() {
            return this._typeClause;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Hook implements HookAnchor
    {
        HEADER,
        INDEX,
        TRAILER;

    }
}

