/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.inference;

import org.linqs.psl.application.inference.InferenceApplication;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.grounding.Grounding;
import org.linqs.psl.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPEInference
extends InferenceApplication {
    private static final Logger log = LoggerFactory.getLogger(MPEInference.class);

    public MPEInference(Model model, Database db) {
        super(model, db);
    }

    @Override
    protected void completeInitialize() {
        log.info("Grounding out model.");
        int groundCount = Grounding.groundAll(this.model, (AtomManager)this.atomManager, this.groundRuleStore);
        log.info("Grounding complete.");
        log.debug("Initializing objective terms for {} ground rules.", (Object)groundCount);
        int termCount = this.termGenerator.generateTerms(this.groundRuleStore, this.termStore);
        log.debug("Generated {} objective terms from {} ground rules.", (Object)termCount, (Object)groundCount);
    }
}

