/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.learning.weight.em;

import java.util.List;
import org.linqs.psl.application.learning.weight.VotedPerceptron;
import org.linqs.psl.config.Config;
import org.linqs.psl.database.Database;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.rule.WeightedRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExpectationMaximization
extends VotedPerceptron {
    private static final Logger log = LoggerFactory.getLogger(ExpectationMaximization.class);
    public static final String CONFIG_PREFIX = "em";
    public static final String ITER_KEY = "em.iterations";
    public static final int ITER_DEFAULT = 10;
    public static final String TOLERANCE_KEY = "em.tolerance";
    public static final double TOLERANCE_DEFAULT = 0.001;
    protected final int iterations = Config.getInt("em.iterations", 10);
    protected final double tolerance = Config.getDouble("em.tolerance", 0.001);
    protected int emIteration;

    public ExpectationMaximization(List<Rule> rules, Database rvDB, Database observedDB) {
        super(rules, rvDB, observedDB, true);
    }

    @Override
    protected void doLearn() {
        double[] previousWeights = new double[this.mutableRules.size()];
        for (int i = 0; i < previousWeights.length; ++i) {
            previousWeights[i] = ((WeightedRule)this.mutableRules.get(i)).getWeight();
        }
        this.emIteration = 0;
        while (this.emIteration < this.iterations) {
            log.debug("Beginning EM iteration {} of {}", (Object)this.emIteration, (Object)this.iterations);
            this.eStep();
            this.mStep();
            double change = 0.0;
            for (int i = 0; i < this.mutableRules.size(); ++i) {
                change += Math.pow(previousWeights[i] - ((WeightedRule)this.mutableRules.get(i)).getWeight(), 2.0);
                previousWeights[i] = ((WeightedRule)this.mutableRules.get(i)).getWeight();
            }
            change = Math.sqrt(change);
            double loss = this.getLoss();
            double regularizer = this.computeRegularizer();
            double objective = loss + regularizer;
            log.info("Finished EM iteration {} with m-step norm {}. Loss: {}, regularizer: {}, objective: {}", this.emIteration, change, loss, regularizer, objective);
            if (change <= this.tolerance) {
                log.info("EM converged.");
                break;
            }
            ++this.emIteration;
        }
    }

    protected void eStep() {
        this.computeLatentMPEState();
    }

    protected void mStep() {
        super.doLearn();
    }
}

