/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.grounding;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.grounding.MemoryGroundRuleStore;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;

public class AtomRegisterGroundRuleStore
extends MemoryGroundRuleStore {
    private Map<GroundAtom, Set<GroundRule>> atomMapping = new HashMap<GroundAtom, Set<GroundRule>>();

    public Set<GroundRule> getRegisteredGroundRules(GroundAtom atom) {
        if (!this.atomMapping.containsKey(atom)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.atomMapping.get(atom));
    }

    @Override
    public synchronized void addGroundRule(GroundRule groundRule) {
        super.addGroundRule(groundRule);
        for (GroundAtom atom : groundRule.getAtoms()) {
            if (!this.atomMapping.containsKey(atom)) {
                this.atomMapping.put(atom, new HashSet());
            }
            this.atomMapping.get(atom).add(groundRule);
        }
    }

    @Override
    public void removeGroundRule(GroundRule groundRule) {
        super.removeGroundRule(groundRule);
        for (GroundAtom atom : groundRule.getAtoms()) {
            if (!this.atomMapping.containsKey(atom)) continue;
            this.atomMapping.get(atom).remove(groundRule);
        }
    }

    @Override
    public void removeGroundRules(Rule rule) {
        for (GroundRule groundRule : this.getGroundRules(rule)) {
            for (GroundAtom atom : groundRule.getAtoms()) {
                if (!this.atomMapping.containsKey(atom)) continue;
                this.atomMapping.get(atom).remove(groundRule);
            }
        }
        super.removeGroundRules(rule);
    }

    @Override
    public void close() {
        super.close();
        if (this.atomMapping != null) {
            this.atomMapping.clear();
            this.atomMapping = null;
        }
    }
}

