/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.misc;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.UnweightedGroundRule;
import org.linqs.psl.model.rule.UnweightedRule;
import org.linqs.psl.reasoner.function.ConstraintTerm;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.reasoner.function.GeneralFunction;

public class GroundLinearConstraint
implements UnweightedGroundRule {
    private final GroundAtom[] atoms;
    private final float[] coeffs;
    private final FunctionComparator comp;
    private final float value;

    public GroundLinearConstraint(GroundAtom[] atoms, float[] coeffs, FunctionComparator comp, float value) {
        if (atoms.length != coeffs.length) {
            throw new IllegalArgumentException("Same number of atoms and coefficients must be provided.");
        }
        this.atoms = Arrays.copyOf(atoms, atoms.length);
        this.coeffs = Arrays.copyOf(coeffs, coeffs.length);
        this.comp = comp;
        this.value = value;
    }

    @Override
    public Set<GroundAtom> getAtoms() {
        HashSet<GroundAtom> atoms = new HashSet<GroundAtom>();
        atoms.addAll(atoms);
        return atoms;
    }

    @Override
    public UnweightedRule getRule() {
        return null;
    }

    @Override
    public ConstraintTerm getConstraintDefinition() {
        GeneralFunction sum = new GeneralFunction(false, false, this.atoms.length);
        for (int i = 0; i < this.atoms.length; ++i) {
            sum.add(this.coeffs[i], this.atoms[i]);
        }
        return new ConstraintTerm(sum, this.comp, this.value);
    }

    @Override
    public double getInfeasibility() {
        ConstraintTerm constraint = this.getConstraintDefinition();
        double functionValue = constraint.getFunction().getValue();
        double conValue = constraint.getValue();
        if (constraint.getComparator().equals((Object)FunctionComparator.LTE) && functionValue < (double)this.value || constraint.getComparator().equals((Object)FunctionComparator.GTE) && functionValue > (double)this.value) {
            return 0.0;
        }
        return Math.abs(functionValue - conValue);
    }

    @Override
    public List<GroundRule> negate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String baseToString() {
        return this.getConstraintDefinition().toString();
    }
}

