/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.term;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.model.term.Variable;

public class VariableTypeMap
extends HashMap<Variable, ConstantType> {
    private static final long serialVersionUID = -6590175777602710989L;

    public void addVariable(Variable var, ConstantType type) {
        this.addVariable(var, type, false);
    }

    public void addVariable(Variable var, ConstantType type, boolean force) {
        ConstantType oldType = (ConstantType)((Object)this.get(var));
        if (oldType == null) {
            this.put(var, type);
            return;
        }
        if (oldType == type) {
            return;
        }
        if (force) {
            this.put(var, type);
            return;
        }
        if (oldType == ConstantType.DeferredFunctionalUniqueID) {
            if (type != ConstantType.UniqueIntID && type != ConstantType.UniqueStringID) {
                throw new IllegalStateException("Variable, " + var + ", is DeferredFunctionalUniqueID and connot be replaced by " + (Object)((Object)type));
            }
            this.put(var, type);
            return;
        }
        if (type == ConstantType.DeferredFunctionalUniqueID) {
            if (oldType != ConstantType.UniqueIntID && oldType != ConstantType.UniqueStringID) {
                throw new IllegalStateException("Variable, " + var + ", is " + (Object)((Object)oldType) + " and cannot also be a DeferredFunctionalUniqueID");
            }
            return;
        }
        throw new IllegalStateException("Variable, " + var + ", has inconsistent type. First: " + (Object)((Object)oldType) + ", Now: " + (Object)((Object)type));
    }

    public Set<Variable> getVariables() {
        return this.keySet();
    }

    public ConstantType getType(Variable var) {
        ConstantType type = (ConstantType)((Object)this.get(var));
        if (type == null) {
            throw new IllegalArgumentException("Specified variable is unknown: " + var);
        }
        return type;
    }

    public boolean hasVariable(Variable var) {
        return this.containsKey(var);
    }

    public void addAll(VariableTypeMap other) {
        for (Map.Entry entry : other.entrySet()) {
            this.addVariable((Variable)entry.getKey(), (ConstantType)((Object)entry.getValue()));
        }
    }
}

