/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.reasoner.admm.term.ADMMObjectiveTerm;
import org.linqs.psl.reasoner.admm.term.HingeLossTerm;
import org.linqs.psl.reasoner.admm.term.LinearConstraintTerm;
import org.linqs.psl.reasoner.admm.term.LinearLossTerm;
import org.linqs.psl.reasoner.admm.term.LocalVariable;
import org.linqs.psl.reasoner.admm.term.SquaredHingeLossTerm;
import org.linqs.psl.reasoner.admm.term.SquaredLinearLossTerm;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.HyperplaneTermGenerator;
import org.linqs.psl.reasoner.term.TermStore;

public class ADMMTermGenerator
extends HyperplaneTermGenerator<ADMMObjectiveTerm, LocalVariable> {
    @Override
    public Class<LocalVariable> getLocalVariableType() {
        return LocalVariable.class;
    }

    @Override
    public ADMMObjectiveTerm createLossTerm(TermStore<ADMMObjectiveTerm, LocalVariable> termStore, boolean isHinge, boolean isSquared, GroundRule groundRule, Hyperplane<LocalVariable> hyperplane) {
        if (isHinge && isSquared) {
            return new SquaredHingeLossTerm(groundRule, hyperplane);
        }
        if (isHinge && !isSquared) {
            return new HingeLossTerm(groundRule, hyperplane);
        }
        if (!isHinge && isSquared) {
            hyperplane.setConstant(0.0f);
            return new SquaredLinearLossTerm(groundRule, hyperplane);
        }
        return new LinearLossTerm(groundRule, hyperplane);
    }

    @Override
    public ADMMObjectiveTerm createLinearConstraintTerm(TermStore<ADMMObjectiveTerm, LocalVariable> termStore, GroundRule groundRule, Hyperplane<LocalVariable> hyperplane, FunctionComparator comparator) {
        return new LinearConstraintTerm(groundRule, hyperplane, comparator);
    }
}

