/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.reasoner.admm.term.LocalVariable;
import org.linqs.psl.reasoner.admm.term.SquaredHyperplaneTerm;
import org.linqs.psl.reasoner.term.Hyperplane;

public class SquaredHingeLossTerm
extends SquaredHyperplaneTerm {
    public SquaredHingeLossTerm(GroundRule groundRule, Hyperplane<LocalVariable> hyperplane) {
        super(groundRule, hyperplane);
    }

    @Override
    public float evaluate() {
        float weight = (float)((WeightedGroundRule)this.groundRule).getWeight();
        return weight * (float)Math.pow(Math.max(0.0f, super.evaluate()), 2.0);
    }

    @Override
    public float evaluate(float[] consensusValues) {
        float weight = (float)((WeightedGroundRule)this.groundRule).getWeight();
        return weight * (float)Math.pow(Math.max(0.0f, super.evaluate(consensusValues)), 2.0);
    }

    @Override
    public void minimize(float stepSize, float[] consensusValues) {
        float total = 0.0f;
        for (int i = 0; i < this.size; ++i) {
            LocalVariable variable = this.variables[i];
            variable.setValue(consensusValues[variable.getGlobalId()] - variable.getLagrange() / stepSize);
            total += this.coefficients[i] * variable.getValue();
        }
        if (total <= this.constant) {
            return;
        }
        this.minWeightedSquaredHyperplane(stepSize, consensusValues);
    }
}

