/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.dcd.term;

import java.nio.ByteBuffer;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.VariableTermStore;
import org.linqs.psl.util.MathUtils;

public class DCDObjectiveTerm
implements ReasonerTerm {
    private boolean squared;
    private float adjustedWeight;
    private float constant;
    private float lagrange;
    private float qii;
    private short size;
    private float[] coefficients;
    private int[] variableIndexes;

    public DCDObjectiveTerm(VariableTermStore<DCDObjectiveTerm, RandomVariableAtom> termStore, boolean squared, Hyperplane<RandomVariableAtom> hyperplane, float weight, float c) {
        this.squared = squared;
        this.size = (short)hyperplane.size();
        this.coefficients = hyperplane.getCoefficients();
        this.constant = hyperplane.getConstant();
        this.variableIndexes = new int[this.size];
        RandomVariableAtom[] variables = (RandomVariableAtom[])hyperplane.getVariables();
        for (int i = 0; i < this.size; ++i) {
            this.variableIndexes[i] = termStore.getVariableIndex(variables[i]);
        }
        this.adjustedWeight = weight * c;
        float tempQii = 0.0f;
        for (int i = 0; i < this.size; ++i) {
            tempQii += this.coefficients[i] * this.coefficients[i];
        }
        this.qii = tempQii;
        this.lagrange = 0.0f;
    }

    public float getLagrange() {
        return this.lagrange;
    }

    public float evaluate(float[] variableValues) {
        float value = 0.0f;
        for (int i = 0; i < this.size; ++i) {
            value += this.coefficients[i] * variableValues[this.variableIndexes[i]];
        }
        value -= this.constant;
        if (this.squared) {
            return this.adjustedWeight * (float)Math.pow(Math.max(0.0f, value), 2.0);
        }
        return this.adjustedWeight * Math.max(value, 0.0f);
    }

    public void minimize(boolean truncateEveryStep, float[] variableValues) {
        if (this.squared) {
            float gradient = this.computeGradient(variableValues);
            this.minimize(truncateEveryStep, gradient += this.lagrange / (2.0f * this.adjustedWeight), Float.POSITIVE_INFINITY, variableValues);
        } else {
            this.minimize(truncateEveryStep, this.computeGradient(variableValues), this.adjustedWeight, variableValues);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    private float computeGradient(float[] variableValues) {
        float val = 0.0f;
        for (int i = 0; i < this.size; ++i) {
            val += variableValues[this.variableIndexes[i]] * this.coefficients[i];
        }
        return this.constant - val;
    }

    private void minimize(boolean truncateEveryStep, float gradient, float lim, float[] variableValues) {
        float pg = gradient;
        if (MathUtils.isZero(this.lagrange)) {
            pg = Math.min(0.0f, gradient);
        }
        if (MathUtils.equals(lim, this.adjustedWeight) && MathUtils.equals(this.lagrange, this.adjustedWeight)) {
            pg = Math.max(0.0f, gradient);
        }
        if (MathUtils.isZero(pg)) {
            return;
        }
        float pa = this.lagrange;
        this.lagrange = Math.min(lim, Math.max(0.0f, this.lagrange - gradient / this.qii));
        for (int i = 0; i < this.size; ++i) {
            float val = variableValues[this.variableIndexes[i]] - (this.lagrange - pa) * this.coefficients[i];
            if (truncateEveryStep) {
                val = Math.max(0.0f, Math.min(1.0f, val));
            }
            variableValues[this.variableIndexes[i]] = val;
        }
    }

    public int fixedByteSize() {
        int bitSize = 120 + this.size * 64;
        return bitSize / 8;
    }

    public void writeFixedValues(ByteBuffer fixedBuffer) {
        fixedBuffer.put((byte)(this.squared ? 1 : 0));
        fixedBuffer.putFloat(this.adjustedWeight);
        fixedBuffer.putFloat(this.constant);
        fixedBuffer.putFloat(this.qii);
        fixedBuffer.putShort(this.size);
        for (int i = 0; i < this.size; ++i) {
            fixedBuffer.putFloat(this.coefficients[i]);
            fixedBuffer.putInt(this.variableIndexes[i]);
        }
    }

    public void read(ByteBuffer fixedBuffer, ByteBuffer volatileBuffer) {
        this.squared = fixedBuffer.get() == 1;
        this.adjustedWeight = fixedBuffer.getFloat();
        this.constant = fixedBuffer.getFloat();
        this.qii = fixedBuffer.getFloat();
        this.size = fixedBuffer.getShort();
        if (this.coefficients.length < this.size) {
            this.coefficients = new float[this.size];
            this.variableIndexes = new int[this.size];
        }
        for (int i = 0; i < this.size; ++i) {
            this.coefficients[i] = fixedBuffer.getFloat();
            this.variableIndexes[i] = fixedBuffer.getInt();
        }
        this.lagrange = volatileBuffer.getFloat();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.adjustedWeight);
        builder.append(" * max(0.0, ");
        for (int i = 0; i < this.size; ++i) {
            builder.append("(");
            builder.append(this.coefficients[i]);
            builder.append(" * ");
            builder.append(this.variableIndexes[i]);
            builder.append(")");
            if (i == this.size - 1) continue;
            builder.append(" + ");
        }
        builder.append(" - ");
        builder.append(this.constant);
        builder.append(")");
        if (this.squared) {
            builder.append("^2");
        }
        return builder.toString();
    }
}

