/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.sgd.term;

import java.nio.ByteBuffer;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.VariableTermStore;

public class SGDObjectiveTerm
implements ReasonerTerm {
    private boolean squared;
    private boolean hinge;
    private float weight;
    private float constant;
    private float learningRate;
    private short size;
    private float[] coefficients;
    private int[] variableIndexes;

    public SGDObjectiveTerm(VariableTermStore<SGDObjectiveTerm, RandomVariableAtom> termStore, boolean squared, boolean hinge, Hyperplane<RandomVariableAtom> hyperplane, float weight, float learningRate) {
        this.squared = squared;
        this.hinge = hinge;
        this.weight = weight;
        this.learningRate = learningRate;
        this.size = (short)hyperplane.size();
        this.coefficients = hyperplane.getCoefficients();
        this.constant = hyperplane.getConstant();
        this.variableIndexes = new int[this.size];
        RandomVariableAtom[] variables = (RandomVariableAtom[])hyperplane.getVariables();
        for (int i = 0; i < this.size; ++i) {
            this.variableIndexes[i] = termStore.getVariableIndex(variables[i]);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public float evaluate(float[] variableValues) {
        float dot = this.dot(variableValues);
        if (this.squared && this.hinge) {
            return this.weight * (float)Math.pow(Math.max(0.0f, dot), 2.0);
        }
        if (this.squared && !this.hinge) {
            return this.weight * (float)Math.pow(dot, 2.0);
        }
        if (!this.squared && this.hinge) {
            return this.weight * Math.max(0.0f, dot);
        }
        return this.weight * dot;
    }

    public void minimize(int iteration, float[] variableValues) {
        for (int i = 0; i < this.size; ++i) {
            float dot = this.dot(variableValues);
            float gradient = this.computeGradient(iteration, i, dot) * (this.learningRate / (float)iteration);
            variableValues[this.variableIndexes[i]] = Math.max(0.0f, Math.min(1.0f, variableValues[this.variableIndexes[i]] - gradient));
        }
    }

    private float computeGradient(int iteration, int varId, float dot) {
        if (this.hinge && dot <= 0.0f) {
            return 0.0f;
        }
        if (this.squared) {
            return this.weight * 2.0f * dot * this.coefficients[varId];
        }
        return this.weight * this.coefficients[varId];
    }

    private float dot(float[] variableValues) {
        float value = 0.0f;
        for (int i = 0; i < this.size; ++i) {
            value += this.coefficients[i] * variableValues[this.variableIndexes[i]];
        }
        return value - this.constant;
    }

    public int fixedByteSize() {
        int bitSize = 128 + this.size * 64;
        return bitSize / 8;
    }

    public void writeFixedValues(ByteBuffer fixedBuffer) {
        fixedBuffer.put((byte)(this.squared ? 1 : 0));
        fixedBuffer.put((byte)(this.hinge ? 1 : 0));
        fixedBuffer.putFloat(this.weight);
        fixedBuffer.putFloat(this.constant);
        fixedBuffer.putFloat(this.learningRate);
        fixedBuffer.putShort(this.size);
        for (int i = 0; i < this.size; ++i) {
            fixedBuffer.putFloat(this.coefficients[i]);
            fixedBuffer.putInt(this.variableIndexes[i]);
        }
    }

    public void read(ByteBuffer fixedBuffer, ByteBuffer volatileBuffer) {
        this.squared = fixedBuffer.get() == 1;
        this.hinge = fixedBuffer.get() == 1;
        this.weight = fixedBuffer.getFloat();
        this.constant = fixedBuffer.getFloat();
        this.learningRate = fixedBuffer.getFloat();
        this.size = fixedBuffer.getShort();
        if (this.coefficients.length < this.size) {
            this.coefficients = new float[this.size];
            this.variableIndexes = new int[this.size];
        }
        for (int i = 0; i < this.size; ++i) {
            this.coefficients[i] = fixedBuffer.getFloat();
            this.variableIndexes[i] = fixedBuffer.getInt();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.weight);
        builder.append(" * ");
        if (this.hinge) {
            builder.append(" * max(0.0, ");
        }
        for (int i = 0; i < this.size; ++i) {
            builder.append("(");
            builder.append(this.coefficients[i]);
            builder.append(" * ");
            builder.append(this.variableIndexes[i]);
            builder.append(")");
            if (i == this.size - 1) continue;
            builder.append(" + ");
        }
        builder.append(" - ");
        builder.append(this.constant);
        if (this.hinge) {
            builder.append(")");
        }
        if (this.squared) {
            builder.append("^2");
        }
        return builder.toString();
    }
}

