/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term.blocker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.linqs.psl.grounding.GroundRuleStore;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.reasoner.term.blocker.ConstraintBlockerTerm;

public class ConstraintBlockerTermStore
implements TermStore<ConstraintBlockerTerm, RandomVariableAtom> {
    private ArrayList<ConstraintBlockerTerm> blocks = new ArrayList();
    private Map<RandomVariableAtom, Integer> rvMap = new HashMap<RandomVariableAtom, Integer>();
    private GroundRuleStore groundRuleStore = null;

    public void init(GroundRuleStore groundRuleStore, RandomVariableAtom[][] rvBlocks, WeightedGroundRule[][] incidentGRs, boolean[] exactlyOne) {
        assert (rvBlocks.length == incidentGRs.length);
        assert (rvBlocks.length == exactlyOne.length);
        this.groundRuleStore = groundRuleStore;
        this.ensureCapacity(this.blocks.size() + rvBlocks.length);
        for (int i = 0; i < rvBlocks.length; ++i) {
            Integer blockIndex = new Integer(this.blocks.size());
            this.blocks.add(new ConstraintBlockerTerm(rvBlocks[i], incidentGRs[i], exactlyOne[i]));
            for (RandomVariableAtom atom : rvBlocks[i]) {
                this.rvMap.put(atom, blockIndex);
            }
        }
    }

    public GroundRuleStore getGroundRuleStore() {
        return this.groundRuleStore;
    }

    public int getBlockIndex(RandomVariableAtom atom) {
        Integer index = this.rvMap.get(atom);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public void randomlyInitialize() {
        for (ConstraintBlockerTerm block : this.blocks) {
            block.randomlyInitialize();
        }
    }

    @Override
    public void add(GroundRule rule, ConstraintBlockerTerm term) {
        throw new UnsupportedOperationException("ConstraintBlockerTermStore needs all ground rules at once, use init().");
    }

    @Override
    public void clear() {
        if (this.blocks != null) {
            this.blocks.clear();
        }
        if (this.rvMap != null) {
            this.rvMap.clear();
        }
    }

    @Override
    public void close() {
        this.clear();
        this.blocks = null;
        this.rvMap = null;
        this.groundRuleStore = null;
    }

    @Override
    public ConstraintBlockerTerm get(int index) {
        return this.blocks.get(index);
    }

    @Override
    public int size() {
        return this.blocks.size();
    }

    @Override
    public void ensureCapacity(int capacity) {
        assert (capacity >= 0);
        if (capacity == 0) {
            return;
        }
        this.blocks.ensureCapacity(capacity);
        if (this.rvMap.size() == 0) {
            this.rvMap = new HashMap<RandomVariableAtom, Integer>((int)((double)(capacity * 2) / 0.75));
        }
    }

    @Override
    public Iterator<ConstraintBlockerTerm> iterator() {
        return this.blocks.iterator();
    }

    @Override
    public Iterator<ConstraintBlockerTerm> noWriteIterator() {
        return this.iterator();
    }

    @Override
    public RandomVariableAtom createLocalVariable(RandomVariableAtom atom) {
        throw new UnsupportedOperationException("ConstraintBlockerTermStore does not use the concept of local variables.");
    }

    @Override
    public void ensureVariableCapacity(int capacity) {
    }
}

