/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term.streaming;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.linqs.psl.database.QueryResultIterable;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.database.rdbms.RDBMSDatabase;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.WeightedRule;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.reasoner.term.HyperplaneTermGenerator;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.streaming.StreamingIterator;
import org.linqs.psl.reasoner.term.streaming.StreamingTermStore;

public abstract class StreamingInitialRoundIterator<T extends ReasonerTerm>
implements StreamingIterator<T> {
    public static final double OVERALLOCATION_RATIO = 1.25;
    protected StreamingTermStore<T> parentStore;
    protected HyperplaneTermGenerator<T, RandomVariableAtom> termGenerator;
    protected AtomManager atomManager;
    protected List<WeightedRule> rules;
    protected int currentRule;
    protected List<GroundRule> pendingGroundRules;
    protected List<T> termCache;
    protected List<T> termPool;
    protected ByteBuffer termBuffer;
    protected ByteBuffer volatileBuffer;
    protected int termCount;
    protected QueryResultIterable queryIterable;
    protected Iterator<Constant[]> queryResults;
    protected boolean closed;
    protected T nextTerm;
    protected int pageSize;
    protected int numPages;

    public StreamingInitialRoundIterator(StreamingTermStore<T> parentStore, List<WeightedRule> rules, AtomManager atomManager, HyperplaneTermGenerator<T, RandomVariableAtom> termGenerator, List<T> termCache, List<T> termPool, ByteBuffer termBuffer, ByteBuffer volatileBuffer, int pageSize) {
        this.parentStore = parentStore;
        this.termGenerator = termGenerator;
        this.atomManager = atomManager;
        this.rules = rules;
        this.currentRule = -1;
        this.pendingGroundRules = new ArrayList<GroundRule>();
        this.termCache = termCache;
        this.termCache.clear();
        this.termPool = termPool;
        this.termPool.clear();
        this.termBuffer = termBuffer;
        this.volatileBuffer = volatileBuffer;
        this.pageSize = pageSize;
        this.numPages = 0;
        this.termCount = 0;
        this.queryIterable = null;
        this.queryResults = null;
        this.closed = false;
        this.nextTerm = null;
    }

    @Override
    public boolean hasNext() {
        if (this.nextTerm != null) {
            throw new IllegalStateException("hasNext() was called twice in a row. Call next() directly after hasNext() == true.");
        }
        if (this.closed) {
            return false;
        }
        this.nextTerm = this.fetchNextTerm();
        if (this.nextTerm == null) {
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        if (this.nextTerm == null) {
            throw new IllegalStateException("Called next() when hasNext() == false (or before the first hasNext() call).");
        }
        T term = this.nextTerm;
        this.nextTerm = null;
        return term;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private T fetchNextTerm() {
        T term;
        if (this.termCache.size() >= this.pageSize) {
            this.flushCache();
        }
        if ((term = this.fetchNextTermFromRule()) != null) {
            ++this.termCount;
        }
        return term;
    }

    private T fetchNextTermFromRule() {
        Object term = null;
        while (term == null) {
            GroundRule groundRule = this.fetchNextGroundRule();
            if (groundRule == null) {
                return null;
            }
            term = this.termGenerator.createTerm(groundRule, this.parentStore);
        }
        this.termCache.add(term);
        if (this.numPages == 0) {
            this.termPool.add(term);
        }
        return (T)term;
    }

    private GroundRule fetchNextGroundRule() {
        while (this.pendingGroundRules.size() > 0) {
            GroundRule groundRule = this.pendingGroundRules.remove(this.pendingGroundRules.size() - 1);
            if (groundRule == null) continue;
            return groundRule;
        }
        while (this.queryResults != null && this.queryResults.hasNext()) {
            Constant[] tuple = this.queryResults.next();
            this.rules.get(this.currentRule).ground(tuple, this.queryIterable.getVariableMap(), this.atomManager, this.pendingGroundRules);
            while (this.pendingGroundRules.size() > 0) {
                GroundRule groundRule = this.pendingGroundRules.remove(this.pendingGroundRules.size() - 1);
                if (groundRule == null) continue;
                return groundRule;
            }
        }
        ++this.currentRule;
        if (this.currentRule >= this.rules.size()) {
            return null;
        }
        this.queryIterable = ((RDBMSDatabase)this.atomManager.getDatabase()).executeQueryIterator(this.rules.get(this.currentRule).getGroundingQuery(this.atomManager));
        this.queryResults = this.queryIterable.iterator();
        return this.fetchNextGroundRule();
    }

    private void flushCache() {
        if (this.termCache.size() == 0) {
            return;
        }
        String termPagePath = this.parentStore.getTermPagePath(this.numPages);
        String volatilePagePath = this.parentStore.getVolatilePagePath(this.numPages);
        this.writeFullPage(termPagePath, volatilePagePath);
        ++this.numPages;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.flushCache();
        if (this.queryIterable != null) {
            this.queryIterable.close();
            this.queryIterable = null;
            this.queryResults = null;
        }
        this.parentStore.initialIterationComplete(this.termCount, this.numPages, this.termBuffer, this.volatileBuffer);
    }

    protected abstract void writeFullPage(String var1, String var2);
}

