/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term.streaming;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.linqs.psl.config.Config;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.rule.WeightedRule;
import org.linqs.psl.reasoner.term.HyperplaneTermGenerator;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.VariableTermStore;
import org.linqs.psl.reasoner.term.streaming.StreamingIterator;
import org.linqs.psl.util.RandUtils;
import org.linqs.psl.util.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamingTermStore<T extends ReasonerTerm>
implements VariableTermStore<T, RandomVariableAtom> {
    private static final Logger log = LoggerFactory.getLogger(StreamingTermStore.class);
    public static final String CONFIG_PREFIX = "streamingtermstore";
    public static final String PAGE_LOCATION_KEY = "streamingtermstore.pagelocation";
    public static final String PAGE_LOCATION_DEFAULT = SystemUtils.getTempDir("streaimg_term_cache_pages");
    public static final String PAGE_SIZE_KEY = "streamingtermstore.pagesize";
    public static final int PAGE_SIZE_DEFAULT = 10000;
    public static final String SHUFFLE_PAGE_KEY = "streamingtermstore.shufflepage";
    public static final boolean SHUFFLE_PAGE_DEFAULT = true;
    public static final String RANDOMIZE_PAGE_ACCESS_KEY = "streamingtermstore.randomizepageaccess";
    public static final boolean RANDOMIZE_PAGE_ACCESS_DEFAULT = true;
    public static final String WARN_RULES_KEY = "streamingtermstore.warnunsupportedrules";
    public static final boolean WARN_RULES_DEFAULT = true;
    public static final int INITIAL_PATH_CACHE_SIZE = 100;
    protected List<WeightedRule> rules;
    protected AtomManager atomManager;
    protected Map<RandomVariableAtom, Integer> variables;
    private float[] variableValues;
    private RandomVariableAtom[] variableAtoms;
    protected List<String> termPagePaths;
    protected List<String> volatilePagePaths;
    protected boolean initialRound;
    protected StreamingIterator<T> activeIterator;
    protected int seenTermCount;
    protected int numPages;
    protected HyperplaneTermGenerator<T, RandomVariableAtom> termGenerator;
    protected int pageSize = Config.getInt("streamingtermstore.pagesize", 10000);
    protected String pageDir = Config.getString("streamingtermstore.pagelocation", PAGE_LOCATION_DEFAULT);
    protected boolean shufflePage = Config.getBoolean("streamingtermstore.shufflepage", true);
    protected boolean randomizePageAccess = Config.getBoolean("streamingtermstore.randomizepageaccess", true);
    protected boolean warnRules = Config.getBoolean("streamingtermstore.warnunsupportedrules", true);
    protected ByteBuffer termBuffer;
    protected ByteBuffer volatileBuffer;
    protected List<T> termCache;
    protected List<T> termPool;
    protected int[] shuffleMap;

    public StreamingTermStore(List<Rule> rules, AtomManager atomManager, HyperplaneTermGenerator<T, RandomVariableAtom> termGenerator) {
        this.rules = new ArrayList<WeightedRule>();
        for (Rule rule : rules) {
            if (!rule.isWeighted()) {
                if (!this.warnRules) continue;
                log.warn("Streaming term stores do not support hard constraints: " + rule);
                continue;
            }
            if (((WeightedRule)rule).getWeight() < 0.0) {
                if (!this.warnRules) continue;
                log.warn("Streaming term stores do not support negative weights: " + rule);
                continue;
            }
            if (!rule.supportsIndividualGrounding()) {
                if (!this.warnRules) continue;
                log.warn("Streaming term stores do not support rules that cannot individually ground (arithmetic rules with summations): " + rule);
                continue;
            }
            if (!this.supportsRule(rule)) {
                if (!this.warnRules) continue;
                log.warn("Rule not supported: " + rule);
                continue;
            }
            this.rules.add((WeightedRule)rule);
        }
        if (rules.size() == 0) {
            throw new IllegalArgumentException("Found no valid rules for a streaming term store.");
        }
        this.atomManager = atomManager;
        this.termGenerator = termGenerator;
        this.ensureVariableCapacity(atomManager.getCachedRVACount());
        this.termPagePaths = new ArrayList<String>(100);
        this.volatilePagePaths = new ArrayList<String>(100);
        this.initialRound = true;
        this.activeIterator = null;
        this.numPages = 0;
        this.termBuffer = null;
        this.volatileBuffer = null;
        SystemUtils.recursiveDelete(this.pageDir);
        if (this.pageSize <= 1) {
            throw new IllegalArgumentException("Page size is too small.");
        }
        this.termCache = new ArrayList<T>(this.pageSize);
        this.termPool = new ArrayList<T>(this.pageSize);
        this.shuffleMap = new int[this.pageSize];
        new File(this.pageDir).mkdirs();
    }

    @Override
    public boolean isLoaded() {
        return !this.initialRound;
    }

    @Override
    public int getNumVariables() {
        return this.variables.size();
    }

    @Override
    public Iterable<RandomVariableAtom> getVariables() {
        return this.variables.keySet();
    }

    @Override
    public float[] getVariableValues() {
        return this.variableValues;
    }

    @Override
    public int getVariableIndex(RandomVariableAtom variable) {
        return this.variables.get(variable);
    }

    @Override
    public void syncAtoms() {
        for (int i = 0; i < this.variables.size(); ++i) {
            this.variableAtoms[i].setValue(this.variableValues[i]);
        }
    }

    @Override
    public synchronized RandomVariableAtom createLocalVariable(RandomVariableAtom atom) {
        if (this.variables.containsKey(atom)) {
            return atom;
        }
        if (this.variables.size() >= this.variableAtoms.length) {
            this.ensureVariableCapacity(this.variables.size() * 2);
        }
        int index = this.variables.size();
        this.variables.put(atom, index);
        this.variableValues[index] = RandUtils.nextFloat();
        this.variableAtoms[index] = atom;
        return atom;
    }

    @Override
    public void ensureVariableCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Variable capacity must be non-negative. Got: " + capacity);
        }
        if (this.variables == null || this.variables.size() == 0) {
            this.variables = new HashMap<RandomVariableAtom, Integer>((int)Math.ceil((double)capacity / 0.75));
            this.variableValues = new float[capacity];
            this.variableAtoms = new RandomVariableAtom[capacity];
        } else if (this.variables.size() < capacity) {
            if (capacity < this.variables.size() * 2) {
                capacity = this.variables.size() * 2;
            }
            HashMap<RandomVariableAtom, Integer> newVariables = new HashMap<RandomVariableAtom, Integer>((int)Math.ceil((double)capacity / 0.75));
            newVariables.putAll(this.variables);
            this.variables = newVariables;
            this.variableValues = Arrays.copyOf(this.variableValues, capacity);
            this.variableAtoms = Arrays.copyOf(this.variableAtoms, capacity);
        }
    }

    @Override
    public int size() {
        return this.seenTermCount;
    }

    @Override
    public void add(GroundRule rule, T term) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T get(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ensureCapacity(int capacity) {
        throw new UnsupportedOperationException();
    }

    public String getTermPagePath(int index) {
        for (int i = this.termPagePaths.size(); i <= index; ++i) {
            this.termPagePaths.add(Paths.get(this.pageDir, String.format("%08d_term.page", i)).toString());
        }
        return this.termPagePaths.get(index);
    }

    public String getVolatilePagePath(int index) {
        for (int i = this.volatilePagePaths.size(); i <= index; ++i) {
            this.volatilePagePaths.add(Paths.get(this.pageDir, String.format("%08d_volatile.page", i)).toString());
        }
        return this.volatilePagePaths.get(index);
    }

    public void initialIterationComplete(int termCount, int numPages, ByteBuffer termBuffer, ByteBuffer volatileBuffer) {
        this.seenTermCount = termCount;
        this.numPages = numPages;
        this.termBuffer = termBuffer;
        this.volatileBuffer = volatileBuffer;
        this.initialRound = false;
        this.activeIterator = null;
    }

    public void cacheIterationComplete() {
        this.activeIterator = null;
    }

    @Override
    public Iterator<T> noWriteIterator() {
        if (this.activeIterator != null) {
            throw new IllegalStateException("Iterator already exists for this StreamingTermStore. Exhaust the iterator first.");
        }
        if (this.initialRound) {
            throw new IllegalStateException("A full iteration must have already been completed before asking for a read-only iterator.");
        }
        this.activeIterator = this.getNoWriteIterator();
        return this.activeIterator;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.activeIterator != null) {
            throw new IllegalStateException("Iterator already exists for this StreamingTermStore. Exhaust the iterator first.");
        }
        this.activeIterator = this.initialRound ? this.getInitialRoundIterator() : this.getCacheIterator();
        return this.activeIterator;
    }

    @Override
    public void clear() {
        this.initialRound = true;
        this.numPages = 0;
        if (this.activeIterator != null) {
            this.activeIterator.close();
            this.activeIterator = null;
        }
        if (this.variables != null) {
            this.variables.clear();
        }
        if (this.termCache != null) {
            this.termCache.clear();
        }
        if (this.termPool != null) {
            this.termPool.clear();
        }
        SystemUtils.recursiveDelete(this.pageDir);
    }

    @Override
    public void close() {
        this.clear();
        if (this.variables != null) {
            this.variables = null;
        }
        if (this.termBuffer != null) {
            this.termBuffer.clear();
            this.termBuffer = null;
        }
        if (this.volatileBuffer != null) {
            this.volatileBuffer.clear();
            this.volatileBuffer = null;
        }
        if (this.termCache != null) {
            this.termCache = null;
        }
        if (this.termPool != null) {
            this.termPool = null;
        }
    }

    protected abstract boolean supportsRule(Rule var1);

    protected abstract StreamingIterator<T> getInitialRoundIterator();

    protected abstract StreamingIterator<T> getCacheIterator();

    protected abstract StreamingIterator<T> getNoWriteIterator();
}

