/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.common.util;

import com.healthmarketscience.common.util.Tuple2;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    public static <AType extends Annotation> Collection<Tuple2<AType, Field>> findAnnotatedFields(Object instance, Class<AType> annotationClass, boolean inherit) {
        return ClassUtil.findAnnotatedElements(annotationClass, (AnnotatedElement[])ClassUtil.getFields(instance.getClass(), inherit));
    }

    public static <AType extends Annotation> Collection<Tuple2<AType, Method>> findAnnotatedMethods(Object instance, Class<AType> annotationClass, boolean inherit) {
        return ClassUtil.findAnnotatedElements(annotationClass, (AnnotatedElement[])ClassUtil.getMethods(instance.getClass(), inherit));
    }

    public static <AType extends Annotation, MType extends AnnotatedElement> Collection<Tuple2<AType, MType>> findAnnotatedElements(Class<AType> annotationClass, MType ... members) {
        ArrayList<Tuple2<AType, MType>> res = new ArrayList<Tuple2<AType, MType>>();
        for (MType member : members) {
            AType ann = member.getAnnotation(annotationClass);
            if (null == ann) continue;
            res.add(Tuple2.create(ann, member));
        }
        return res;
    }

    public static boolean isBoolean(Class<?> clazz) {
        return clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class);
    }

    public static boolean methodTakesBoolean(Method method) {
        return method.getParameterTypes().length == 1 && ClassUtil.isBoolean(method.getParameterTypes()[0]);
    }

    public static boolean fieldIsBoolean(Field field) {
        return ClassUtil.isBoolean(field.getType());
    }

    private static Field[] getFields(Class<?> clazz, boolean inherit) {
        Set<Field> fields = ClassUtil.getFields(clazz, clazz, inherit);
        return fields.toArray(new Field[fields.size()]);
    }

    private static Method[] getMethods(Class<?> clazz, boolean inherit) {
        Set<Method> methods = ClassUtil.getMethods(clazz, clazz, inherit);
        return methods.toArray(new Method[methods.size()]);
    }

    private static Set<Field> getFields(Class<?> clazz, Class<?> lowestClass, boolean inherit) {
        return ClassUtil.collectFields(new LinkedHashSet<Field>(), clazz, lowestClass, inherit);
    }

    private static Set<Method> getMethods(Class<?> clazz, Class<?> lowestClass, boolean inherit) {
        return ClassUtil.collectMethods(new LinkedHashSet<Method>(), clazz, lowestClass, inherit);
    }

    private static Set<Field> collectFields(Set<Field> fields, Class<?> clazz, Class<?> lowestClass, boolean inherit) {
        ClassUtil.addAllVisible(fields, lowestClass, (Member[])clazz.getDeclaredFields());
        Class<?> superClass = clazz.getSuperclass();
        if (inherit && superClass != null) {
            ClassUtil.collectFields(fields, superClass, lowestClass, inherit);
        }
        return fields;
    }

    private static Set<Method> collectMethods(Set<Method> methods, Class<?> clazz, Class<?> lowestClass, boolean inherit) {
        ClassUtil.addAllVisible(methods, lowestClass, (Member[])clazz.getDeclaredMethods());
        Class<?> superClass = clazz.getSuperclass();
        if (inherit && superClass != null) {
            ClassUtil.collectMethods(methods, superClass, lowestClass, inherit);
        }
        return methods;
    }

    private static <T extends Member> void addAllVisible(Collection<T> visibleMembers, Class<?> clazz, T ... members) {
        for (T member : members) {
            if (!ClassUtil.shouldSee(clazz, member)) continue;
            visibleMembers.add(member);
        }
    }

    private static boolean shouldSee(Class<?> clazz, Member member) {
        int modifiers = member.getModifiers();
        if (member.getDeclaringClass() == clazz || Modifier.isProtected(modifiers) || Modifier.isPublic(modifiers)) {
            return true;
        }
        if (Modifier.isPrivate(modifiers)) {
            return false;
        }
        return member.getDeclaringClass().getPackage().equals(clazz.getPackage());
    }
}

