/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.inference;

import java.util.List;
import org.linqs.psl.application.inference.InferenceApplication;
import org.linqs.psl.config.Config;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.database.atom.LazyAtomManager;
import org.linqs.psl.database.atom.PersistedAtomManager;
import org.linqs.psl.grounding.GroundRuleStore;
import org.linqs.psl.grounding.Grounding;
import org.linqs.psl.model.Model;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.reasoner.Reasoner;
import org.linqs.psl.reasoner.term.TermGenerator;
import org.linqs.psl.reasoner.term.TermStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyMPEInference
extends InferenceApplication {
    private static final Logger log = LoggerFactory.getLogger(LazyMPEInference.class);
    public static final String CONFIG_PREFIX = "lazympeinference";
    public static final String MAX_ROUNDS_KEY = "lazympeinference.maxrounds";
    public static final int MAX_ROUNDS_DEFAULT = 100;
    protected final int maxRounds = Config.getInt("lazympeinference.maxrounds", 100);

    public LazyMPEInference(Model model, Database db) {
        super(model, db);
    }

    @Override
    protected void completeInitialize() {
        log.debug("Initial grounding.");
        Grounding.groundAll(this.model, (AtomManager)this.atomManager, this.groundRuleStore);
    }

    @Override
    protected PersistedAtomManager createAtomManager(Database db) {
        return new LazyAtomManager(db);
    }

    @Override
    protected void internalInference() {
        LazyMPEInference.inference(this.model.getRules(), this.reasoner, this.groundRuleStore, this.termStore, this.termGenerator, (LazyAtomManager)this.atomManager, this.maxRounds);
    }

    public static void inference(List<Rule> rules, Reasoner reasoner, GroundRuleStore groundRuleStore, TermStore termStore, TermGenerator termGenerator, LazyAtomManager lazyAtomManager, int maxRounds) {
        int rounds = 0;
        int numActivated = 0;
        do {
            log.debug("Starting round {} of inference.", (Object)(++rounds));
            termStore.clear();
            log.debug("Initializing objective terms for {} ground rules.", (Object)groundRuleStore.size());
            termStore.ensureVariableCapacity(lazyAtomManager.getCachedRVACount());
            int termCount = termGenerator.generateTerms(groundRuleStore, termStore);
            log.debug("Generated {} objective terms from {} ground rules.", (Object)termCount, (Object)groundRuleStore.size());
            log.info("Beginning inference round {}.", (Object)rounds);
            reasoner.optimize(termStore);
            log.info("Inference round {} complete.", (Object)rounds);
            numActivated = lazyAtomManager.activateAtoms(rules, groundRuleStore);
            log.debug("Completed round {} and activated {} atoms.", (Object)rounds, (Object)numActivated);
        } while (numActivated > 0 && rounds < maxRounds);
    }
}

