/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term.blocker;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.grounding.AtomRegisterGroundRuleStore;
import org.linqs.psl.grounding.GroundRuleStore;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.UnweightedGroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.model.rule.arithmetic.UnweightedGroundArithmeticRule;
import org.linqs.psl.model.rule.misc.GroundValueConstraint;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.reasoner.function.GeneralFunction;
import org.linqs.psl.reasoner.term.TermGenerator;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.reasoner.term.blocker.ConstraintBlockerTerm;
import org.linqs.psl.reasoner.term.blocker.ConstraintBlockerTermStore;
import org.linqs.psl.util.MathUtils;

public class ConstraintBlockerTermGenerator
implements TermGenerator<ConstraintBlockerTerm, RandomVariableAtom> {
    @Override
    public int generateTerms(GroundRuleStore ruleStore, TermStore<ConstraintBlockerTerm, RandomVariableAtom> termStore) {
        if (!(ruleStore instanceof AtomRegisterGroundRuleStore)) {
            throw new IllegalArgumentException("AtomRegisterGroundRuleStore required.");
        }
        if (!(termStore instanceof ConstraintBlockerTermStore)) {
            throw new IllegalArgumentException("ConstraintBlockerTermStore required.");
        }
        return this.generateTermsInternal((AtomRegisterGroundRuleStore)ruleStore, (ConstraintBlockerTermStore)termStore);
    }

    private int generateTermsInternal(AtomRegisterGroundRuleStore ruleStore, ConstraintBlockerTermStore termStore) {
        HashSet<UnweightedGroundArithmeticRule> constraintSet = new HashSet<UnweightedGroundArithmeticRule>();
        HashMap<RandomVariableAtom, GroundValueConstraint> valueConstraintMap = new HashMap<RandomVariableAtom, GroundValueConstraint>();
        this.buildConstraints(ruleStore, constraintSet, valueConstraintMap);
        Set<RandomVariableAtom> freeRVSet = this.buildFreeRVSet(ruleStore);
        RandomVariableAtom[][] rvBlocks = new RandomVariableAtom[constraintSet.size() + freeRVSet.size()][];
        boolean[] exactlyOne = new boolean[rvBlocks.length];
        int blockIndex = 0;
        HashSet<RandomVariableAtom> constrainedRVSet = new HashSet<RandomVariableAtom>();
        for (UnweightedGroundArithmeticRule con : constraintSet) {
            constrainedRVSet.clear();
            boolean varsAreFree = true;
            for (GroundAtom groundAtom : con.getAtoms()) {
                if (groundAtom instanceof ObservedAtom && (double)groundAtom.getValue() != 0.0) {
                    varsAreFree = false;
                    continue;
                }
                if (!(groundAtom instanceof RandomVariableAtom)) continue;
                GroundValueConstraint valueCon = (GroundValueConstraint)valueConstraintMap.get(groundAtom);
                if (valueCon != null) {
                    if ((double)valueCon.getConstraintDefinition().getValue() == 0.0) continue;
                    varsAreFree = false;
                    continue;
                }
                constrainedRVSet.add((RandomVariableAtom)groundAtom);
            }
            if (varsAreFree) {
                rvBlocks[blockIndex] = new RandomVariableAtom[constrainedRVSet.size()];
                int j = 0;
                for (RandomVariableAtom atom2 : constrainedRVSet) {
                    rvBlocks[blockIndex][j++] = atom2;
                }
                exactlyOne[blockIndex] = con.getConstraintDefinition().getComparator().equals((Object)FunctionComparator.EQ) || constrainedRVSet.size() == 0;
            } else {
                rvBlocks[blockIndex] = new RandomVariableAtom[0];
                exactlyOne[blockIndex] = true;
                for (RandomVariableAtom randomVariableAtom : constrainedRVSet) {
                    randomVariableAtom.setValue(0.0f);
                }
            }
            ++blockIndex;
        }
        for (RandomVariableAtom atom : freeRVSet) {
            rvBlocks[blockIndex] = new RandomVariableAtom[]{atom};
            exactlyOne[blockIndex] = false;
            ++blockIndex;
        }
        WeightedGroundRule[][] incidentGRs = this.collectIncidentWeightedGroundRules(ruleStore, rvBlocks);
        for (Map.Entry e : valueConstraintMap.entrySet()) {
            ((RandomVariableAtom)e.getKey()).setValue(((GroundValueConstraint)e.getValue()).getConstraintDefinition().getValue());
        }
        termStore.init(ruleStore, rvBlocks, incidentGRs, exactlyOne);
        return rvBlocks.length;
    }

    private WeightedGroundRule[][] collectIncidentWeightedGroundRules(AtomRegisterGroundRuleStore ruleStore, RandomVariableAtom[][] rvBlocks) {
        WeightedGroundRule[][] incidentGRs = new WeightedGroundRule[rvBlocks.length][];
        HashSet<WeightedGroundRule> incidentGKSet = new HashSet<WeightedGroundRule>();
        for (int blockIndex = 0; blockIndex < rvBlocks.length; ++blockIndex) {
            incidentGKSet.clear();
            for (RandomVariableAtom atom : rvBlocks[blockIndex]) {
                for (GroundRule incidentGK : ruleStore.getRegisteredGroundRules(atom)) {
                    if (!(incidentGK instanceof WeightedGroundRule)) continue;
                    incidentGKSet.add((WeightedGroundRule)incidentGK);
                }
            }
            incidentGRs[blockIndex] = new WeightedGroundRule[incidentGKSet.size()];
            int j = 0;
            for (WeightedGroundRule incidentGK : incidentGKSet) {
                incidentGRs[blockIndex][j++] = incidentGK;
            }
        }
        return incidentGRs;
    }

    private Set<RandomVariableAtom> buildFreeRVSet(AtomRegisterGroundRuleStore ruleStore) {
        HashSet<RandomVariableAtom> freeRVSet = new HashSet<RandomVariableAtom>();
        for (GroundRule groundRule : ruleStore.getGroundRules()) {
            for (GroundAtom atom : groundRule.getAtoms()) {
                if (!(atom instanceof RandomVariableAtom)) continue;
                int numDomainConstraints = 0;
                int numValueConstraints = 0;
                for (GroundRule incidentGR : ruleStore.getRegisteredGroundRules(atom)) {
                    if (incidentGR instanceof UnweightedGroundArithmeticRule) {
                        ++numDomainConstraints;
                        continue;
                    }
                    if (!(incidentGR instanceof GroundValueConstraint)) continue;
                    ++numValueConstraints;
                }
                if (numDomainConstraints == 0 && numValueConstraints == 0) {
                    freeRVSet.add((RandomVariableAtom)atom);
                    continue;
                }
                if (numDomainConstraints < 2 && numValueConstraints < 2) continue;
                throw new IllegalStateException("RandomVariableAtoms may only participate in one (at-least) 1-of-k and/or GroundValueConstraint.");
            }
        }
        return freeRVSet;
    }

    private void buildConstraints(GroundRuleStore ruleStore, Set<UnweightedGroundArithmeticRule> constraintSet, Map<RandomVariableAtom, GroundValueConstraint> valueConstraintMap) {
        for (UnweightedGroundRule groundRule : ruleStore.getConstraintRules()) {
            if (groundRule instanceof GroundValueConstraint) {
                valueConstraintMap.put(((GroundValueConstraint)groundRule).getAtom(), (GroundValueConstraint)groundRule);
                continue;
            }
            if (!(groundRule instanceof UnweightedGroundArithmeticRule)) {
                throw new IllegalStateException("Unsupported ground rule: [" + groundRule + "]. Only categorical (functional) arithmetic constraints are supported.");
            }
            UnweightedGroundArithmeticRule gar = (UnweightedGroundArithmeticRule)groundRule;
            boolean categorical = true;
            FunctionComparator comparator = gar.getConstraintDefinition().getComparator();
            double rhsValue = gar.getConstraintDefinition().getValue();
            if (!(comparator == FunctionComparator.EQ && MathUtils.equals(rhsValue, 1.0) || comparator == FunctionComparator.LTE && MathUtils.equals(rhsValue, 1.0) || comparator == FunctionComparator.GTE && MathUtils.equals(rhsValue, -1.0))) {
                categorical = false;
            } else {
                GeneralFunction sum = gar.getConstraintDefinition().getFunction();
                for (int i = 0; i < sum.size(); ++i) {
                    if (!((double)Math.abs(sum.getCoefficient(i) - gar.getConstraintDefinition().getValue()) > 1.0E-8)) continue;
                    categorical = false;
                    break;
                }
            }
            if (!categorical) {
                throw new IllegalStateException("Unsupported ground rule: [" + groundRule + "]. The only supported constraints are 1-of-k constraints and at-least-1-of-k constraints and value constraints.");
            }
            constraintSet.add(gar);
        }
    }
}

