/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.DropQuery;
import com.healthmarketscience.sqlbuilder.Query;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.ValidationException;
import com.healthmarketscience.sqlbuilder.dbspec.Column;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCreateQuery<ThisType extends BaseCreateQuery<ThisType>>
extends Query<ThisType> {
    protected SqlObject _object;
    protected SqlObjectList<SqlObject> _columns = SqlObjectList.create();

    protected BaseCreateQuery(SqlObject objectStr) {
        this._object = objectStr;
    }

    public ThisType setName(String name) {
        return this.setCustomName(name);
    }

    public ThisType setCustomName(Object name) {
        this._object = Converter.toCustomSqlObject(name);
        return (ThisType)((BaseCreateQuery)this.getThisType());
    }

    public ThisType addColumns(Column ... columns) {
        return this.addCustomColumns(columns);
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        this._object.collectSchemaObjects(vContext);
        this._columns.collectSchemaObjects(vContext);
    }

    @Override
    public void validate(ValidationContext vContext) throws ValidationException {
        super.validate(vContext);
        if (SelectQuery.hasAllColumns(this._columns)) {
            throw new ValidationException("Cannot use the '*' syntax in this query");
        }
    }

    public abstract ThisType addCustomColumns(Object ... var1);

    public abstract DropQuery getDropQuery();
}

