/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.config.Config;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.DatabaseQuery;
import org.linqs.psl.database.Partition;
import org.linqs.psl.database.QueryResultIterable;
import org.linqs.psl.database.ResultList;
import org.linqs.psl.database.rdbms.Formula2SQL;
import org.linqs.psl.database.rdbms.PredicateInfo;
import org.linqs.psl.database.rdbms.RDBMSDataStore;
import org.linqs.psl.database.rdbms.RDBMSResultList;
import org.linqs.psl.database.rdbms.RawQuery;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.QueryAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.predicate.FunctionalPredicate;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.model.term.DoubleAttribute;
import org.linqs.psl.model.term.IntegerAttribute;
import org.linqs.psl.model.term.LongAttribute;
import org.linqs.psl.model.term.StringAttribute;
import org.linqs.psl.model.term.Term;
import org.linqs.psl.model.term.UniqueIntID;
import org.linqs.psl.model.term.UniqueStringID;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.model.term.VariableTypeMap;
import org.linqs.psl.util.Parallel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBMSDatabase
extends Database {
    private static final Logger log = LoggerFactory.getLogger(RDBMSDatabase.class);
    public static final String CONFIG_PREFIX = "rdbmsdatabase";
    public static final String FETCH_SIZE_KEY = "rdbmsdatabase.fetchsize";
    public static final int FETCH_SIZE_DEFAULT = 500;
    private static final float DEFAULT_UNOBSERVED_VALUE = 0.0f;
    private static final String THREAD_QUERY_ATOM_KEY = RDBMSDatabase.class.getName() + "::" + QueryAtom.class.getName();
    private final Set<Predicate> closedPredicates;
    private int fetchSize = Config.getInt("rdbmsdatabase.fetchsize", 500);

    public RDBMSDatabase(RDBMSDataStore parent, Partition write, Partition[] read, Set<StandardPredicate> closed) {
        super(parent, write, read);
        this.closedPredicates = new HashSet<Predicate>();
        if (closed != null) {
            this.closedPredicates.addAll(closed);
        }
        this.closed = false;
    }

    @Override
    public GroundAtom getAtom(Predicate predicate, Constant ... arguments) {
        if (this.closed) {
            throw new IllegalStateException("Cannot query atom from closed database.");
        }
        if (predicate instanceof StandardPredicate) {
            return this.getAtom((StandardPredicate)predicate, arguments);
        }
        if (predicate instanceof FunctionalPredicate) {
            return this.getAtom((FunctionalPredicate)predicate, arguments);
        }
        throw new IllegalStateException("Unknown predicate type: " + predicate.getClass().toString());
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean deleteAtom(GroundAtom atom) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void commit(Iterable<RandomVariableAtom> atoms) {
        this.commit(atoms, this.writeID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commit(Iterable<RandomVariableAtom> atoms, int partitionId) {
        if (this.closed) {
            throw new IllegalStateException("Cannot commit on a closed database.");
        }
        HashMap atomsByPredicate = new HashMap();
        for (RandomVariableAtom atom : atoms) {
            if (!atomsByPredicate.containsKey(atom.getPredicate())) {
                atomsByPredicate.put(atom.getPredicate(), new ArrayList());
            }
            ((List)atomsByPredicate.get(atom.getPredicate())).add(atom);
        }
        try (Connection connection = this.getConnection();){
            for (Map.Entry entry : atomsByPredicate.entrySet()) {
                try {
                    PreparedStatement statement = this.getAtomUpsert(connection, ((RDBMSDataStore)this.parentDataStore).getPredicateInfo((Predicate)entry.getKey()));
                    Throwable throwable = null;
                    try {
                        int batchSize = 0;
                        for (RandomVariableAtom atom : (List)entry.getValue()) {
                            statement.setInt(1, partitionId);
                            statement.setDouble(2, atom.getValue());
                            Constant[] arguments = atom.getArguments();
                            for (int i = 0; i < arguments.length; ++i) {
                                this.setAtomArgument(statement, arguments[i], i + 3);
                            }
                            statement.addBatch();
                            if (++batchSize < 2500) continue;
                            statement.executeBatch();
                            statement.clearBatch();
                            batchSize = 0;
                        }
                        if (batchSize > 0) {
                            statement.executeBatch();
                            statement.clearBatch();
                        }
                        statement.clearParameters();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                catch (SQLException ex) {
                    throw new RuntimeException("Error doing batch commit for: " + entry.getKey(), ex);
                    return;
                }
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error doing batch commit.", ex);
        }
    }

    @Override
    public void moveToWritePartition(StandardPredicate predicate, int oldPartitionId) {
        PredicateInfo predicateInfo = ((RDBMSDataStore)this.parentDataStore).getPredicateInfo(predicate);
        try (Connection connection = this.getConnection();
             PreparedStatement statement = predicateInfo.createPartitionMoveStatement(connection, oldPartitionId, this.writeID);){
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error moving partitions for: " + predicate, ex);
        }
    }

    @Override
    public QueryResultIterable executeGroundingQuery(Formula formula) {
        return this.executeQueryIterator(formula, false);
    }

    @Override
    public ResultList executeQuery(DatabaseQuery query) {
        return this.executeQuery(query.getFormula(), query.getDistinct(), query.getIgnoreVariables());
    }

    private ResultList executeQuery(Formula formula, boolean isDistinct, Set<Variable> ignoreVariables) {
        VariableTypeMap varTypes = formula.collectVariables(new VariableTypeMap());
        HashSet<Variable> projectTo = new HashSet<Variable>(varTypes.getVariables());
        projectTo.removeAll(ignoreVariables);
        Formula2SQL sqler = new Formula2SQL(projectTo, this, isDistinct);
        String queryString = sqler.getSQL(formula);
        Map<Variable, Integer> projectionMap = sqler.getProjectionMap();
        return this.executeQuery(projectionMap, varTypes, queryString);
    }

    private QueryResultIterable executeQueryIterator(Formula formula, boolean isDistinct) {
        VariableTypeMap varTypes = formula.collectVariables(new VariableTypeMap());
        HashSet<Variable> projectTo = new HashSet<Variable>(varTypes.getVariables());
        Formula2SQL sqler = new Formula2SQL(projectTo, this, isDistinct);
        String queryString = sqler.getSQL(formula);
        Map<Variable, Integer> projectionMap = sqler.getProjectionMap();
        return this.executeQueryIterator(projectionMap, varTypes, queryString);
    }

    public ResultList executeQuery(RawQuery rawQuery) {
        return this.executeQuery(rawQuery.getProjectionMap(), rawQuery.getVariableTypes(), rawQuery.getSQL());
    }

    public QueryResultIterable executeQueryIterator(RawQuery rawQuery) {
        return this.executeQueryIterator(rawQuery.getProjectionMap(), rawQuery.getVariableTypes(), rawQuery.getSQL());
    }

    public ResultList executeQuery(Map<Variable, Integer> projectionMap, VariableTypeMap varTypes, String queryString) {
        if (this.closed) {
            throw new IllegalStateException("Cannot perform query on database that was closed.");
        }
        int[] orderedIndexes = new int[projectionMap.size()];
        ConstantType[] orderedTypes = new ConstantType[projectionMap.size()];
        RDBMSResultList results = this.initQueryResults(projectionMap, varTypes, orderedIndexes, orderedTypes);
        for (Constant[] row : this.executeQueryIterator(queryString, projectionMap, orderedIndexes, orderedTypes)) {
            results.addResult(row);
        }
        log.trace("Number of results: {}", (Object)results.size());
        return results;
    }

    public QueryResultIterable executeQueryIterator(Map<Variable, Integer> projectionMap, VariableTypeMap varTypes, String queryString) {
        if (this.closed) {
            throw new IllegalStateException("Cannot perform query on database that was closed.");
        }
        int[] orderedIndexes = new int[projectionMap.size()];
        ConstantType[] orderedTypes = new ConstantType[projectionMap.size()];
        this.initQueryResults(projectionMap, varTypes, orderedIndexes, orderedTypes);
        return this.executeQueryIterator(queryString, projectionMap, orderedIndexes, orderedTypes);
    }

    public QueryResultIterable executeQueryIterator(String queryString, Map<Variable, Integer> projectionMap, int[] orderedIndexes, ConstantType[] orderedTypes) {
        if (this.closed) {
            throw new IllegalStateException("Cannot perform query on database that was closed.");
        }
        log.trace(queryString);
        return new RDBMSQueryResultIterable(queryString, projectionMap, orderedIndexes, orderedTypes);
    }

    private RDBMSResultList initQueryResults(Map<Variable, Integer> projectionMap, VariableTypeMap varTypes, int[] orderedIndexes, ConstantType[] orderedTypes) {
        RDBMSResultList results = new RDBMSResultList(projectionMap.size());
        for (Map.Entry<Variable, Integer> projection : projectionMap.entrySet()) {
            results.setVariable(projection.getKey(), projection.getValue());
        }
        for (Map.Entry<Variable, Integer> entry : results.getVariableMap().entrySet()) {
            Variable variable = entry.getKey();
            int index = entry.getValue();
            orderedIndexes[index] = projectionMap.get(variable);
            orderedTypes[index] = varTypes.getType(variable);
        }
        return results;
    }

    @Override
    public boolean isClosed(StandardPredicate predicate) {
        return this.closedPredicates.contains(predicate);
    }

    private Connection getConnection() {
        return ((RDBMSDataStore)this.parentDataStore).getConnection();
    }

    @Override
    public void close() {
        if (this.closed) {
            throw new IllegalStateException("Cannot close database after it has been closed.");
        }
        ((RDBMSDataStore)this.parentDataStore).releasePartitions(this);
        this.closed = true;
    }

    private PreparedStatement getAtomQuery(Connection connection, PredicateInfo predicate, Constant[] arguments) {
        PreparedStatement statement = predicate.createQueryStatement(connection, this.allPartitionIDs);
        try {
            for (int i = 0; i < arguments.length; ++i) {
                this.setAtomArgument(statement, arguments[i], i + 1);
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("Failed to set prepared statement atom arguments for " + predicate.predicate() + ".");
        }
        return statement;
    }

    private PreparedStatement getAtomUpsert(Connection connection, PredicateInfo predicate) {
        return predicate.createUpsertStatement(connection, ((RDBMSDataStore)this.parentDataStore).getDriver());
    }

    private PreparedStatement getAtomDelete(Connection connection, PredicateInfo predicate, Term[] arguments) {
        PreparedStatement statement = predicate.createDeleteStatement(connection, this.writeID);
        try {
            for (int i = 0; i < arguments.length; ++i) {
                this.setAtomArgument(statement, arguments[i], i + 1);
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("Failed to set prepared statement atom arguments for " + predicate.predicate() + ".");
        }
        return statement;
    }

    private Constant extractConstantFromResult(ResultSet results, int columnIndex, ConstantType type) {
        try {
            switch (type) {
                case Double: {
                    return new DoubleAttribute(results.getDouble(columnIndex + 1));
                }
                case Integer: {
                    return new IntegerAttribute(results.getInt(columnIndex + 1));
                }
                case String: {
                    return new StringAttribute(results.getString(columnIndex + 1));
                }
                case Long: {
                    return new LongAttribute(results.getLong(columnIndex + 1));
                }
                case UniqueIntID: {
                    return new UniqueIntID(results.getInt(columnIndex + 1));
                }
                case UniqueStringID: {
                    return new UniqueStringID(results.getString(columnIndex + 1));
                }
            }
            throw new IllegalArgumentException("Unknown argument type: " + (Object)((Object)type));
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error extracting constant from ResultSet.", ex);
        }
    }

    private GroundAtom extractGroundAtomFromResult(ResultSet resultSet, StandardPredicate predicate, Constant[] arguments) throws SQLException {
        int partition;
        float value = resultSet.getFloat("value");
        if (resultSet.wasNull()) {
            value = Float.NaN;
        }
        if ((partition = resultSet.getInt("partition_id")) == this.writeID) {
            if (this.isClosed(predicate)) {
                return this.cache.instantiateObservedAtom(predicate, arguments, value);
            }
            return this.cache.instantiateRandomVariableAtom(predicate, arguments, value);
        }
        return this.cache.instantiateObservedAtom(predicate, arguments, value);
    }

    private GroundAtom getAtom(StandardPredicate predicate, Constant ... arguments) {
        return this.getAtom(predicate, true, arguments);
    }

    @Override
    public GroundAtom getAtom(StandardPredicate predicate, boolean create, Constant ... arguments) {
        QueryAtom queryAtom = null;
        if (!Parallel.hasThreadObject(THREAD_QUERY_ATOM_KEY)) {
            queryAtom = new QueryAtom(predicate, arguments);
            Parallel.putThreadObject(THREAD_QUERY_ATOM_KEY, queryAtom);
        } else {
            queryAtom = (QueryAtom)Parallel.getThreadObject(THREAD_QUERY_ATOM_KEY);
            queryAtom.assume(predicate, arguments);
        }
        GroundAtom result = this.cache.getCachedAtom(queryAtom);
        if (result != null) {
            return result;
        }
        return this.fetchAtom(predicate, create, arguments);
    }

    private GroundAtom fetchAtom(StandardPredicate predicate, boolean create, Constant ... arguments) {
        ((RDBMSDataStore)this.parentDataStore).getPredicateInfo(predicate);
        GroundAtom result = this.queryDBForAtom(predicate, arguments);
        if (result != null || !create) {
            return result;
        }
        result = this.isClosed(predicate) ? this.cache.instantiateObservedAtom(predicate, arguments, 0.0f) : this.cache.instantiateRandomVariableAtom(predicate, arguments, 0.0f);
        return result;
    }

    /*
     * Exception decompiling
     */
    private GroundAtom queryDBForAtom(StandardPredicate predicate, Constant[] arguments) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<GroundAtom> getAllGroundAtoms(StandardPredicate predicate, List<Integer> partitions) {
        ArrayList<GroundAtom> atoms = new ArrayList<GroundAtom>();
        PredicateInfo predicateInfo = ((RDBMSDataStore)this.parentDataStore).getPredicateInfo(predicate);
        List<String> argumentCols = predicateInfo.argumentColumns();
        Constant[] arguments = new Constant[argumentCols.size()];
        try (Connection connection = this.getConnection();
             PreparedStatement statement = predicateInfo.createQueryAllStatement(connection, partitions);
             ResultSet results = statement.executeQuery();){
            while (results.next()) {
                for (int i = 0; i < argumentCols.size(); ++i) {
                    arguments[i] = this.extractConstantFromResult(results, i + 2, predicate.getArgumentType(i));
                }
                atoms.add(this.extractGroundAtomFromResult(results, predicate, arguments));
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error fetching all ground atoms for: " + predicate, ex);
        }
        return atoms;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int countAllGroundAtoms(StandardPredicate predicate, List<Integer> partitions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private GroundAtom getAtom(FunctionalPredicate predicate, Constant ... arguments) {
        QueryAtom queryAtom = new QueryAtom(predicate, arguments);
        GroundAtom result = this.cache.getCachedAtom(queryAtom);
        if (result != null) {
            return result;
        }
        float value = (float)predicate.computeValue(this, arguments);
        return this.cache.instantiateObservedAtom(predicate, arguments, value);
    }

    private void setAtomArgument(PreparedStatement statement, Term argument, int index) throws SQLException {
        if (argument instanceof IntegerAttribute) {
            statement.setInt(index, ((IntegerAttribute)argument).getValue());
        } else if (argument instanceof DoubleAttribute) {
            statement.setDouble(index, ((DoubleAttribute)argument).getValue());
        } else if (argument instanceof StringAttribute) {
            statement.setString(index, ((StringAttribute)argument).getValue());
        } else if (argument instanceof LongAttribute) {
            statement.setLong(index, ((LongAttribute)argument).getValue());
        } else if (argument instanceof UniqueIntID) {
            statement.setInt(index, ((UniqueIntID)argument).getID());
        } else if (argument instanceof UniqueStringID) {
            statement.setString(index, ((UniqueStringID)argument).getID());
        } else {
            throw new IllegalArgumentException("Unknown argument type: " + argument.getClass());
        }
    }

    private class RDBMSQueryResultIterator
    implements Iterator<Constant[]> {
        private String queryString;
        private int[] orderedIndexes;
        private ConstantType[] orderedTypes;
        private Connection connection;
        private Statement statement;
        private ResultSet resultSet;
        private Constant[] next;

        public RDBMSQueryResultIterator(String queryString, int[] orderedIndexes, ConstantType[] orderedTypes) {
            this.queryString = queryString;
            this.orderedIndexes = orderedIndexes;
            this.orderedTypes = orderedTypes;
            this.next = null;
            this.connection = null;
            this.statement = null;
            this.resultSet = null;
            try {
                this.connection = RDBMSDatabase.this.getConnection();
                this.connection.setAutoCommit(false);
                this.statement = this.connection.createStatement();
                this.statement.setFetchSize(RDBMSDatabase.this.fetchSize);
                this.resultSet = this.statement.executeQuery(queryString);
            }
            catch (SQLException ex) {
                this.close();
                throw new RuntimeException("Error executing query: [" + queryString + "],", ex);
            }
            this.fetchNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Constant[] next() {
            Constant[] rtn = this.next;
            this.fetchNext();
            return rtn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void fetchNext() {
            boolean hasNext = false;
            try {
                hasNext = this.resultSet.next();
            }
            catch (SQLException ex) {
                throw new RuntimeException("Error while fetching results for query: [" + this.queryString + "].", ex);
            }
            if (hasNext) {
                this.next = new Constant[this.orderedIndexes.length];
                for (int i = 0; i < this.next.length; ++i) {
                    this.next[i] = RDBMSDatabase.this.extractConstantFromResult(this.resultSet, this.orderedIndexes[i], this.orderedTypes[i]);
                }
            } else {
                this.close();
            }
        }

        public void close() {
            this.next = null;
            if (this.resultSet != null) {
                try {
                    this.resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.resultSet = null;
            }
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.statement = null;
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connection = null;
            }
        }
    }

    private class RDBMSQueryResultIterable
    implements QueryResultIterable {
        private Map<Variable, Integer> projectionMap;
        private RDBMSQueryResultIterator iterator;

        public RDBMSQueryResultIterable(String queryString, Map<Variable, Integer> projectionMap, int[] orderedIndexes, ConstantType[] orderedTypes) {
            this.projectionMap = Collections.unmodifiableMap(projectionMap);
            this.iterator = new RDBMSQueryResultIterator(queryString, orderedIndexes, orderedTypes);
        }

        @Override
        public Map<Variable, Integer> getVariableMap() {
            return this.projectionMap;
        }

        @Override
        public Iterator<Constant[]> iterator() {
            return this.iterator;
        }

        @Override
        public void close() {
            if (this.iterator != null) {
                this.iterator.close();
                this.iterator = null;
            }
        }
    }
}

