/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.custom.HookAnchor;
import com.healthmarketscience.sqlbuilder.custom.HookType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CustomizableSqlObject
extends SqlObject {
    private List<Customization> _customizations;

    protected CustomizableSqlObject() {
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        if (this._customizations != null) {
            for (Customization cust : this._customizations) {
                cust.getObject().collectSchemaObjects(vContext);
            }
        }
    }

    protected void maybeAppendTo(AppendableExt app, HookAnchor anchor, String clauseText, SqlObject clauseContent, boolean includeClause) throws IOException {
        if (includeClause) {
            this.customAppendTo(app, anchor, clauseText).append(clauseContent);
        } else {
            this.customAppendTo(app, anchor);
        }
    }

    protected void maybeAppendTo(AppendableExt app, HookAnchor anchor, String clauseText, boolean includeClause) throws IOException {
        if (includeClause) {
            this.customAppendTo(app, anchor, clauseText);
        } else {
            this.customAppendTo(app, anchor);
        }
    }

    protected AppendableExt customAppendTo(AppendableExt app, HookAnchor anchor) throws IOException {
        List<Customization> custs = null;
        if (this._customizations != null && (custs = this.findCustomizations(anchor)) != null) {
            CustomizableSqlObject.appendCustomizations(app, custs, HookType.BEFORE);
            CustomizableSqlObject.appendCustomizations(app, custs, HookType.AFTER);
        }
        return app;
    }

    protected AppendableExt customAppendTo(AppendableExt app, HookAnchor anchor, String str) throws IOException {
        List<Customization> custs = null;
        if (this._customizations == null || (custs = this.findCustomizations(anchor)) == null) {
            return app.append(str);
        }
        CustomizableSqlObject.appendCustomizations(app, custs, HookType.BEFORE);
        CustomizableSqlObject.appendCustomizations(app, custs, HookType.PREFIX);
        if (!CustomizableSqlObject.appendCustomizations(app, custs, HookType.REPLACEMENT)) {
            app.append(str);
        }
        CustomizableSqlObject.appendCustomizations(app, custs, HookType.SUFFIX);
        CustomizableSqlObject.appendCustomizations(app, custs, HookType.AFTER);
        return app;
    }

    private List<Customization> findCustomizations(HookAnchor anchor) {
        ArrayList<Customization> custs = null;
        for (Customization cust : this._customizations) {
            if (!cust.forAnchor(anchor)) continue;
            if (custs == null) {
                custs = new ArrayList<Customization>(2);
            }
            custs.add(cust);
        }
        return custs;
    }

    private static boolean appendCustomizations(AppendableExt app, List<Customization> custs, HookType type) throws IOException {
        boolean found = false;
        for (Customization cust : custs) {
            if (!cust.forType(type)) continue;
            app.append(cust.getObject());
            found |= true;
        }
        return found;
    }

    protected void addCustomization(HookAnchor anchor, HookType type, Object obj) {
        if (obj == null) {
            return;
        }
        if (this._customizations == null) {
            this._customizations = new ArrayList<Customization>(2);
        }
        this._customizations.add(new Customization(anchor, type, Converter.toCustomSqlObject(obj)));
    }

    private static final class Customization {
        private final HookAnchor _anchor;
        private final HookType _type;
        private final SqlObject _obj;

        private Customization(HookAnchor anchor, HookType type, SqlObject obj) {
            this._anchor = anchor;
            this._type = type;
            this._obj = obj;
        }

        public SqlObject getObject() {
            return this._obj;
        }

        public boolean forAnchor(HookAnchor anchor) {
            return this._anchor == anchor;
        }

        public boolean forType(HookType type) {
            return this._type == type;
        }
    }
}

