/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.learning.weight.search.grid;

import java.util.List;
import org.linqs.psl.application.learning.weight.search.grid.BaseGridSearch;
import org.linqs.psl.config.Options;
import org.linqs.psl.database.Database;
import org.linqs.psl.model.Model;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.util.RandUtils;

public class ContinuousRandomGridSearch
extends BaseGridSearch {
    public static final int SCALE_FACTOR = 10;
    private double baseWeight;
    private double variance;
    private int scaleOrder = Options.WLA_CRGS_SCALE_ORDERS.getInt();
    private int currentScale = 0;

    public ContinuousRandomGridSearch(Model model, Database rvDB, Database observedDB) {
        this(model.getRules(), rvDB, observedDB);
    }

    public ContinuousRandomGridSearch(List<Rule> rules, Database rvDB, Database observedDB) {
        super(rules, rvDB, observedDB);
        this.numLocations = Options.WLA_CRGS_MAX_LOCATIONS.getInt();
        this.baseWeight = Options.WLA_CRGS_BASE_WEIGHT.getDouble();
        this.variance = Options.WLA_CRGS_VARIANCE.getDouble();
    }

    @Override
    protected void getWeights(double[] weights) {
        if (this.currentScale == 0) {
            for (int i = 0; i < this.mutableRules.size(); ++i) {
                weights[i] = RandUtils.nextDouble() * Math.sqrt(this.variance) + this.baseWeight;
            }
        } else {
            int i = 0;
            while (i < this.mutableRules.size()) {
                int n = i++;
                weights[n] = weights[n] * 10.0;
            }
        }
        ++this.currentScale;
        if (this.currentScale > this.scaleOrder) {
            this.currentScale = 0;
        }
    }

    @Override
    protected boolean chooseNextLocation() {
        this.currentLocation = "" + this.objectives.size();
        return true;
    }
}

