/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.atom;

import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SetOperationQuery;
import com.healthmarketscience.sqlbuilder.UnionQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.config.Options;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.ResultList;
import org.linqs.psl.database.atom.PersistedAtomManager;
import org.linqs.psl.database.rdbms.Formula2SQL;
import org.linqs.psl.database.rdbms.RDBMSDatabase;
import org.linqs.psl.grounding.GroundRuleStore;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.rule.arithmetic.AbstractArithmeticRule;
import org.linqs.psl.model.rule.logical.AbstractLogicalRule;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.model.term.VariableTypeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyAtomManager
extends PersistedAtomManager {
    private static final Logger log = LoggerFactory.getLogger(LazyAtomManager.class);
    private final Set<RandomVariableAtom> lazyAtoms;
    private final double activation;

    public LazyAtomManager(Database db) {
        super(db);
        if (!(db instanceof RDBMSDatabase)) {
            throw new IllegalArgumentException("LazyAtomManagers require RDBMSDatabase.");
        }
        this.lazyAtoms = new HashSet<RandomVariableAtom>();
        this.activation = Options.LAM_ACTIVATION_THRESHOLD.getDouble();
    }

    @Override
    public synchronized GroundAtom getAtom(Predicate predicate, Constant ... arguments) {
        GroundAtom atom = this.db.getAtom(predicate, arguments);
        if (!(atom instanceof RandomVariableAtom)) {
            return atom;
        }
        RandomVariableAtom rvAtom = (RandomVariableAtom)atom;
        if (!rvAtom.getPersisted()) {
            this.lazyAtoms.add(rvAtom);
        }
        return rvAtom;
    }

    @Override
    public void reportAccessException(RuntimeException ex, GroundAtom offendingAtom) {
    }

    public Set<RandomVariableAtom> getLazyAtoms() {
        return Collections.unmodifiableSet(this.lazyAtoms);
    }

    public int countActivatableAtoms() {
        int count = 0;
        for (RandomVariableAtom atom : this.lazyAtoms) {
            if (!((double)atom.getValue() >= this.activation)) continue;
            ++count;
        }
        return count;
    }

    public int activateAtoms(List<Rule> rules, GroundRuleStore groundRuleStore) {
        if (this.lazyAtoms.size() == 0) {
            return 0;
        }
        HashSet<RandomVariableAtom> toActivate = new HashSet<RandomVariableAtom>();
        Iterator<RandomVariableAtom> lazyAtomIterator = this.lazyAtoms.iterator();
        while (lazyAtomIterator.hasNext()) {
            RandomVariableAtom atom = lazyAtomIterator.next();
            if (!((double)atom.getValue() >= this.activation)) continue;
            toActivate.add(atom);
            lazyAtomIterator.remove();
        }
        this.activate(toActivate, rules, groundRuleStore);
        return toActivate.size();
    }

    public int activateAtoms(Set<RandomVariableAtom> atoms, List<Rule> rules, GroundRuleStore groundRuleStore) {
        Iterator<RandomVariableAtom> atomIterator = atoms.iterator();
        while (atomIterator.hasNext()) {
            RandomVariableAtom atom = atomIterator.next();
            if (this.lazyAtoms.contains(atom)) continue;
            atomIterator.remove();
        }
        this.activate(atoms, rules, groundRuleStore);
        return atoms.size();
    }

    private void activate(Set<RandomVariableAtom> toActivate, List<Rule> rules, GroundRuleStore groundRuleStore) {
        this.db.commit(toActivate, -1);
        this.addToPersistedCache(toActivate);
        Set<StandardPredicate> lazyPredicates = this.getLazyPredicates(toActivate);
        Set<Rule> lazyRules = this.getLazyRules(rules, lazyPredicates);
        for (Rule lazyRule : lazyRules) {
            if (!lazyRule.supportsGroundingQueryRewriting()) continue;
            this.lazySimpleGround(lazyRule, lazyPredicates, groundRuleStore);
        }
        for (StandardPredicate lazyPredicate : lazyPredicates) {
            this.db.moveToWritePartition(lazyPredicate, -1);
        }
        for (Rule lazyRule : lazyRules) {
            if (lazyRule.supportsGroundingQueryRewriting()) continue;
            this.lazyComplexGround((AbstractArithmeticRule)lazyRule, groundRuleStore);
        }
    }

    private void lazyComplexGround(AbstractArithmeticRule rule, GroundRuleStore groundRuleStore) {
        log.trace(String.format("Complex lazy grounding on rule [%s]", rule));
        groundRuleStore.removeGroundRules(rule);
        rule.groundAll(this, groundRuleStore);
    }

    private void lazySimpleGround(Rule rule, Set<StandardPredicate> lazyPredicates, GroundRuleStore groundRuleStore) {
        if (!rule.supportsGroundingQueryRewriting()) {
            throw new UnsupportedOperationException("Rule requires full regrounding: " + rule);
        }
        Formula formula = rule.getRewritableGroundingFormula(this);
        ResultList groundingResults = this.getLazyGroundingResults(formula, lazyPredicates);
        if (groundingResults == null) {
            return;
        }
        log.trace(String.format("Simple lazy grounding on rule: [%s], formula: [%s]", rule, formula));
        ArrayList<GroundRule> groundRules = new ArrayList<GroundRule>();
        for (int i = 0; i < groundingResults.size(); ++i) {
            groundRules.clear();
            rule.ground(groundingResults.get(i), groundingResults.getVariableMap(), this, groundRules);
            for (GroundRule groundRule : groundRules) {
                if (groundRule == null) continue;
                groundRuleStore.addGroundRule(groundRule);
            }
        }
    }

    private ResultList getLazyGroundingResults(Formula formula, Set<StandardPredicate> lazyPredicates) {
        ArrayList<Atom> lazyTargets = new ArrayList<Atom>();
        for (Atom atom : formula.getAtoms(new HashSet<Atom>())) {
            if (!lazyPredicates.contains(atom.getPredicate())) continue;
            lazyTargets.add(atom);
        }
        if (lazyTargets.size() == 0) {
            return null;
        }
        return this.lazyGround(formula, lazyTargets);
    }

    private ResultList lazyGround(Formula formula, List<Atom> lazyTargets) {
        if (lazyTargets.size() == 0) {
            throw new IllegalArgumentException();
        }
        RDBMSDatabase relationalDB = (RDBMSDatabase)this.db;
        ArrayList<SelectQuery> queries = new ArrayList<SelectQuery>();
        VariableTypeMap varTypes = formula.collectVariables(new VariableTypeMap());
        Map<Variable, Integer> projectionMap = null;
        for (Atom lazyTarget : lazyTargets) {
            Formula2SQL sqler = new Formula2SQL(varTypes.getVariables(), relationalDB, false, lazyTarget);
            queries.add(sqler.getQuery(formula));
            if (projectionMap != null) continue;
            projectionMap = sqler.getProjectionMap();
        }
        UnionQuery union = new UnionQuery(SetOperationQuery.Type.UNION, queries.toArray(new SelectQuery[0]));
        return relationalDB.executeQuery(projectionMap, varTypes, ((UnionQuery)union.validate()).toString());
    }

    private Set<StandardPredicate> getLazyPredicates(Set<RandomVariableAtom> toActivate) {
        HashSet<StandardPredicate> lazyPredicates = new HashSet<StandardPredicate>();
        for (Atom atom : toActivate) {
            if (!(atom.getPredicate() instanceof StandardPredicate)) continue;
            lazyPredicates.add((StandardPredicate)atom.getPredicate());
        }
        return lazyPredicates;
    }

    private Set<Rule> getLazyRules(List<Rule> rules, Set<StandardPredicate> lazyPredicates) {
        HashSet<Rule> lazyRules = new HashSet<Rule>();
        block0: for (Rule rule : rules) {
            if (rule instanceof AbstractLogicalRule) {
                for (Atom atom : ((AbstractLogicalRule)rule).getNegatedDNF().getQueryFormula().getAtoms(new HashSet<Atom>())) {
                    if (!lazyPredicates.contains(atom.getPredicate())) continue;
                    lazyRules.add(rule);
                    continue block0;
                }
                continue;
            }
            if (rule instanceof AbstractArithmeticRule) {
                for (Predicate predicate : ((AbstractArithmeticRule)rule).getBodyPredicates()) {
                    if (!lazyPredicates.contains(predicate)) continue;
                    lazyRules.add(rule);
                    continue block0;
                }
                continue;
            }
            throw new IllegalStateException("Unknown rule type: " + rule.getClass().getName());
        }
        return lazyRules;
    }
}

