/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.dcd.term;

import org.linqs.psl.config.Options;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.reasoner.dcd.term.DCDObjectiveTerm;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.HyperplaneTermGenerator;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.reasoner.term.VariableTermStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCDTermGenerator
extends HyperplaneTermGenerator<DCDObjectiveTerm, RandomVariableAtom> {
    private static final Logger log = LoggerFactory.getLogger(DCDTermGenerator.class);
    private float c = Options.DCD_C.getFloat();

    @Override
    public Class<RandomVariableAtom> getLocalVariableType() {
        return RandomVariableAtom.class;
    }

    @Override
    public DCDObjectiveTerm createLossTerm(TermStore<DCDObjectiveTerm, RandomVariableAtom> baseTermStore, boolean isHinge, boolean isSquared, GroundRule groundRule, Hyperplane<RandomVariableAtom> hyperplane) {
        VariableTermStore termStore = (VariableTermStore)baseTermStore;
        float weight = (float)((WeightedGroundRule)groundRule).getWeight();
        if (isHinge && isSquared) {
            return new DCDObjectiveTerm(termStore, true, hyperplane, weight, this.c);
        }
        if (isHinge && !isSquared) {
            return new DCDObjectiveTerm(termStore, false, hyperplane, weight, this.c);
        }
        if (!isHinge && isSquared) {
            log.warn("DCD does not support squared linear terms: " + groundRule);
            return null;
        }
        log.warn("DCD does not support linear terms: " + groundRule);
        return null;
    }

    @Override
    public DCDObjectiveTerm createLinearConstraintTerm(TermStore<DCDObjectiveTerm, RandomVariableAtom> termStore, GroundRule groundRule, Hyperplane<RandomVariableAtom> hyperplane, FunctionComparator comparator) {
        log.warn("DCD does not support hard constraints, i.e. " + groundRule);
        return null;
    }
}

