/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term;

import java.lang.reflect.Array;
import org.linqs.psl.reasoner.term.ReasonerLocalVariable;
import org.linqs.psl.util.ArrayUtils;

public class Hyperplane<E extends ReasonerLocalVariable> {
    private E[] variables;
    private float[] coefficients;
    private int size;
    private float constant;

    public Hyperplane(Class<E> localVariableClass, int maxSize, float constant) {
        this((ReasonerLocalVariable[])Array.newInstance(localVariableClass, maxSize), new float[maxSize], constant, 0);
    }

    public Hyperplane(E[] variables, float[] coefficients, float constant, int size) {
        this.variables = variables;
        this.coefficients = coefficients;
        this.constant = constant;
        this.size = size;
    }

    public void addTerm(E variable, float coefficient) {
        this.variables[this.size] = variable;
        this.coefficients[this.size] = coefficient;
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    public E getVariable(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Tried to access variable at index " + index + ", but only " + this.size + " exist.");
        }
        return this.variables[index];
    }

    public float getCoefficient(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Tried to access coefficient at index " + index + ", but only " + this.size + " exist.");
        }
        return this.coefficients[index];
    }

    public void appendCoefficient(int index, float value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Tried to access coefficient at index " + index + ", but only " + this.size + " exist.");
        }
        int n = index;
        this.coefficients[n] = this.coefficients[n] + value;
    }

    public float getConstant() {
        return this.constant;
    }

    public void setConstant(float constant) {
        this.constant = constant;
    }

    public int indexOfVariable(E needle) {
        return ArrayUtils.indexOf(this.variables, this.size, needle);
    }

    public E[] getVariables() {
        return this.variables;
    }

    public float[] getCoefficients() {
        return this.coefficients;
    }
}

